/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.drops.strategy;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.drops.GeneralDropItem;
import com.l2jserver.gameserver.model.drops.GroupedGeneralDropItem;
import com.l2jserver.gameserver.model.drops.IDropItem;
import com.l2jserver.gameserver.model.drops.strategy.IPreciseDeterminationStrategy;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IGroupedItemDropCalculationStrategy {
    public static final Logger LOG = LoggerFactory.getLogger(IGroupedItemDropCalculationStrategy.class);
    public static final IGroupedItemDropCalculationStrategy DEFAULT_STRATEGY = new IGroupedItemDropCalculationStrategy(){
        private final Map<GroupedGeneralDropItem, GeneralDropItem> singleItemCache = new ConcurrentHashMap<GroupedGeneralDropItem, GeneralDropItem>();

        private GeneralDropItem getSingleItem(GroupedGeneralDropItem dropItem) {
            GeneralDropItem item1 = dropItem.getItems().iterator().next();
            this.singleItemCache.putIfAbsent(dropItem, new GeneralDropItem(item1.getItemId(), item1.getMin(), item1.getMax(), item1.getChance() * dropItem.getChance() / 100.0, item1.getAmountStrategy(), item1.getChanceStrategy(), dropItem.getPreciseStrategy(), dropItem.getKillerChanceModifierStrategy(), item1.getDropCalculationStrategy()));
            return this.singleItemCache.get(dropItem);
        }

        @Override
        public List<ItemHolder> calculateDrops(GroupedGeneralDropItem dropItem, L2Character victim, L2Character killer) {
            if (dropItem.getItems().size() == 1) {
                return this.getSingleItem(dropItem).calculateDrops(victim, killer);
            }
            GroupedGeneralDropItem normalized = dropItem.normalizeMe(victim, killer);
            if (normalized.getChance() > Rnd.nextDouble() * 100.0) {
                double random = Rnd.nextDouble() * 100.0;
                double totalChance = 0.0;
                for (GeneralDropItem item2 : normalized.getItems()) {
                    if (!((totalChance += item2.getChance()) > random)) continue;
                    int amountMultiply = 1;
                    if (dropItem.isPreciseCalculated() && normalized.getChance() >= 100.0) {
                        amountMultiply = (int)normalized.getChance() / 100;
                        if (normalized.getChance() % 100.0 > Rnd.nextDouble() * 100.0) {
                            ++amountMultiply;
                        }
                    }
                    return Collections.singletonList(new ItemHolder(item2.getItemId(), Rnd.get((long)item2.getMin(victim), (long)item2.getMax(victim)) * (long)amountMultiply));
                }
            }
            return null;
        }
    };
    public static final IGroupedItemDropCalculationStrategy DISBAND_GROUP = (item, victim, killer) -> {
        ArrayList<ItemHolder> dropped = new ArrayList<ItemHolder>();
        for (IDropItem iDropItem : item.extractMe()) {
            dropped.addAll(iDropItem.calculateDrops(victim, killer));
        }
        return dropped.isEmpty() ? null : dropped;
    };
    public static final IGroupedItemDropCalculationStrategy PRECISE_MULTIPLE_GROUP_ROLLS = (item, victim, killer) -> {
        if (!item.isPreciseCalculated()) {
            return DEFAULT_STRATEGY.calculateDrops(item, victim, victim);
        }
        GroupedGeneralDropItem newItem = new GroupedGeneralDropItem(item.getChance(), DEFAULT_STRATEGY, item.getKillerChanceModifierStrategy(), IPreciseDeterminationStrategy.NEVER);
        newItem.setItems(item.getItems());
        GroupedGeneralDropItem normalized = newItem.normalizeMe(victim, killer);
        int rolls = (int)(normalized.getChance() / 100.0);
        if (Rnd.nextDouble() * 100.0 < normalized.getChance() % 100.0) {
            ++rolls;
        }
        ArrayList<ItemHolder> dropped = new ArrayList<ItemHolder>(rolls);
        for (int i = 0; i < rolls; ++i) {
            List<ItemHolder> drops = normalized.calculateDrops(victim, killer);
            if (drops == null) continue;
            dropped.addAll(drops);
        }
        if (Configuration.general().preciseDropMultipleRollsAggregateDrops()) {
            HashMap<Integer, Long> countByItemId = new HashMap<Integer, Long>();
            for (ItemHolder itemHolder : dropped) {
                Long currentCount = countByItemId.getOrDefault(itemHolder.getId(), 0L);
                countByItemId.put(itemHolder.getId(), currentCount + itemHolder.getCount());
            }
            dropped.clear();
            for (Map.Entry entry : countByItemId.entrySet()) {
                dropped.add(new ItemHolder((Integer)entry.getKey(), (Long)entry.getValue()));
            }
        }
        return dropped.isEmpty() ? null : dropped;
    };

    public List<ItemHolder> calculateDrops(GroupedGeneralDropItem var1, L2Character var2, L2Character var3);
}

