/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.serverpackets.Earthquake;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;

public class DimensionalRift {
    protected byte _type;
    protected L2Party _party;
    protected List<Byte> _completedRooms = new ArrayList<Byte>();
    private static final long seconds_5 = 5000L;
    protected byte jumps_current = 0;
    private final int MAX_DISTANCE = 1500;
    private Timer teleporterTimer;
    private TimerTask teleporterTimerTask;
    private Timer spawnTimer;
    private TimerTask spawnTimerTask;
    private Future<?> earthQuakeTask;
    protected byte _chosenRoom;
    protected List<L2PcInstance> _playerInside = new CopyOnWriteArrayList<L2PcInstance>();
    protected List<L2PcInstance> _deadPlayers = new CopyOnWriteArrayList<L2PcInstance>();
    protected List<L2PcInstance> _revivedInWaitingRoom = new CopyOnWriteArrayList<L2PcInstance>();
    private boolean isBossRoom = false;
    private final int Q00635_IntoTheDimensionalRift = 635;

    public DimensionalRift(L2Npc npc, L2Party party, byte type, byte room) {
        DimensionalRiftManager.getInstance().getRoom(type, room).setParty(party);
        this._type = type;
        this._party = party;
        this._chosenRoom = room;
        party.setDimensionalRift(this);
        for (L2PcInstance pc : party.getMembers()) {
            double distance;
            Quest q635 = QuestManager.getInstance().getQuest(635);
            if (q635 != null) {
                QuestState qs = pc.getQuestState(q635.getName());
                if (qs == null) {
                    qs = q635.newQuestState(pc);
                }
                if (!qs.isStarted()) {
                    qs.setState(1, true);
                }
            }
            if (!((distance = Util.calculateDistance(npc, pc, true, false)) <= 1500.0)) continue;
            this.teleportToRoom(pc, room);
            this._playerInside.add(pc);
        }
        this.createSpawnTimer(this._chosenRoom);
        this.createTeleporterTimer(true);
    }

    public byte getType() {
        return this._type;
    }

    public byte getCurrentRoom() {
        return this._chosenRoom;
    }

    protected void createTeleporterTimer(final boolean reasonTP) {
        if (this._party == null) {
            return;
        }
        if (this.teleporterTimerTask != null) {
            this.teleporterTimerTask.cancel();
            this.teleporterTimerTask = null;
        }
        if (this.teleporterTimer != null) {
            this.teleporterTimer.cancel();
            this.teleporterTimer = null;
        }
        if (this.earthQuakeTask != null) {
            this.earthQuakeTask.cancel(false);
            this.earthQuakeTask = null;
        }
        this.teleporterTimer = new Timer();
        this.teleporterTimerTask = new TimerTask(){

            @Override
            public void run() {
                if (DimensionalRift.this._chosenRoom > -1) {
                    DimensionalRiftManager.getInstance().getRoom(DimensionalRift.this._type, DimensionalRift.this._chosenRoom).unspawn().setParty(null);
                }
                if (reasonTP && DimensionalRift.this.jumps_current < DimensionalRift.this.getMaxJumps() && DimensionalRift.this._party.getMemberCount() > DimensionalRift.this._deadPlayers.size()) {
                    DimensionalRift.this.jumps_current = (byte)(DimensionalRift.this.jumps_current + 1);
                    DimensionalRift.this._completedRooms.add(DimensionalRift.this._chosenRoom);
                    DimensionalRift.this._chosenRoom = (byte)-1;
                    for (L2PcInstance p : DimensionalRift.this._party.getMembers()) {
                        if (DimensionalRift.this._revivedInWaitingRoom.contains(p) || !DimensionalRift.this._playerInside.contains(p)) continue;
                        DimensionalRift.this.teleportToNextRoom(p);
                    }
                    DimensionalRift.this.createTeleporterTimer(true);
                    DimensionalRift.this.createSpawnTimer(DimensionalRift.this._chosenRoom);
                } else {
                    for (L2PcInstance p : DimensionalRift.this._party.getMembers()) {
                        if (DimensionalRift.this._revivedInWaitingRoom.contains(p) || !DimensionalRift.this._playerInside.contains(p)) continue;
                        DimensionalRift.this.teleportToWaitingRoom(p);
                    }
                    DimensionalRift.this.killRift();
                    this.cancel();
                }
            }
        };
        if (reasonTP) {
            long jumpTime = this.calcTimeToNextJump();
            this.teleporterTimer.schedule(this.teleporterTimerTask, jumpTime);
            this.earthQuakeTask = ThreadPoolManager.getInstance().scheduleGeneral(() -> {
                for (L2PcInstance p : this._party.getMembers()) {
                    if (this._revivedInWaitingRoom.contains(p) || !this._playerInside.contains(p)) continue;
                    p.sendPacket(new Earthquake(p.getX(), p.getY(), p.getZ(), 65, 9));
                }
            }, jumpTime - 7000L);
        } else {
            this.teleporterTimer.schedule(this.teleporterTimerTask, 5000L);
        }
    }

    public void createSpawnTimer(final byte room) {
        if (this.spawnTimerTask != null) {
            this.spawnTimerTask.cancel();
            this.spawnTimerTask = null;
        }
        if (this.spawnTimer != null) {
            this.spawnTimer.cancel();
            this.spawnTimer = null;
        }
        this.spawnTimer = new Timer();
        this.spawnTimerTask = new TimerTask(){

            @Override
            public void run() {
                DimensionalRiftManager.getInstance().getRoom(DimensionalRift.this._type, room).spawn();
            }
        };
        this.spawnTimer.schedule(this.spawnTimerTask, Configuration.general().getRiftSpawnDelay());
    }

    public void partyMemberInvited() {
        this.createTeleporterTimer(false);
    }

    public void partyMemberExited(L2PcInstance player) {
        this._deadPlayers.remove(player);
        this._revivedInWaitingRoom.remove(player);
        this.killRift();
    }

    public void manualTeleport(L2PcInstance player) {
        if (!player.isInParty() || !player.getParty().isInDimensionalRift()) {
            return;
        }
        DimensionalRiftManager.getInstance().getRoom(this._type, this._chosenRoom).unspawn().setParty(null);
        this._completedRooms.add(this._chosenRoom);
        this._chosenRoom = (byte)-1;
        for (L2PcInstance p : this._party.getMembers()) {
            if (!this._playerInside.contains(p)) continue;
            this.teleportToNextRoom(p);
        }
        DimensionalRiftManager.getInstance().getRoom(this._type, this._chosenRoom).setParty(player.getParty());
        this.createSpawnTimer(this._chosenRoom);
        this.createTeleporterTimer(true);
    }

    public void manualExitRift(L2PcInstance player) {
        if (!player.isInParty() || !player.getParty().isInDimensionalRift()) {
            return;
        }
        for (L2PcInstance p : player.getParty().getMembers()) {
            if (!this._playerInside.contains(p)) continue;
            this.teleportToWaitingRoom(p);
        }
        this.killRift();
    }

    protected void teleportToNextRoom(L2PcInstance player) {
        if (this._chosenRoom == -1) {
            do {
                List<Byte> emptyRooms = DimensionalRiftManager.getInstance().getFreeRooms(this._type);
                emptyRooms.removeAll(this._completedRooms);
                if (emptyRooms.isEmpty()) {
                    emptyRooms = DimensionalRiftManager.getInstance().getFreeRooms(this._type);
                }
                this._chosenRoom = emptyRooms.get(Rnd.get((int)1, (int)emptyRooms.size()) - 1);
            } while (DimensionalRiftManager.getInstance().getRoom(this._type, this._chosenRoom).getParty() != null);
        }
        DimensionalRiftManager.getInstance().getRoom(this._type, this._chosenRoom).setParty(player.getParty());
        this.checkBossRoom(this._chosenRoom);
        this.teleportToRoom(player, this._chosenRoom);
    }

    protected void teleportToWaitingRoom(L2PcInstance player) {
        DimensionalRiftManager.getInstance().teleportToWaitingRoom(player);
    }

    public void killRift() {
        this._completedRooms.clear();
        if (this._party != null) {
            this._party.setDimensionalRift(null);
        }
        this._party = null;
        this._playerInside = null;
        this._revivedInWaitingRoom = null;
        this._deadPlayers = null;
        if (this.earthQuakeTask != null) {
            this.earthQuakeTask.cancel(false);
            this.earthQuakeTask = null;
        }
        DimensionalRiftManager.getInstance().getRoom(this._type, this._chosenRoom).unspawn().setParty(null);
        DimensionalRiftManager.getInstance().killRift(this);
    }

    public Timer getTeleportTimer() {
        return this.teleporterTimer;
    }

    public TimerTask getTeleportTimerTask() {
        return this.teleporterTimerTask;
    }

    public Timer getSpawnTimer() {
        return this.spawnTimer;
    }

    public TimerTask getSpawnTimerTask() {
        return this.spawnTimerTask;
    }

    public void setTeleportTimer(Timer t) {
        this.teleporterTimer = t;
    }

    public void setTeleportTimerTask(TimerTask tt) {
        this.teleporterTimerTask = tt;
    }

    public void setSpawnTimer(Timer t) {
        this.spawnTimer = t;
    }

    public void setSpawnTimerTask(TimerTask st) {
        this.spawnTimerTask = st;
    }

    private long calcTimeToNextJump() {
        int time = Rnd.get((int)((int)Configuration.general().getAutoJumpsDelayMin()), (int)((int)Configuration.general().getAutoJumpsDelayMax()));
        if (this.isBossRoom) {
            return (long)((float)time * Configuration.general().getBossRoomTimeMultiply());
        }
        return time;
    }

    public void memberDead(L2PcInstance player) {
        if (!this._deadPlayers.contains(player)) {
            this._deadPlayers.add(player);
        }
    }

    public void memberResurrected(L2PcInstance player) {
        this._deadPlayers.remove(player);
    }

    public List<L2PcInstance> getDeadMemberList() {
        return this._deadPlayers;
    }

    public List<L2PcInstance> getRevivedAtWaitingRoom() {
        return this._revivedInWaitingRoom;
    }

    public void checkBossRoom(byte room) {
        this.isBossRoom = DimensionalRiftManager.getInstance().getRoom(this._type, room).isBossRoom();
    }

    public Location getRoomCoord(byte room) {
        return DimensionalRiftManager.getInstance().getRoom(this._type, room).getTeleportCoordinates();
    }

    public int getMaxJumps() {
        if (Configuration.general().getMaxRiftJumps() <= 8 && Configuration.general().getMaxRiftJumps() >= 1) {
            return Configuration.general().getMaxRiftJumps();
        }
        return 4;
    }

    private void teleportToRoom(L2PcInstance player, byte room) {
        Location coords = this.getRoomCoord(room);
        player.teleToLocation(coords.getX() + Rnd.get((int)-150, (int)150), coords.getY() + Rnd.get((int)-150, (int)150), coords.getZ());
    }
}

