/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TvTEventTeam {
    private final String _name;
    private final Location _loc;
    private short _points;
    private final Map<Integer, L2PcInstance> _participatedPlayers = new ConcurrentHashMap<Integer, L2PcInstance>();

    public TvTEventTeam(String name, Location loc) {
        this._name = name;
        this._loc = loc;
        this._points = 0;
    }

    public boolean addPlayer(L2PcInstance playerInstance) {
        if (playerInstance == null) {
            return false;
        }
        this._participatedPlayers.put(playerInstance.getObjectId(), playerInstance);
        return true;
    }

    public void removePlayer(int playerObjectId) {
        this._participatedPlayers.remove(playerObjectId);
    }

    public void increasePoints() {
        this._points = (short)(this._points + 1);
    }

    public void cleanMe() {
        this._participatedPlayers.clear();
        this._points = 0;
    }

    public boolean containsPlayer(int playerObjectId) {
        return this._participatedPlayers.containsKey(playerObjectId);
    }

    public String getName() {
        return this._name;
    }

    public Location getLocation() {
        return this._loc;
    }

    public short getPoints() {
        return this._points;
    }

    public Map<Integer, L2PcInstance> getParticipatedPlayers() {
        return this._participatedPlayers;
    }

    public int getParticipatedPlayerCount() {
        return this._participatedPlayers.size();
    }
}

