/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.util.Broadcast;
import java.util.Calendar;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TvTManager {
    private static final Logger LOG = LoggerFactory.getLogger(TvTManager.class);
    private TvTStartTask _task;

    protected TvTManager() {
        if (Configuration.tvt().enabled()) {
            TvTEvent.init();
            this.scheduleEventStart();
            LOG.info("Started.");
        } else {
            LOG.info("Engine is disabled.");
        }
    }

    public static TvTManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void scheduleEventStart() {
        try {
            Calendar currentTime = Calendar.getInstance();
            Calendar nextStartTime = null;
            for (String timeOfDay : Configuration.tvt().getInterval()) {
                Calendar testStartTime = Calendar.getInstance();
                testStartTime.setLenient(true);
                String[] splitTimeOfDay = timeOfDay.split(":");
                testStartTime.set(11, Integer.parseInt(splitTimeOfDay[0]));
                testStartTime.set(12, Integer.parseInt(splitTimeOfDay[1]));
                if (testStartTime.getTimeInMillis() < currentTime.getTimeInMillis()) {
                    testStartTime.add(5, 1);
                }
                if (nextStartTime != null && testStartTime.getTimeInMillis() >= nextStartTime.getTimeInMillis()) continue;
                nextStartTime = testStartTime;
            }
            if (nextStartTime != null) {
                this._task = new TvTStartTask(nextStartTime.getTimeInMillis());
                ThreadPoolManager.getInstance().executeGeneral(this._task);
            }
        }
        catch (Exception ex) {
            LOG.warn("There has been an error figuring out a start time. Check TvTEventInterval in config file.", ex);
        }
    }

    public void startReg() {
        if (!TvTEvent.startParticipation()) {
            Broadcast.toAllOnlinePlayers("TvT Event: Event was cancelled.");
            LOG.warn("There has been an error spawning event NPC for participation.");
            this.scheduleEventStart();
        } else {
            Broadcast.toAllOnlinePlayers("TvT Event: Registration opened for " + Configuration.tvt().getParticipationTime() + " minute(s).");
            this._task.setStartTime(System.currentTimeMillis() + 60000L * (long)Configuration.tvt().getParticipationTime());
            ThreadPoolManager.getInstance().executeGeneral(this._task);
        }
    }

    public void startEvent() {
        if (!TvTEvent.startFight()) {
            Broadcast.toAllOnlinePlayers("TvT Event: Event cancelled due to lack of Participation.");
            LOG.info("Lack of registration, abort event.");
            this.scheduleEventStart();
        } else {
            TvTEvent.sysMsgToAllParticipants("TvT Event: Teleporting participants to an arena in " + TimeUnit.MILLISECONDS.toSeconds(Configuration.tvt().getStartLeaveTeleportDelay()) + " second(s).");
            this._task.setStartTime(System.currentTimeMillis() + 60000L * (long)Configuration.tvt().getRunningTime());
            ThreadPoolManager.getInstance().executeGeneral(this._task);
        }
    }

    public void endEvent() {
        Broadcast.toAllOnlinePlayers(TvTEvent.calculateRewards());
        TvTEvent.sysMsgToAllParticipants("TvT Event: Teleporting back to the registration npc in " + TimeUnit.MILLISECONDS.toSeconds(Configuration.tvt().getStartLeaveTeleportDelay()) + " second(s).");
        TvTEvent.stopFight();
        this.scheduleEventStart();
    }

    public void skipDelay() {
        if (this._task.nextRun.cancel(false)) {
            this._task.setStartTime(System.currentTimeMillis());
            ThreadPoolManager.getInstance().executeGeneral(this._task);
        }
    }

    private static class SingletonHolder {
        protected static final TvTManager INSTANCE = new TvTManager();

        private SingletonHolder() {
        }
    }

    class TvTStartTask
    implements Runnable {
        private long _startTime;
        public ScheduledFuture<?> nextRun;

        public TvTStartTask(long startTime) {
            this._startTime = startTime;
        }

        public void setStartTime(long startTime) {
            this._startTime = startTime;
        }

        @Override
        public void run() {
            int delay = (int)Math.round((double)(this._startTime - System.currentTimeMillis()) / 1000.0);
            if (delay > 0) {
                this.announce(delay);
            }
            int nextMsg = 0;
            if (delay > 3600) {
                nextMsg = delay - 3600;
            } else if (delay > 1800) {
                nextMsg = delay - 1800;
            } else if (delay > 900) {
                nextMsg = delay - 900;
            } else if (delay > 600) {
                nextMsg = delay - 600;
            } else if (delay > 300) {
                nextMsg = delay - 300;
            } else if (delay > 60) {
                nextMsg = delay - 60;
            } else if (delay > 5) {
                nextMsg = delay - 5;
            } else if (delay > 0) {
                nextMsg = delay;
            } else if (TvTEvent.isInactive()) {
                TvTManager.this.startReg();
            } else if (TvTEvent.isParticipating()) {
                TvTManager.this.startEvent();
            } else {
                TvTManager.this.endEvent();
            }
            if (delay > 0) {
                this.nextRun = ThreadPoolManager.getInstance().scheduleGeneral(this, nextMsg * 1000);
            }
        }

        private void announce(long time) {
            if (time >= 3600L && time % 3600L == 0L) {
                if (TvTEvent.isParticipating()) {
                    Broadcast.toAllOnlinePlayers("TvT Event: " + time / 60L / 60L + " hour(s) until registration is closed!");
                } else if (TvTEvent.isStarted()) {
                    TvTEvent.sysMsgToAllParticipants("TvT Event: " + time / 60L / 60L + " hour(s) until event is finished!");
                }
            } else if (time >= 60L) {
                if (TvTEvent.isParticipating()) {
                    Broadcast.toAllOnlinePlayers("TvT Event: " + time / 60L + " minute(s) until registration is closed!");
                } else if (TvTEvent.isStarted()) {
                    TvTEvent.sysMsgToAllParticipants("TvT Event: " + time / 60L + " minute(s) until the event is finished!");
                }
            } else if (TvTEvent.isParticipating()) {
                Broadcast.toAllOnlinePlayers("TvT Event: " + time + " second(s) until registration is closed!");
            } else if (TvTEvent.isStarted()) {
                TvTEvent.sysMsgToAllParticipants("TvT Event: " + time + " second(s) until the event is finished!");
            }
        }
    }
}

