/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.instancezone;

import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class InstanceWorld {
    private int _instanceId;
    private int _templateId = -1;
    private final List<Integer> _allowed = new CopyOnWriteArrayList<Integer>();
    private final AtomicInteger _status = new AtomicInteger();

    public List<Integer> getAllowed() {
        return this._allowed;
    }

    public void removeAllowed(int id) {
        this._allowed.remove((Object)id);
    }

    public void addAllowed(int id) {
        this._allowed.add(id);
    }

    public boolean isAllowed(int id) {
        return this._allowed.contains(id);
    }

    public int getInstanceId() {
        return this._instanceId;
    }

    public void setInstanceId(int instanceId) {
        this._instanceId = instanceId;
    }

    public int getTemplateId() {
        return this._templateId;
    }

    public void setTemplateId(int templateId) {
        this._templateId = templateId;
    }

    public int getStatus() {
        return this._status.get();
    }

    public boolean isStatus(int status) {
        return this._status.get() == status;
    }

    public void setStatus(int status) {
        this._status.set(status);
    }

    public void incStatus() {
        this._status.incrementAndGet();
    }

    public void onDeath(L2Character killer, L2Character victim) {
        Instance instance;
        if (victim != null && victim.isPlayer() && (instance = InstanceManager.getInstance().getInstance(this.getInstanceId())) != null) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_WILL_BE_EXPELLED_IN_S1);
            sm.addInt(instance.getEjectTime() / 60 / 1000);
            victim.getActingPlayer().sendPacket(sm);
            instance.addEjectDeadTask(victim.getActingPlayer());
        }
    }
}

