/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemcontainer;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ItemContainer {
    private static final Logger LOG = LoggerFactory.getLogger(ItemContainer.class);
    protected final List<L2ItemInstance> _items = new CopyOnWriteArrayList<L2ItemInstance>();

    protected ItemContainer() {
    }

    protected abstract L2Character getOwner();

    protected abstract ItemLocation getBaseLocation();

    public String getName() {
        return "ItemContainer";
    }

    public int getOwnerId() {
        return this.getOwner() == null ? 0 : this.getOwner().getObjectId();
    }

    public int getSize() {
        return this._items.size();
    }

    public L2ItemInstance[] getItems() {
        return this._items.toArray(new L2ItemInstance[0]);
    }

    public L2ItemInstance getItemByItemId(int itemId) {
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getId() != itemId) continue;
            return item;
        }
        return null;
    }

    public final boolean haveItemForSelfResurrection() {
        for (L2ItemInstance item : this._items) {
            if (item == null || !item.getItem().isAllowSelfResurrection()) continue;
            return true;
        }
        return false;
    }

    public List<L2ItemInstance> getItemsByItemId(int itemId) {
        LinkedList<L2ItemInstance> returnList = new LinkedList<L2ItemInstance>();
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getId() != itemId) continue;
            returnList.add(item);
        }
        return returnList;
    }

    public L2ItemInstance getItemByItemId(int itemId, L2ItemInstance itemToIgnore) {
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getId() != itemId || item.equals(itemToIgnore)) continue;
            return item;
        }
        return null;
    }

    public L2ItemInstance getItemByObjectId(int objectId) {
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getObjectId() != objectId) continue;
            return item;
        }
        return null;
    }

    public long getInventoryItemCount(int itemId, int enchantLevel) {
        return this.getInventoryItemCount(itemId, enchantLevel, true);
    }

    public long getInventoryItemCount(int itemId, int enchantLevel, boolean includeEquipped) {
        long count = 0L;
        for (L2ItemInstance item : this._items) {
            if (item.getId() != itemId || item.getEnchantLevel() != enchantLevel && enchantLevel >= 0 || !includeEquipped && item.isEquipped()) continue;
            if (item.isStackable()) {
                count = item.getCount();
                continue;
            }
            ++count;
        }
        return count;
    }

    public L2ItemInstance addItem(String process, L2ItemInstance item, L2PcInstance actor, Object reference) {
        L2ItemInstance olditem = this.getItemByItemId(item.getId());
        if (olditem != null && olditem.isStackable()) {
            long count = item.getCount();
            olditem.changeCount(process, count, actor, reference);
            olditem.setLastChange(2);
            ItemTable.getInstance().destroyItem(process, item, actor, reference);
            item.updateDatabase();
            item = olditem;
            float adenaRate = Configuration.rates().getDropAmountMultiplierByItemId().getOrDefault(57, Float.valueOf(1.0f)).floatValue();
            if (item.getId() == 57 && (float)count < 10000.0f * adenaRate) {
                if (GameTimeController.getInstance().getGameTicks() % 5 == 0) {
                    item.updateDatabase();
                }
            } else {
                item.updateDatabase();
            }
        } else {
            item.setOwnerId(process, this.getOwnerId(), actor, reference);
            item.setItemLocation(this.getBaseLocation());
            item.setLastChange(1);
            this.addItem(item);
            item.updateDatabase();
        }
        this.refreshWeight();
        return item;
    }

    public L2ItemInstance addItem(String process, int itemId, L2PcInstance actor, Object reference) {
        return this.addItem(process, itemId, 1L, -1, actor, reference);
    }

    public L2ItemInstance addItem(String process, int itemId, long count, L2PcInstance actor, Object reference) {
        return this.addItem(process, itemId, count, -1, actor, reference);
    }

    public L2ItemInstance addItem(String process, int itemId, long count, int enchantLevel, L2PcInstance actor, Object reference) {
        L2ItemInstance item = this.getItemByItemId(itemId);
        if (item != null && item.isStackable()) {
            item.changeCount(process, count, actor, reference);
            item.setLastChange(2);
            if (enchantLevel > -1) {
                item.setEnchantLevel(enchantLevel);
            }
            float adenaRate = Configuration.rates().getDropAmountMultiplierByItemId().getOrDefault(57, Float.valueOf(1.0f)).floatValue();
            if (itemId == 57 && (float)count < 10000.0f * adenaRate) {
                if (GameTimeController.getInstance().getGameTicks() % 5 == 0) {
                    item.updateDatabase();
                }
            } else {
                item.updateDatabase();
            }
        } else {
            int i = 0;
            while ((long)i < count) {
                L2Item template = ItemTable.getInstance().getTemplate(itemId);
                if (template == null) {
                    LOG.warn("{}Invalid ItemId requested: {}", actor != null ? "[" + actor.getName() + "] " : "", (Object)itemId);
                    return null;
                }
                item = ItemTable.getInstance().createItem(process, itemId, template.isStackable() ? count : 1L, actor, reference);
                item.setOwnerId(this.getOwnerId());
                item.setItemLocation(this.getBaseLocation());
                item.setLastChange(1);
                item.setEnchantLevel(enchantLevel > -1 ? enchantLevel : template.getDefaultEnchantLevel());
                this.addItem(item);
                item.updateDatabase();
                if (template.isStackable() || !Configuration.general().multipleItemDrop()) break;
                ++i;
            }
        }
        this.refreshWeight();
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance transferItem(String process, int objectId, long count, ItemContainer target, L2PcInstance actor, Object reference) {
        if (target == null) {
            return null;
        }
        L2ItemInstance sourceitem = this.getItemByObjectId(objectId);
        if (sourceitem == null) {
            return null;
        }
        L2ItemInstance targetitem = sourceitem.isStackable() ? target.getItemByItemId(sourceitem.getId()) : null;
        L2ItemInstance l2ItemInstance = sourceitem;
        synchronized (l2ItemInstance) {
            if (this.getItemByObjectId(objectId) != sourceitem) {
                return null;
            }
            if (count > sourceitem.getCount()) {
                count = sourceitem.getCount();
            }
            if (sourceitem.getCount() == count && targetitem == null) {
                this.removeItem(sourceitem);
                target.addItem(process, sourceitem, actor, reference);
                targetitem = sourceitem;
            } else {
                if (sourceitem.getCount() > count) {
                    sourceitem.changeCount(process, -count, actor, reference);
                } else {
                    this.removeItem(sourceitem);
                    ItemTable.getInstance().destroyItem(process, sourceitem, actor, reference);
                }
                if (targetitem != null) {
                    targetitem.changeCount(process, count, actor, reference);
                } else {
                    targetitem = target.addItem(process, sourceitem.getId(), count, actor, reference);
                }
            }
            sourceitem.updateDatabase(true);
            if (targetitem != sourceitem && targetitem != null) {
                targetitem.updateDatabase();
            }
            if (sourceitem.isAugmented()) {
                sourceitem.getAugmentation().removeBonus(actor);
            }
            this.refreshWeight();
            target.refreshWeight();
        }
        return targetitem;
    }

    public L2ItemInstance destroyItem(String process, L2ItemInstance item, L2PcInstance actor, Object reference) {
        return this.destroyItem(process, item, item.getCount(), actor, reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance destroyItem(String process, L2ItemInstance item, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance l2ItemInstance = item;
        synchronized (l2ItemInstance) {
            if (item.getCount() > count) {
                item.changeCount(process, -count, actor, reference);
                item.setLastChange(2);
                if (process != null || GameTimeController.getInstance().getGameTicks() % 10 == 0) {
                    item.updateDatabase();
                }
                this.refreshWeight();
            } else {
                if (item.getCount() < count) {
                    return null;
                }
                boolean removed = this.removeItem(item);
                if (!removed) {
                    return null;
                }
                ItemTable.getInstance().destroyItem(process, item, actor, reference);
                item.updateDatabase();
                this.refreshWeight();
            }
            item.deleteMe();
        }
        return item;
    }

    public L2ItemInstance destroyItem(String process, int objectId, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance item = this.getItemByObjectId(objectId);
        if (item == null) {
            return null;
        }
        return this.destroyItem(process, item, count, actor, reference);
    }

    public L2ItemInstance destroyItemByItemId(String process, int itemId, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance item = this.getItemByItemId(itemId);
        if (item == null) {
            return null;
        }
        return this.destroyItem(process, item, count, actor, reference);
    }

    public void destroyAllItems(String process, L2PcInstance actor, Object reference) {
        for (L2ItemInstance item : this._items) {
            if (item == null) continue;
            this.destroyItem(process, item, actor, reference);
        }
    }

    public long getAdena() {
        long count = 0L;
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getId() != 57) continue;
            count = item.getCount();
            return count;
        }
        return count;
    }

    protected void addItem(L2ItemInstance item) {
        this._items.add(item);
    }

    protected boolean removeItem(L2ItemInstance item) {
        return this._items.remove(item);
    }

    protected void refreshWeight() {
    }

    public void deleteMe() {
        if (this.getOwner() != null) {
            for (L2ItemInstance item : this._items) {
                if (item == null) continue;
                item.updateDatabase(true);
                item.deleteMe();
                L2World.getInstance().removeObject(item);
            }
        }
        this._items.clear();
    }

    public void updateDatabase() {
        if (this.getOwner() != null) {
            for (L2ItemInstance item : this._items) {
                if (item == null) continue;
                item.updateDatabase(true);
            }
        }
    }

    public void restore() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT object_id, item_id, count, enchant_level, loc, loc_data, custom_type1, custom_type2, mana_left, time, agathion_energy FROM items WHERE owner_id=? AND (loc=?)");){
            ps.setInt(1, this.getOwnerId());
            ps.setString(2, this.getBaseLocation().name());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    L2PcInstance owner;
                    L2ItemInstance item = L2ItemInstance.restoreFromDb(this.getOwnerId(), rs);
                    if (item == null) continue;
                    L2World.getInstance().storeObject(item);
                    L2PcInstance l2PcInstance = owner = this.getOwner() == null ? null : this.getOwner().getActingPlayer();
                    if (item.isStackable() && this.getItemByItemId(item.getId()) != null) {
                        this.addItem("Restore", item, owner, null);
                        continue;
                    }
                    this.addItem(item);
                }
            }
            this.refreshWeight();
        }
        catch (Exception e) {
            LOG.warn("Could not restore container:", e);
        }
    }

    public boolean validateCapacity(long slots) {
        return true;
    }

    public boolean validateWeight(long weight) {
        return true;
    }

    public boolean validateCapacityByItemId(int itemId, long count) {
        L2Item template = ItemTable.getInstance().getTemplate(itemId);
        return template == null || (template.isStackable() ? this.validateCapacity(1L) : this.validateCapacity(count));
    }

    public boolean validateWeightByItemId(int itemId, long count) {
        L2Item template = ItemTable.getInstance().getTemplate(itemId);
        return template == null || this.validateWeight((long)template.getWeight() * count);
    }
}

