/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemcontainer;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.ArmorSetsData;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.model.L2ArmorSet;
import com.l2jserver.gameserver.model.TradeItem;
import com.l2jserver.gameserver.model.TradeList;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.player.inventory.PlayerItemAdd;
import com.l2jserver.gameserver.model.events.impl.character.player.inventory.PlayerItemDestroy;
import com.l2jserver.gameserver.model.events.impl.character.player.inventory.PlayerItemDrop;
import com.l2jserver.gameserver.model.events.impl.character.player.inventory.PlayerItemTransfer;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.WeaponType;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.SkillCoolTime;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcInventory
extends Inventory {
    private static final Logger LOG = LoggerFactory.getLogger(PcInventory.class);
    private final L2PcInstance _owner;
    private L2ItemInstance _adena;
    private L2ItemInstance _ancientAdena;
    private int[] _blockItems = null;
    private int _questSlots;
    private final Object _lock;
    private int _blockMode = -1;

    public PcInventory(L2PcInstance owner) {
        this.addPaperdollListener(ArmorSetListener.getInstance());
        this.addPaperdollListener(BowCrossRodListener.getInstance());
        this.addPaperdollListener(ItemSkillsListener.getInstance());
        this.addPaperdollListener(BraceletListener.getInstance());
        this._owner = owner;
        this._lock = new Object();
    }

    @Override
    public L2PcInstance getOwner() {
        return this._owner;
    }

    @Override
    protected ItemLocation getBaseLocation() {
        return ItemLocation.INVENTORY;
    }

    @Override
    protected ItemLocation getEquipLocation() {
        return ItemLocation.PAPERDOLL;
    }

    public L2ItemInstance getAdenaInstance() {
        return this._adena;
    }

    @Override
    public long getAdena() {
        return this._adena != null ? this._adena.getCount() : 0L;
    }

    public L2ItemInstance getAncientAdenaInstance() {
        return this._ancientAdena;
    }

    public long getAncientAdena() {
        return this._ancientAdena != null ? this._ancientAdena.getCount() : 0L;
    }

    public L2ItemInstance[] getUniqueItems(boolean allowAdena, boolean allowAncientAdena) {
        return this.getUniqueItems(allowAdena, allowAncientAdena, true);
    }

    public L2ItemInstance[] getUniqueItems(boolean allowAdena, boolean allowAncientAdena, boolean onlyAvailable) {
        LinkedList<L2ItemInstance> list = new LinkedList<L2ItemInstance>();
        for (L2ItemInstance item : this._items) {
            if (item == null || !allowAdena && item.getId() == 57 || !allowAncientAdena && item.getId() == 5575) continue;
            boolean isDuplicate = false;
            for (L2ItemInstance litem : list) {
                if (litem.getId() != item.getId()) continue;
                isDuplicate = true;
                break;
            }
            if (isDuplicate || onlyAvailable && (!item.isSellable() || !item.isAvailable(this.getOwner(), false, false))) continue;
            list.add(item);
        }
        return list.toArray(new L2ItemInstance[0]);
    }

    public L2ItemInstance[] getUniqueItemsByEnchantLevel(boolean allowAdena, boolean allowAncientAdena) {
        return this.getUniqueItemsByEnchantLevel(allowAdena, allowAncientAdena, true);
    }

    public L2ItemInstance[] getUniqueItemsByEnchantLevel(boolean allowAdena, boolean allowAncientAdena, boolean onlyAvailable) {
        LinkedList<L2ItemInstance> list = new LinkedList<L2ItemInstance>();
        for (L2ItemInstance item : this._items) {
            if (item == null || !allowAdena && item.getId() == 57 || !allowAncientAdena && item.getId() == 5575) continue;
            boolean isDuplicate = false;
            for (L2ItemInstance litem : list) {
                if (litem.getId() != item.getId() || litem.getEnchantLevel() != item.getEnchantLevel()) continue;
                isDuplicate = true;
                break;
            }
            if (isDuplicate || onlyAvailable && (!item.isSellable() || !item.isAvailable(this.getOwner(), false, false))) continue;
            list.add(item);
        }
        return list.toArray(new L2ItemInstance[list.size()]);
    }

    public L2ItemInstance[] getAllItemsByItemId(int itemId) {
        return this.getAllItemsByItemId(itemId, true);
    }

    public L2ItemInstance[] getAllItemsByItemId(int itemId, boolean includeEquipped) {
        LinkedList<L2ItemInstance> list = new LinkedList<L2ItemInstance>();
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getId() != itemId || !includeEquipped && item.isEquipped()) continue;
            list.add(item);
        }
        return list.toArray(new L2ItemInstance[0]);
    }

    public L2ItemInstance[] getAllItemsByItemId(int itemId, int enchantment) {
        return this.getAllItemsByItemId(itemId, enchantment, true);
    }

    public L2ItemInstance[] getAllItemsByItemId(int itemId, int enchantment, boolean includeEquipped) {
        LinkedList<L2ItemInstance> list = new LinkedList<L2ItemInstance>();
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getId() != itemId || item.getEnchantLevel() != enchantment || !includeEquipped && item.isEquipped()) continue;
            list.add(item);
        }
        return list.toArray(new L2ItemInstance[0]);
    }

    public L2ItemInstance[] getAvailableItems(boolean allowAdena, boolean allowNonTradeable, boolean feightable) {
        LinkedList<L2ItemInstance> list = new LinkedList<L2ItemInstance>();
        for (L2ItemInstance item : this._items) {
            if (item == null || !item.isAvailable(this.getOwner(), allowAdena, allowNonTradeable) || !this.canManipulateWithItemId(item.getId())) continue;
            if (feightable) {
                if (item.getItemLocation() != ItemLocation.INVENTORY || !item.isFreightable()) continue;
                list.add(item);
                continue;
            }
            list.add(item);
        }
        return list.toArray(new L2ItemInstance[0]);
    }

    public L2ItemInstance[] getAugmentedItems() {
        LinkedList<L2ItemInstance> list = new LinkedList<L2ItemInstance>();
        for (L2ItemInstance item : this._items) {
            if (item == null || !item.isAugmented()) continue;
            list.add(item);
        }
        return list.toArray(new L2ItemInstance[0]);
    }

    public L2ItemInstance[] getElementItems() {
        LinkedList<L2ItemInstance> list = new LinkedList<L2ItemInstance>();
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getElementals() == null) continue;
            list.add(item);
        }
        return list.toArray(new L2ItemInstance[0]);
    }

    public TradeItem[] getAvailableItems(TradeList tradeList) {
        LinkedList<TradeItem> list = new LinkedList<TradeItem>();
        for (L2ItemInstance item : this._items) {
            TradeItem adjItem;
            if (item == null || !item.isAvailable(this.getOwner(), false, false) || (adjItem = tradeList.adjustAvailableItem(item)) == null) continue;
            list.add(adjItem);
        }
        return list.toArray(new TradeItem[0]);
    }

    public void adjustAvailableItem(TradeItem item) {
        boolean notAllEquipped = false;
        for (L2ItemInstance adjItem : this.getItemsByItemId(item.getItem().getId())) {
            if (adjItem.isEquipable()) {
                if (adjItem.isEquipped()) continue;
                notAllEquipped |= true;
                continue;
            }
            notAllEquipped |= true;
            break;
        }
        if (notAllEquipped) {
            L2ItemInstance adjItem = this.getItemByItemId(item.getItem().getId());
            item.setObjectId(adjItem.getObjectId());
            item.setEnchant(adjItem.getEnchantLevel());
            if (adjItem.getCount() < item.getCount()) {
                item.setCount(adjItem.getCount());
            }
            return;
        }
        item.setCount(0L);
    }

    public void addAdena(String process, long count, L2PcInstance actor, Object reference) {
        if (count > 0L) {
            this.addItem(process, 57, count, actor, reference);
        }
    }

    public boolean reduceAdena(String process, long count, L2PcInstance actor, Object reference) {
        if (count > 0L) {
            return this.destroyItemByItemId(process, 57, count, actor, reference) != null;
        }
        return false;
    }

    public void addAncientAdena(String process, long count, L2PcInstance actor, Object reference) {
        if (count > 0L) {
            this.addItem(process, 5575, count, actor, reference);
        }
    }

    public boolean reduceAncientAdena(String process, long count, L2PcInstance actor, Object reference) {
        if (count > 0L) {
            return this.destroyItemByItemId(process, 5575, count, actor, reference) != null;
        }
        return false;
    }

    @Override
    public L2ItemInstance addItem(String process, L2ItemInstance item, L2PcInstance actor, Object reference) {
        if ((item = super.addItem(process, item, actor, reference)) != null && item.getId() == 57 && !item.equals(this._adena)) {
            this._adena = item;
        }
        if (item != null && item.getId() == 5575 && !item.equals(this._ancientAdena)) {
            this._ancientAdena = item;
        }
        if (item != null) {
            EventDispatcher.getInstance().notifyEventAsync(new PlayerItemAdd(actor, item), actor, item.getItem());
        }
        return item;
    }

    @Override
    public L2ItemInstance addItem(String process, int itemId, long count, int enchantLevel, L2PcInstance actor, Object reference) {
        L2ItemInstance item = super.addItem(process, itemId, count, enchantLevel, actor, reference);
        if (item != null) {
            if (item.getId() == 57 && !item.equals(this._adena)) {
                this._adena = item;
            }
            if (item.getId() == 5575 && !item.equals(this._ancientAdena)) {
                this._ancientAdena = item;
            }
            if (actor != null) {
                if (!Configuration.general().forceInventoryUpdate()) {
                    InventoryUpdate playerIU = new InventoryUpdate();
                    playerIU.addItem(item);
                    actor.sendPacket(playerIU);
                } else {
                    actor.sendPacket(new ItemList(actor, false));
                }
                StatusUpdate su = new StatusUpdate(actor);
                su.addAttribute(14, actor.getCurrentLoad());
                actor.sendPacket(su);
                EventDispatcher.getInstance().notifyEventAsync(new PlayerItemAdd(actor, item), actor, item.getItem());
            }
        }
        return item;
    }

    @Override
    public L2ItemInstance transferItem(String process, int objectId, long count, ItemContainer target, L2PcInstance actor, Object reference) {
        L2ItemInstance item = super.transferItem(process, objectId, count, target, actor, reference);
        if (this._adena != null && (this._adena.getCount() <= 0L || this._adena.getOwnerId() != this.getOwnerId())) {
            this._adena = null;
        }
        if (this._ancientAdena != null && (this._ancientAdena.getCount() <= 0L || this._ancientAdena.getOwnerId() != this.getOwnerId())) {
            this._ancientAdena = null;
        }
        EventDispatcher.getInstance().notifyEventAsync(new PlayerItemTransfer(actor, item, target), item.getItem());
        return item;
    }

    @Override
    public L2ItemInstance destroyItem(String process, L2ItemInstance item, L2PcInstance actor, Object reference) {
        return this.destroyItem(process, item, item.getCount(), actor, reference);
    }

    @Override
    public L2ItemInstance destroyItem(String process, L2ItemInstance item, long count, L2PcInstance actor, Object reference) {
        item = super.destroyItem(process, item, count, actor, reference);
        if (this._adena != null && this._adena.getCount() <= 0L) {
            this._adena = null;
        }
        if (this._ancientAdena != null && this._ancientAdena.getCount() <= 0L) {
            this._ancientAdena = null;
        }
        if (item != null) {
            EventDispatcher.getInstance().notifyEventAsync(new PlayerItemDestroy(actor, item), item.getItem());
        }
        return item;
    }

    @Override
    public L2ItemInstance destroyItem(String process, int objectId, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance item = this.getItemByObjectId(objectId);
        if (item == null) {
            return null;
        }
        return this.destroyItem(process, item, count, actor, reference);
    }

    @Override
    public L2ItemInstance destroyItemByItemId(String process, int itemId, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance item = this.getItemByItemId(itemId);
        if (item == null) {
            return null;
        }
        return this.destroyItem(process, item, count, actor, reference);
    }

    @Override
    public L2ItemInstance dropItem(String process, L2ItemInstance item, L2PcInstance actor, Object reference) {
        item = super.dropItem(process, item, actor, reference);
        if (this._adena != null && (this._adena.getCount() <= 0L || this._adena.getOwnerId() != this.getOwnerId())) {
            this._adena = null;
        }
        if (this._ancientAdena != null && (this._ancientAdena.getCount() <= 0L || this._ancientAdena.getOwnerId() != this.getOwnerId())) {
            this._ancientAdena = null;
        }
        if (item != null) {
            EventDispatcher.getInstance().notifyEventAsync(new PlayerItemDrop(actor, item, item.getLocation()), item.getItem());
        }
        return item;
    }

    @Override
    public L2ItemInstance dropItem(String process, int objectId, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance item = super.dropItem(process, objectId, count, actor, reference);
        if (this._adena != null && (this._adena.getCount() <= 0L || this._adena.getOwnerId() != this.getOwnerId())) {
            this._adena = null;
        }
        if (this._ancientAdena != null && (this._ancientAdena.getCount() <= 0L || this._ancientAdena.getOwnerId() != this.getOwnerId())) {
            this._ancientAdena = null;
        }
        if (item != null) {
            EventDispatcher.getInstance().notifyEventAsync(new PlayerItemDrop(actor, item, item.getLocation()), item.getItem());
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean removeItem(L2ItemInstance item) {
        this.getOwner().removeItemFromShortCut(item.getObjectId());
        if (item.getObjectId() == this.getOwner().getActiveEnchantItemId()) {
            this.getOwner().setActiveEnchantItemId(-1);
        }
        if (item.getId() == 57) {
            this._adena = null;
        } else if (item.getId() == 5575) {
            this._ancientAdena = null;
        }
        if (item.isQuestItem()) {
            Object object = this._lock;
            synchronized (object) {
                --this._questSlots;
                if (this._questSlots < 0) {
                    this._questSlots = 0;
                    LOG.warn("QuestInventory size < 0!");
                }
            }
        }
        return super.removeItem(item);
    }

    @Override
    public void refreshWeight() {
        super.refreshWeight();
        this.getOwner().refreshOverloaded();
    }

    @Override
    public void restore() {
        super.restore();
        this._adena = this.getItemByItemId(57);
        this._ancientAdena = this.getItemByItemId(5575);
    }

    public static int[][] restoreVisibleInventory(int objectId) {
        int[][] paperdoll = new int[31][3];
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT object_id, item_id, loc_data, enchant_level FROM items WHERE owner_id=? AND loc='PAPERDOLL'");){
            ps.setInt(1, objectId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int slot = rs.getInt("loc_data");
                    paperdoll[slot][0] = rs.getInt("object_id");
                    paperdoll[slot][1] = rs.getInt("item_id");
                    paperdoll[slot][2] = rs.getInt("enchant_level");
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Could not restore inventory: {}", (Object)e.getMessage(), (Object)e);
        }
        return paperdoll;
    }

    public boolean checkInventorySlotsAndWeight(List<L2Item> itemList, boolean sendMessage, boolean sendSkillMessage) {
        boolean inventoryStatusOK;
        int lootWeight = 0;
        int requiredSlots = 0;
        if (itemList != null) {
            for (L2Item item : itemList) {
                if (!item.isStackable() || this.getInventoryItemCount(item.getId(), -1) <= 0L) {
                    ++requiredSlots;
                }
                lootWeight += item.getWeight();
            }
        }
        boolean bl = inventoryStatusOK = this.validateCapacity(requiredSlots) && this.validateWeight(lootWeight);
        if (!inventoryStatusOK && sendMessage) {
            this._owner.sendPacket(SystemMessageId.SLOTS_FULL);
            if (sendSkillMessage) {
                this._owner.sendPacket(SystemMessageId.WEIGHT_EXCEEDED_SKILL_UNAVAILABLE);
            }
        }
        return inventoryStatusOK;
    }

    public boolean validateCapacity(L2ItemInstance item) {
        if (item.getItem().hasExImmediateEffect() || item.isStackable() && this.getInventoryItemCount(item.getId(), -1) > 0L) {
            return true;
        }
        return this.validateCapacity(1L, item.isQuestItem());
    }

    public boolean validateCapacityByItemId(int itemId) {
        L2ItemInstance invItem = this.getItemByItemId(itemId);
        if (invItem == null || !invItem.isStackable() || this.getInventoryItemCount(itemId, -1) <= 0L) {
            this.validateCapacity(1L, ItemTable.getInstance().getTemplate(itemId).isQuestItem());
        }
        return true;
    }

    @Override
    public boolean validateCapacity(long slots) {
        return this.validateCapacity(slots, false);
    }

    public boolean validateCapacity(long slots, boolean questItem) {
        if (!questItem) {
            return (long)(this._items.size() - this._questSlots) + slots <= (long)this._owner.getInventoryLimit();
        }
        return (long)this._questSlots + slots <= (long)this._owner.getQuestInventoryLimit();
    }

    @Override
    public boolean validateWeight(long weight) {
        if (this._owner.isGM() && this._owner.getDietMode() && this._owner.getAccessLevel().allowTransaction()) {
            return true;
        }
        return (long)this._totalWeight + weight <= (long)this._owner.getMaxLoad();
    }

    public void setInventoryBlock(int[] items, int mode) {
        this._blockMode = mode;
        this._blockItems = items;
        this._owner.sendPacket(new ItemList(this._owner, false));
    }

    public void unblock() {
        this._blockMode = -1;
        this._blockItems = null;
        this._owner.sendPacket(new ItemList(this._owner, false));
    }

    public boolean hasInventoryBlock() {
        return this._blockMode > -1 && this._blockItems != null && this._blockItems.length > 0;
    }

    public void blockAllItems() {
        this.setInventoryBlock(new int[]{ItemTable.getInstance().getArraySize() + 2}, 1);
    }

    public int getBlockMode() {
        return this._blockMode;
    }

    public int[] getBlockItems() {
        return this._blockItems;
    }

    public boolean canManipulateWithItemId(int itemId) {
        return !(this._blockMode == 0 && Util.contains(this._blockItems, itemId) || this._blockMode == 1 && !Util.contains(this._blockItems, itemId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addItem(L2ItemInstance item) {
        if (item.isQuestItem()) {
            Object object = this._lock;
            synchronized (object) {
                ++this._questSlots;
            }
        }
        super.addItem(item);
    }

    public int getSize(boolean quest) {
        if (quest) {
            return this._questSlots;
        }
        return this.getSize() - this._questSlots;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this._owner) + "]";
    }

    public void applyItemSkills() {
        for (L2ItemInstance item : this._items) {
            item.giveSkillsToOwner();
            item.applyEnchantStats();
        }
    }

    private static final class ArmorSetListener
    implements Inventory.PaperdollListener {
        private static final ArmorSetListener instance = new ArmorSetListener();

        private ArmorSetListener() {
        }

        public static ArmorSetListener getInstance() {
            return instance;
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item, Inventory inventory) {
            L2Character l2Character = inventory.getOwner();
            if (!(l2Character instanceof L2PcInstance)) {
                return;
            }
            L2PcInstance player = (L2PcInstance)l2Character;
            L2ItemInstance chestItem = inventory.getPaperdollItem(6);
            if (chestItem == null) {
                return;
            }
            if (!ArmorSetsData.getInstance().isArmorSet(chestItem.getId())) {
                return;
            }
            L2ArmorSet armorSet = ArmorSetsData.getInstance().getSet(chestItem.getId());
            boolean update = false;
            boolean updateTimeStamp = false;
            if (armorSet.containItem(slot, item.getId())) {
                if (armorSet.containAll(player)) {
                    List<SkillHolder> skills = armorSet.getSkills();
                    if (skills != null) {
                        for (SkillHolder holder : skills) {
                            Skill itemSkill = holder.getSkill();
                            if (itemSkill != null) {
                                player.addSkill(itemSkill, false);
                                if (itemSkill.isActive()) {
                                    int equipDelay;
                                    if (!player.hasSkillReuse(itemSkill.getReuseHashCode()) && (equipDelay = item.getEquipReuseDelay()) > 0) {
                                        player.addTimeStamp(itemSkill, equipDelay);
                                        player.disableSkill(itemSkill, equipDelay);
                                    }
                                    updateTimeStamp = true;
                                }
                                update = true;
                                continue;
                            }
                            LOG.warn("Inventory.ArmorSetListener: Incorrect skill: {}.", (Object)holder);
                        }
                    }
                    if (armorSet.containShield(player)) {
                        for (SkillHolder holder : armorSet.getShieldSkillId()) {
                            if (holder.getSkill() != null) {
                                player.addSkill(holder.getSkill(), false);
                                update = true;
                                continue;
                            }
                            LOG.warn("Inventory.ArmorSetListener: Incorrect skill: {}.", (Object)holder);
                        }
                    }
                    if (armorSet.isEnchanted6(player)) {
                        for (SkillHolder holder : armorSet.getEnchant6skillId()) {
                            if (holder.getSkill() != null) {
                                player.addSkill(holder.getSkill(), false);
                                update = true;
                                continue;
                            }
                            LOG.warn("Inventory.ArmorSetListener: Incorrect skill: {}.", (Object)holder);
                        }
                    }
                }
            } else if (armorSet.containShield(item.getId())) {
                for (SkillHolder holder : armorSet.getShieldSkillId()) {
                    if (holder.getSkill() != null) {
                        player.addSkill(holder.getSkill(), false);
                        update = true;
                        continue;
                    }
                    LOG.warn("Inventory.ArmorSetListener: Incorrect skill: {}.", (Object)holder);
                }
            }
            if (update) {
                player.sendSkillList();
                if (updateTimeStamp) {
                    player.sendPacket(new SkillCoolTime(player));
                }
            }
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item, Inventory inventory) {
            L2Character l2Character = inventory.getOwner();
            if (!(l2Character instanceof L2PcInstance)) {
                return;
            }
            L2PcInstance player = (L2PcInstance)l2Character;
            boolean remove = false;
            List<SkillHolder> skills = null;
            List<SkillHolder> shieldSkill = null;
            List<SkillHolder> skillId6 = null;
            if (slot == 6) {
                if (!ArmorSetsData.getInstance().isArmorSet(item.getId())) {
                    return;
                }
                L2ArmorSet armorSet = ArmorSetsData.getInstance().getSet(item.getId());
                remove = true;
                skills = armorSet.getSkills();
                shieldSkill = armorSet.getShieldSkillId();
                skillId6 = armorSet.getEnchant6skillId();
            } else {
                L2ItemInstance chestItem = inventory.getPaperdollItem(6);
                if (chestItem == null) {
                    return;
                }
                L2ArmorSet armorSet = ArmorSetsData.getInstance().getSet(chestItem.getId());
                if (armorSet == null) {
                    return;
                }
                if (armorSet.containItem(slot, item.getId())) {
                    remove = true;
                    skills = armorSet.getSkills();
                    shieldSkill = armorSet.getShieldSkillId();
                    skillId6 = armorSet.getEnchant6skillId();
                } else if (armorSet.containShield(item.getId())) {
                    remove = true;
                    shieldSkill = armorSet.getShieldSkillId();
                }
            }
            if (remove) {
                Skill itemSkill;
                if (skills != null) {
                    for (SkillHolder holder : skills) {
                        itemSkill = holder.getSkill();
                        if (itemSkill != null) {
                            player.removeSkill(itemSkill, false, itemSkill.isPassive());
                            continue;
                        }
                        LOG.warn("Inventory.ArmorSetListener: Incorrect skill: {}.", (Object)holder);
                    }
                }
                if (shieldSkill != null) {
                    for (SkillHolder holder : shieldSkill) {
                        itemSkill = holder.getSkill();
                        if (itemSkill != null) {
                            player.removeSkill(itemSkill, false, itemSkill.isPassive());
                            continue;
                        }
                        LOG.warn("Inventory.ArmorSetListener: Incorrect skill: {}.", (Object)holder);
                    }
                }
                if (skillId6 != null) {
                    for (SkillHolder holder : skillId6) {
                        itemSkill = holder.getSkill();
                        if (itemSkill != null) {
                            player.removeSkill(itemSkill, false, itemSkill.isPassive());
                            continue;
                        }
                        LOG.warn("Inventory.ArmorSetListener: Incorrect skill: {}.", (Object)holder);
                    }
                }
                player.checkItemRestriction();
                player.sendSkillList();
            }
        }
    }

    private static final class BowCrossRodListener
    implements Inventory.PaperdollListener {
        private static final BowCrossRodListener instance = new BowCrossRodListener();

        private BowCrossRodListener() {
        }

        public static BowCrossRodListener getInstance() {
            return instance;
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item, Inventory inventory) {
            L2ItemInstance lure;
            if (slot != 5) {
                return;
            }
            if (item.getItemType() == WeaponType.BOW) {
                L2ItemInstance arrow = inventory.getPaperdollItem(7);
                if (arrow != null) {
                    inventory.setPaperdollItem(7, null);
                }
            } else if (item.getItemType() == WeaponType.CROSSBOW) {
                L2ItemInstance bolts = inventory.getPaperdollItem(7);
                if (bolts != null) {
                    inventory.setPaperdollItem(7, null);
                }
            } else if (item.getItemType() == WeaponType.FISHINGROD && (lure = inventory.getPaperdollItem(7)) != null) {
                inventory.setPaperdollItem(7, null);
            }
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item, Inventory inventory) {
            L2ItemInstance bolts;
            if (slot != 5) {
                return;
            }
            if (item.getItemType() == WeaponType.BOW) {
                L2ItemInstance arrow = inventory.findArrowForBow(item.getItem());
                if (arrow != null) {
                    inventory.setPaperdollItem(7, arrow);
                }
            } else if (item.getItemType() == WeaponType.CROSSBOW && (bolts = inventory.findBoltForCrossBow(item.getItem())) != null) {
                inventory.setPaperdollItem(7, bolts);
            }
        }
    }

    private static final class ItemSkillsListener
    implements Inventory.PaperdollListener {
        private static final ItemSkillsListener instance = new ItemSkillsListener();

        private ItemSkillsListener() {
        }

        public static ItemSkillsListener getInstance() {
            return instance;
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item, Inventory inventory) {
            Skill unequipSkill;
            Skill itemSkill;
            Skill enchant4Skill;
            if (!(inventory.getOwner() instanceof L2PcInstance)) {
                return;
            }
            L2PcInstance player = (L2PcInstance)inventory.getOwner();
            L2Item it = item.getItem();
            boolean update = false;
            boolean updateTimeStamp = false;
            if (item.isAugmented()) {
                item.getAugmentation().removeBonus(player);
            }
            item.unChargeAllShots();
            item.removeElementAttrBonus(player);
            if (item.getEnchantLevel() >= 4 && (enchant4Skill = it.getEnchant4Skill()) != null) {
                player.removeSkill(enchant4Skill, false, enchant4Skill.isPassive());
                update = true;
            }
            item.clearEnchantStats();
            SkillHolder[] skills = it.getSkills();
            if (skills != null) {
                for (SkillHolder skillInfo : skills) {
                    if (skillInfo == null) continue;
                    itemSkill = skillInfo.getSkill();
                    if (itemSkill != null) {
                        player.removeSkill(itemSkill, false, itemSkill.isPassive());
                        update = true;
                        continue;
                    }
                    LOG.warn("Inventory.ItemSkillsListener.Weapon: Incorrect skill: {}.", (Object)skillInfo);
                }
            }
            if (item.isArmor()) {
                for (L2ItemInstance itm : inventory.getItems()) {
                    if (!itm.isEquipped() || itm.getItem().getSkills() == null || itm.equals(item)) continue;
                    for (SkillHolder sk : itm.getItem().getSkills()) {
                        if (player.getSkillLevel(sk.getSkillId()) != -1 || (itemSkill = sk.getSkill()) == null) continue;
                        player.addSkill(itemSkill, false);
                        if (itemSkill.isActive()) {
                            int equipDelay;
                            if (!player.hasSkillReuse(itemSkill.getReuseHashCode()) && (equipDelay = item.getEquipReuseDelay()) > 0) {
                                player.addTimeStamp(itemSkill, equipDelay);
                                player.disableSkill(itemSkill, equipDelay);
                            }
                            updateTimeStamp = true;
                        }
                        update = true;
                    }
                }
            }
            if ((unequipSkill = it.getUnequipSkill()) != null) {
                unequipSkill.activateSkill((L2Character)player, player);
            }
            if (update) {
                player.sendSkillList();
                if (updateTimeStamp) {
                    player.sendPacket(new SkillCoolTime(player));
                }
            }
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item, Inventory inventory) {
            Skill enchant4Skill;
            if (!(inventory.getOwner() instanceof L2PcInstance)) {
                return;
            }
            L2PcInstance player = (L2PcInstance)inventory.getOwner();
            L2Item it = item.getItem();
            boolean update = false;
            boolean updateTimeStamp = false;
            if (item.isAugmented()) {
                item.getAugmentation().applyBonus(player);
            }
            item.rechargeShots(true, true);
            item.updateElementAttrBonus(player);
            if (item.getEnchantLevel() >= 4 && (enchant4Skill = it.getEnchant4Skill()) != null) {
                player.addSkill(enchant4Skill, false);
                update = true;
            }
            item.applyEnchantStats();
            SkillHolder[] skills = it.getSkills();
            if (skills != null) {
                for (SkillHolder skillInfo : skills) {
                    if (skillInfo == null) continue;
                    Skill itemSkill = skillInfo.getSkill();
                    if (itemSkill != null) {
                        itemSkill.setReferenceItemId(item.getId());
                        player.addSkill(itemSkill, false);
                        if (itemSkill.isActive()) {
                            int equipDelay;
                            if (!player.hasSkillReuse(itemSkill.getReuseHashCode()) && (equipDelay = item.getEquipReuseDelay()) > 0) {
                                player.addTimeStamp(itemSkill, equipDelay);
                                player.disableSkill(itemSkill, equipDelay);
                            }
                            updateTimeStamp = true;
                        }
                        update = true;
                        continue;
                    }
                    LOG.warn("Inventory.ItemSkillsListener.Weapon: Incorrect skill: {}.", (Object)skillInfo);
                }
            }
            if (update) {
                player.sendSkillList();
                if (updateTimeStamp) {
                    player.sendPacket(new SkillCoolTime(player));
                }
            }
        }
    }

    private static final class BraceletListener
    implements Inventory.PaperdollListener {
        private static final BraceletListener instance = new BraceletListener();

        private BraceletListener() {
        }

        public static BraceletListener getInstance() {
            return instance;
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item, Inventory inventory) {
            if (item.getItem().getBodyPart() == 0x100000) {
                inventory.unEquipItemInSlot(17);
                inventory.unEquipItemInSlot(18);
                inventory.unEquipItemInSlot(19);
                inventory.unEquipItemInSlot(20);
                inventory.unEquipItemInSlot(21);
                inventory.unEquipItemInSlot(22);
            }
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item, Inventory inventory) {
        }
    }
}

