/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.items.instance;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.agathion.Agathion;
import com.l2jserver.gameserver.agathion.repository.AgathionRepository;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.EnchantItemOptionsData;
import com.l2jserver.gameserver.data.xml.impl.OptionData;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.enums.ShotType;
import com.l2jserver.gameserver.instancemanager.ItemsOnGroundManager;
import com.l2jserver.gameserver.instancemanager.MercTicketManager;
import com.l2jserver.gameserver.model.DropProtection;
import com.l2jserver.gameserver.model.Elementals;
import com.l2jserver.gameserver.model.L2Augmentation;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.NullKnownList;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerAugment;
import com.l2jserver.gameserver.model.events.impl.character.player.inventory.PlayerItemDrop;
import com.l2jserver.gameserver.model.events.impl.character.player.inventory.PlayerItemPickup;
import com.l2jserver.gameserver.model.events.impl.item.ItemBypass;
import com.l2jserver.gameserver.model.events.impl.item.ItemTalk;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.items.L2Armor;
import com.l2jserver.gameserver.model.items.L2EtcItem;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.type.EtcItemType;
import com.l2jserver.gameserver.model.items.type.ItemType;
import com.l2jserver.gameserver.model.items.type.ItemType1;
import com.l2jserver.gameserver.model.items.type.ItemType2;
import com.l2jserver.gameserver.model.options.EnchantOptions;
import com.l2jserver.gameserver.model.options.Options;
import com.l2jserver.gameserver.model.stats.functions.AbstractFunction;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.DropItem;
import com.l2jserver.gameserver.network.serverpackets.GetItem;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SpawnItem;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.GMAudit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class L2ItemInstance
extends L2Object {
    private static final Logger LOG = LoggerFactory.getLogger(L2ItemInstance.class);
    private static final Logger LOG_ITEM = LoggerFactory.getLogger("item");
    private int _ownerId;
    private int _dropperObjectId = 0;
    private long _count;
    private long _initCount;
    private long _time;
    private boolean _decrease = false;
    private final int _itemId;
    private final L2Item _item;
    private ItemLocation _loc;
    private int _locData;
    private int _enchantLevel;
    private boolean _wear;
    private L2Augmentation _augmentation = null;
    private int _mana;
    private boolean _consumingMana = false;
    private static final int MANA_CONSUMPTION_RATE = 60000;
    private int _type1;
    private int _type2;
    private long _dropTime;
    private boolean _published = false;
    private boolean _protected;
    public static final int UNCHANGED = 0;
    public static final int ADDED = 1;
    public static final int REMOVED = 3;
    public static final int MODIFIED = 2;
    public static final int[] DEFAULT_ENCHANT_OPTIONS = new int[]{0, 0, 0};
    private int _lastChange = 2;
    private boolean _existsInDb;
    private boolean _storedInDb;
    private final ReentrantLock _dbLock = new ReentrantLock();
    private Elementals[] _elementals = null;
    private ScheduledFuture<?> itemLootSchedule = null;
    private ScheduledFuture<?> _lifeTimeTask;
    private final DropProtection _dropProtection = new DropProtection();
    private int _shotsMask = 0;
    private final List<Options> _enchantOptions = new ArrayList<Options>();
    private int agathionEnergy;

    public L2ItemInstance(int objectId, int itemId) {
        super(objectId);
        this.setInstanceType(InstanceType.L2ItemInstance);
        this._itemId = itemId;
        this._item = ItemTable.getInstance().getTemplate(itemId);
        if (this._itemId == 0 || this._item == null) {
            throw new IllegalArgumentException();
        }
        super.setName(this._item.getName());
        this.setCount(1L);
        this._loc = ItemLocation.VOID;
        this._type1 = 0;
        this._type2 = 0;
        this._dropTime = 0L;
        this._mana = this._item.getDuration();
        this._time = this._item.getTime() == -1 ? -1L : System.currentTimeMillis() + (long)this._item.getTime() * 60L * 1000L;
        this.scheduleLifeTimeTask();
        Agathion agathionInfo = AgathionRepository.getInstance().getByItemId(itemId);
        this.agathionEnergy = agathionInfo == null ? 0 : agathionInfo.getMaxEnergy();
    }

    public L2ItemInstance(int objectId, L2Item item) {
        super(objectId);
        this.setInstanceType(InstanceType.L2ItemInstance);
        this._itemId = item.getId();
        this._item = item;
        if (this._itemId == 0) {
            throw new IllegalArgumentException();
        }
        super.setName(this._item.getName());
        this.setCount(1L);
        this._loc = ItemLocation.VOID;
        this._mana = this._item.getDuration();
        this._time = this._item.getTime() == -1 ? -1L : System.currentTimeMillis() + (long)this._item.getTime() * 60L * 1000L;
        this.scheduleLifeTimeTask();
        Agathion agathionInfo = AgathionRepository.getInstance().getByItemId(item.getId());
        this.agathionEnergy = agathionInfo == null ? 0 : agathionInfo.getMaxEnergy();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new NullKnownList(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pickupMe(L2Character player) {
        assert (this.getWorldRegion() != null);
        L2WorldRegion oldregion = this.getWorldRegion();
        player.broadcastPacket(new GetItem(this, player.getObjectId()));
        L2ItemInstance l2ItemInstance = this;
        synchronized (l2ItemInstance) {
            this.setIsVisible(false);
            this.setWorldRegion(null);
        }
        int itemId = this.getId();
        if (MercTicketManager.getInstance().getTicketCastleId(itemId) > 0) {
            MercTicketManager.getInstance().removeTicket(this);
            ItemsOnGroundManager.getInstance().removeObject(this);
        }
        L2World.getInstance().removeVisibleObject(this, oldregion);
        if (player.isPlayer()) {
            EventDispatcher.getInstance().notifyEventAsync(new PlayerItemPickup(player.getActingPlayer(), this), player, this.getItem());
        }
    }

    public void setOwnerId(String process, int owner_id, L2PcInstance creator, Object reference) {
        this.setOwnerId(owner_id);
        if (Configuration.general().logItems() && (!Configuration.general().logItemsSmallLog() || Configuration.general().logItemsSmallLog() && (this.getItem().isEquipable() || this.getItem().getId() == 57)) && this.getItemType() != EtcItemType.ARROW && this.getItemType() != EtcItemType.SHOT) {
            LOG_ITEM.info("SET_OWNER {} by {}, referenced by {}.", this, creator, reference);
        }
        if (creator != null && creator.isGM()) {
            String targetName;
            String referenceName = "no-reference";
            if (reference instanceof L2Object) {
                referenceName = ((L2Object)reference).getName() != null ? ((L2Object)reference).getName() : "no-name";
            } else if (reference instanceof String) {
                referenceName = (String)reference;
            }
            String string = targetName = creator.getTarget() != null ? creator.getTarget().getName() : "no-target";
            if (Configuration.general().gmAudit()) {
                GMAudit.auditGMAction(creator.getName() + " [" + creator.getObjectId() + "]", process + "(id: " + this.getId() + " name: " + this.getName() + ")", targetName, "L2Object referencing this action is: " + referenceName);
            }
        }
    }

    public void setOwnerId(int owner_id) {
        if (owner_id == this._ownerId) {
            return;
        }
        this.removeSkillsFromOwner();
        this._ownerId = owner_id;
        this._storedInDb = false;
        this.giveSkillsToOwner();
    }

    public int getOwnerId() {
        return this._ownerId;
    }

    public void setItemLocation(ItemLocation loc) {
        this.setItemLocation(loc, 0);
    }

    public void setItemLocation(ItemLocation loc, int loc_data) {
        if (loc == this._loc && loc_data == this._locData) {
            return;
        }
        this.removeSkillsFromOwner();
        this._loc = loc;
        this._locData = loc_data;
        this._storedInDb = false;
        this.giveSkillsToOwner();
    }

    public ItemLocation getItemLocation() {
        return this._loc;
    }

    public void setCount(long count) {
        if (this.getCount() == count) {
            return;
        }
        this._count = count >= -1L ? count : 0L;
        this._storedInDb = false;
    }

    public long getCount() {
        return this._count;
    }

    public void changeCount(String process, long count, L2PcInstance creator, Object reference) {
        long max;
        if (count == 0L) {
            return;
        }
        long old = this.getCount();
        long l = max = this.getId() == 57 ? Configuration.character().getMaxAdena() : Integer.MAX_VALUE;
        if (count > 0L && this.getCount() > max - count) {
            this.setCount(max);
        } else {
            this.setCount(this.getCount() + count);
        }
        if (this.getCount() < 0L) {
            this.setCount(0L);
        }
        this._storedInDb = false;
        if (Configuration.general().logItems() && process != null && (!Configuration.general().logItemsSmallLog() || Configuration.general().logItemsSmallLog() && (this._item.isEquipable() || this._item.getId() == 57)) && this.getItemType() != EtcItemType.ARROW && this.getItemType() != EtcItemType.SHOT) {
            LOG_ITEM.info("CHANGED {} amount {} by {}, referenced by {}.", this, old, creator, reference);
        }
        if (creator != null && creator.isGM()) {
            String targetName;
            String referenceName = "no-reference";
            if (reference instanceof L2Object) {
                referenceName = ((L2Object)reference).getName() != null ? ((L2Object)reference).getName() : "no-name";
            } else if (reference instanceof String) {
                referenceName = (String)reference;
            }
            String string = targetName = creator.getTarget() != null ? creator.getTarget().getName() : "no-target";
            if (Configuration.general().gmAudit()) {
                GMAudit.auditGMAction(creator.getName() + " [" + creator.getObjectId() + "]", process + "(id: " + this.getId() + " objId: " + this.getObjectId() + " name: " + this.getName() + " count: " + count + ")", targetName, "L2Object referencing this action is: " + referenceName);
            }
        }
    }

    public void changeCountWithoutTrace(int count, L2PcInstance creator, Object reference) {
        this.changeCount(null, count, creator, reference);
    }

    public int isEnchantable() {
        if (this.getItemLocation() == ItemLocation.INVENTORY || this.getItemLocation() == ItemLocation.PAPERDOLL) {
            return this.getItem().isEnchantable();
        }
        return 0;
    }

    public boolean isEquipable() {
        return this._item.getBodyPart() != 0 && this._item.getItemType() != EtcItemType.ARROW && this._item.getItemType() != EtcItemType.BOLT && this._item.getItemType() != EtcItemType.LURE;
    }

    public boolean isEquipped() {
        return this._loc == ItemLocation.PAPERDOLL || this._loc == ItemLocation.PET_EQUIP;
    }

    public int getLocationSlot() {
        assert (this._loc == ItemLocation.PAPERDOLL || this._loc == ItemLocation.PET_EQUIP || this._loc == ItemLocation.INVENTORY || this._loc == ItemLocation.MAIL || this._loc == ItemLocation.FREIGHT);
        return this._locData;
    }

    public L2Item getItem() {
        return this._item;
    }

    public int getCustomType1() {
        return this._type1;
    }

    public int getCustomType2() {
        return this._type2;
    }

    public void setCustomType1(int newtype) {
        this._type1 = newtype;
    }

    public void setCustomType2(int newtype) {
        this._type2 = newtype;
    }

    public void setDropTime(long time) {
        this._dropTime = time;
    }

    public long getDropTime() {
        return this._dropTime;
    }

    public ItemType getItemType() {
        return this._item.getItemType();
    }

    @Override
    public int getId() {
        return this._itemId;
    }

    public int getDisplayId() {
        return this.getItem().getDisplayId();
    }

    public boolean isEtcItem() {
        return this._item instanceof L2EtcItem;
    }

    public boolean isWeapon() {
        return this._item instanceof L2Weapon;
    }

    public boolean isArmor() {
        return this._item instanceof L2Armor;
    }

    public L2EtcItem getEtcItem() {
        if (this._item instanceof L2EtcItem) {
            return (L2EtcItem)this._item;
        }
        return null;
    }

    public L2Weapon getWeaponItem() {
        if (this._item instanceof L2Weapon) {
            return (L2Weapon)this._item;
        }
        return null;
    }

    public L2Armor getArmorItem() {
        if (this._item instanceof L2Armor) {
            return (L2Armor)this._item;
        }
        return null;
    }

    public int getCrystalCount() {
        return this._item.getCrystalCount(this._enchantLevel);
    }

    public int getReferencePrice() {
        return this._item.getReferencePrice();
    }

    public String getItemName() {
        return this._item.getName();
    }

    public int getReuseDelay() {
        return this._item.getReuseDelay();
    }

    public int getSharedReuseGroup() {
        return this._item.getSharedReuseGroup();
    }

    public int getLastChange() {
        return this._lastChange;
    }

    public void setLastChange(int lastChange) {
        this._lastChange = lastChange;
    }

    public boolean isStackable() {
        return this._item.isStackable();
    }

    public boolean isDroppable() {
        return !this.isAugmented() && this._item.isDroppable();
    }

    public boolean isDestroyable() {
        return this._item.isDestroyable();
    }

    public boolean isTradeable() {
        return !this.isAugmented() && this._item.isTradeable();
    }

    public boolean isSellable() {
        return !this.isAugmented() && this._item.isSellable();
    }

    public boolean isDepositable(boolean isPrivateWareHouse) {
        if (this.isEquipped() || !this._item.isDepositable()) {
            return false;
        }
        if (!isPrivateWareHouse) {
            return this.isTradeable() && !this.isShadowItem();
        }
        return true;
    }

    public boolean isPotion() {
        return this._item.isPotion();
    }

    public boolean isElixir() {
        return this._item.isElixir();
    }

    public boolean isScroll() {
        return this._item.isScroll();
    }

    public boolean isHeroItem() {
        return this._item.isHeroItem();
    }

    public boolean isCommonItem() {
        return this._item.isCommon();
    }

    public boolean isPvp() {
        return this._item.isPvpItem();
    }

    public boolean isOlyRestrictedItem() {
        return this.getItem().isOlyRestrictedItem();
    }

    public boolean isAvailable(L2PcInstance player, boolean allowAdena, boolean allowNonTradeable) {
        return !(this.isEquipped() || this.getItem().getType2() == ItemType2.QUEST || this.getItem().getType2() == ItemType2.MONEY && this.getItem().getType1() == ItemType1.SHIELD_ARMOR || player.hasSummon() && this.getObjectId() == player.getSummon().getControlObjectId() || player.getActiveEnchantItemId() == this.getObjectId() || player.getActiveEnchantSupportItemId() == this.getObjectId() || player.getActiveEnchantAttrItemId() == this.getObjectId() || !allowAdena && this.getId() == 57 || player.getCurrentSkill() != null && player.getCurrentSkill().getSkill().getItemConsumeId() == this.getId() || player.isCastingSimultaneouslyNow() && player.getLastSimultaneousSkillCast() != null && player.getLastSimultaneousSkillCast().getItemConsumeId() == this.getId() || !allowNonTradeable && (!this.isTradeable() || this.getItem().getItemType() == EtcItemType.PET_COLLAR && player.havePetInvItems()));
    }

    public int getEnchantLevel() {
        return this._enchantLevel;
    }

    public void setEnchantLevel(int enchantLevel) {
        if (this._enchantLevel == enchantLevel) {
            return;
        }
        this.clearEnchantStats();
        this._enchantLevel = enchantLevel;
        this.applyEnchantStats();
        this._storedInDb = false;
    }

    public boolean isAugmented() {
        return this._augmentation != null;
    }

    public L2Augmentation getAugmentation() {
        return this._augmentation;
    }

    public boolean setAugmentation(L2Augmentation augmentation) {
        if (this._augmentation != null) {
            LOG.warn("Augment set for {} by owner {}!", (Object)this, (Object)this.getActingPlayer());
            return false;
        }
        this._augmentation = augmentation;
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            this.updateItemAttributes(con);
        }
        catch (Exception ex) {
            LOG.warn("Could not update atributes for item {} from database!", (Object)this, (Object)ex);
        }
        EventDispatcher.getInstance().notifyEventAsync(new PlayerAugment(this.getActingPlayer(), this, augmentation, true), this.getItem());
        return true;
    }

    public void removeAugmentation() {
        if (this._augmentation == null) {
            return;
        }
        L2Augmentation augment = this._augmentation;
        this._augmentation = null;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM item_attributes WHERE itemId = ?");){
            ps.setInt(1, this.getObjectId());
            ps.executeUpdate();
        }
        catch (Exception ex) {
            LOG.warn("Could not remove augmentation for item {} from database!", (Object)this, (Object)ex);
        }
        EventDispatcher.getInstance().notifyEventAsync(new PlayerAugment(this.getActingPlayer(), this, augment, false), this.getItem());
    }

    public void restoreAttributes() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps1 = con.prepareStatement("SELECT augAttributes FROM item_attributes WHERE itemId=?");
             PreparedStatement ps2 = con.prepareStatement("SELECT elemType,elemValue FROM item_elementals WHERE itemId=?");){
            ps1.setInt(1, this.getObjectId());
            try (ResultSet rs = ps1.executeQuery();){
                int aug_attributes;
                if (rs.next() && (aug_attributes = rs.getInt(1)) != -1) {
                    this._augmentation = new L2Augmentation(rs.getInt("augAttributes"));
                }
            }
            ps2.setInt(1, this.getObjectId());
            rs = ps2.executeQuery();
            try {
                while (rs.next()) {
                    byte elem_type = rs.getByte(1);
                    int elem_value = rs.getInt(2);
                    if (elem_type == -1 || elem_value == -1) continue;
                    this.applyAttribute(elem_type, elem_value);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not restore augmentation and elemental data for item {} from database!", (Object)this, (Object)ex);
        }
    }

    private void updateItemAttributes(Connection con) {
        try (PreparedStatement ps = con.prepareStatement("REPLACE INTO item_attributes VALUES(?,?)");){
            ps.setInt(1, this.getObjectId());
            ps.setInt(2, this._augmentation != null ? this._augmentation.getAttributes() : -1);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            LOG.warn("Could not update atributes for item {} from database!", (Object)this, (Object)ex);
        }
    }

    private void updateItemElements(Connection con) {
        PreparedStatement ps;
        try {
            ps = con.prepareStatement("DELETE FROM item_elementals WHERE itemId = ?");
            try {
                ps.setInt(1, this.getObjectId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not update elementals for item {} from database!", (Object)this, (Object)ex);
        }
        if (this._elementals == null) {
            return;
        }
        try {
            ps = con.prepareStatement("INSERT INTO item_elementals VALUES(?,?,?)");
            try {
                for (Elementals elm : this._elementals) {
                    ps.setInt(1, this.getObjectId());
                    ps.setByte(2, elm.getElement());
                    ps.setInt(3, elm.getValue());
                    ps.executeUpdate();
                    ps.clearParameters();
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not update elementals for item {} from database!", (Object)this, (Object)ex);
        }
    }

    public Elementals[] getElementals() {
        return this._elementals;
    }

    public Elementals getElemental(byte attribute) {
        if (this._elementals == null) {
            return null;
        }
        for (Elementals elm : this._elementals) {
            if (elm.getElement() != attribute) continue;
            return elm;
        }
        return null;
    }

    public byte getAttackElementType() {
        if (!this.isWeapon()) {
            return -2;
        }
        if (this.getItem().getElementals() != null) {
            return this.getItem().getElementals()[0].getElement();
        }
        if (this._elementals != null) {
            return this._elementals[0].getElement();
        }
        return -2;
    }

    public int getAttackElementPower() {
        if (!this.isWeapon()) {
            return 0;
        }
        if (this.getItem().getElementals() != null) {
            return this.getItem().getElementals()[0].getValue();
        }
        if (this._elementals != null) {
            return this._elementals[0].getValue();
        }
        return 0;
    }

    public int getElementDefAttr(byte element) {
        Elementals elm;
        if (!this.isArmor()) {
            return 0;
        }
        if (this.getItem().getElementals() != null) {
            Elementals elm2 = this.getItem().getElemental(element);
            if (elm2 != null) {
                return elm2.getValue();
            }
        } else if (this._elementals != null && (elm = this.getElemental(element)) != null) {
            return elm.getValue();
        }
        return 0;
    }

    private void applyAttribute(byte element, int value) {
        if (this._elementals == null) {
            this._elementals = new Elementals[1];
            this._elementals[0] = new Elementals(element, value);
        } else {
            Elementals elm = this.getElemental(element);
            if (elm != null) {
                elm.setValue(value);
            } else {
                elm = new Elementals(element, value);
                Elementals[] array = new Elementals[this._elementals.length + 1];
                System.arraycopy(this._elementals, 0, array, 0, this._elementals.length);
                array[this._elementals.length] = elm;
                this._elementals = array;
            }
        }
    }

    public void setElementAttr(byte element, int value) {
        this.applyAttribute(element, value);
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            this.updateItemElements(con);
        }
        catch (Exception ex) {
            LOG.warn("Could not update elementals for item {} from database!", (Object)this, (Object)ex);
        }
    }

    public void clearElementAttr(byte element) {
        if (this.getElemental(element) == null && element != -1) {
            return;
        }
        Elementals[] array = null;
        if (element != -1 && this._elementals != null && this._elementals.length > 1) {
            array = new Elementals[this._elementals.length - 1];
            int i = 0;
            for (Elementals elm : this._elementals) {
                if (elm.getElement() == element) continue;
                array[i++] = elm;
            }
        }
        this._elementals = array;
        String query = element != -1 ? "DELETE FROM item_elementals WHERE itemId = ? AND elemType = ?" : "DELETE FROM item_elementals WHERE itemId = ?";
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(query);){
            if (element != -1) {
                ps.setInt(2, element);
            }
            ps.setInt(1, this.getObjectId());
            ps.executeUpdate();
        }
        catch (Exception ex) {
            LOG.warn("Could not remove elemental enchant for item {} from database!", (Object)this, (Object)ex);
        }
    }

    public boolean isShadowItem() {
        return this._mana >= 0;
    }

    public int getMana() {
        return this._mana;
    }

    public void decreaseMana(boolean resetConsumingMana) {
        this.decreaseMana(resetConsumingMana, 1);
    }

    public void decreaseMana(boolean resetConsumingMana, int count) {
        L2PcInstance player;
        if (!this.isShadowItem()) {
            return;
        }
        this._mana = this._mana - count >= 0 ? (this._mana -= count) : 0;
        if (this._storedInDb) {
            this._storedInDb = false;
        }
        if (resetConsumingMana) {
            this._consumingMana = false;
        }
        if ((player = this.getActingPlayer()) != null) {
            SystemMessage sm;
            switch (this._mana) {
                case 10: {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1S_REMAINING_MANA_IS_NOW_10);
                    sm.addItemName(this._item);
                    player.sendPacket(sm);
                    break;
                }
                case 5: {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1S_REMAINING_MANA_IS_NOW_5);
                    sm.addItemName(this._item);
                    player.sendPacket(sm);
                    break;
                }
                case 1: {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1S_REMAINING_MANA_IS_NOW_1);
                    sm.addItemName(this._item);
                    player.sendPacket(sm);
                }
            }
            if (this._mana == 0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.S1S_REMAINING_MANA_IS_NOW_0);
                sm.addItemName(this._item);
                player.sendPacket(sm);
                if (this.isEquipped()) {
                    L2ItemInstance[] unequiped = player.getInventory().unEquipItemInSlotAndRecord(this.getLocationSlot());
                    InventoryUpdate iu = new InventoryUpdate();
                    for (L2ItemInstance item : unequiped) {
                        item.unChargeAllShots();
                        iu.addModifiedItem(item);
                    }
                    player.sendPacket(iu);
                    player.broadcastUserInfo();
                }
                if (this.getItemLocation() != ItemLocation.WAREHOUSE) {
                    player.getInventory().destroyItem("L2ItemInstance", this, player, null);
                    InventoryUpdate iu = new InventoryUpdate();
                    iu.addRemovedItem(this);
                    player.sendPacket(iu);
                    StatusUpdate su = new StatusUpdate(player);
                    su.addAttribute(14, player.getCurrentLoad());
                    player.sendPacket(su);
                } else {
                    player.getWarehouse().destroyItem("L2ItemInstance", this, player, null);
                }
                L2World.getInstance().removeObject(this);
            } else {
                if (!this._consumingMana && this.isEquipped()) {
                    this.scheduleConsumeManaTask();
                }
                if (this.getItemLocation() != ItemLocation.WAREHOUSE) {
                    InventoryUpdate iu = new InventoryUpdate();
                    iu.addModifiedItem(this);
                    player.sendPacket(iu);
                }
            }
        }
    }

    public void scheduleConsumeManaTask() {
        if (this._consumingMana) {
            return;
        }
        this._consumingMana = true;
        ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleConsumeManaTask(this), 60000L);
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    public List<AbstractFunction> getStatFuncs(L2Character player) {
        return this.getItem().getStatFuncs(this, player);
    }

    public void updateDatabase() {
        this.updateDatabase(false);
    }

    public void updateDatabase(boolean force) {
        this._dbLock.lock();
        try {
            if (this._existsInDb) {
                if (this._ownerId == 0 || this._loc == ItemLocation.VOID || this._loc == ItemLocation.REFUND || this.getCount() == 0L && this._loc != ItemLocation.LEASE) {
                    this.removeFromDb();
                } else if (!Configuration.general().lazyItemsUpdate() || force) {
                    this.updateInDb();
                }
            } else {
                if (this._ownerId == 0 || this._loc == ItemLocation.VOID || this._loc == ItemLocation.REFUND || this.getCount() == 0L && this._loc != ItemLocation.LEASE) {
                    return;
                }
                this.insertIntoDb();
            }
        }
        finally {
            this._dbLock.unlock();
        }
    }

    public static L2ItemInstance restoreFromDb(int ownerId, ResultSet rs) {
        try {
            int objectId = rs.getInt(1);
            int itemId = rs.getInt("item_id");
            L2Item template = ItemTable.getInstance().getTemplate(itemId);
            if (template == null) {
                LOG.error("Item Id {} not known, object Id {} by owner Id {}!", itemId, objectId, ownerId);
                return null;
            }
            L2ItemInstance item = new L2ItemInstance(objectId, template);
            item._ownerId = ownerId;
            item.setCount(rs.getLong("count"));
            item._enchantLevel = rs.getInt("enchant_level");
            item._type1 = rs.getInt("custom_type1");
            item._type2 = rs.getInt("custom_type2");
            item._loc = ItemLocation.valueOf(rs.getString("loc"));
            item._locData = rs.getInt("loc_data");
            item._existsInDb = true;
            item._storedInDb = true;
            item._mana = rs.getInt("mana_left");
            item._time = rs.getLong("time");
            item.agathionEnergy = rs.getInt("agathion_energy");
            if (item.isEquipable()) {
                item.restoreAttributes();
            }
            return item;
        }
        catch (Exception ex) {
            LOG.warn("Could not restore an item owned by {} from database!", (Object)ownerId, (Object)ex);
            return null;
        }
    }

    public void dropMe(L2Character dropper, int x, int y, int z) {
        ThreadPoolManager.getInstance().executeGeneral(new ItemDropTask(this, dropper, x, y, z));
        if (dropper != null && dropper.isPlayer()) {
            EventDispatcher.getInstance().notifyEventAsync(new PlayerItemDrop(dropper.getActingPlayer(), this, new Location(x, y, z)), this.getItem());
        }
    }

    private void updateInDb() {
        assert (this._existsInDb);
        if (this._wear) {
            return;
        }
        if (this._storedInDb) {
            return;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE items SET owner_id=?, count=?, loc=?, loc_data=?, enchant_level=?, custom_type1=?, custom_type2=?, mana_left=?, time=?, agathion_energy=? WHERE object_id=?");){
            ps.setInt(1, this._ownerId);
            ps.setLong(2, this.getCount());
            ps.setString(3, this._loc.name());
            ps.setInt(4, this._locData);
            ps.setInt(5, this.getEnchantLevel());
            ps.setInt(6, this.getCustomType1());
            ps.setInt(7, this.getCustomType2());
            ps.setInt(8, this.getMana());
            ps.setLong(9, this.getTime());
            ps.setInt(10, this.getAgathionRemainingEnergy());
            ps.setInt(11, this.getObjectId());
            ps.executeUpdate();
            this._existsInDb = true;
            this._storedInDb = true;
        }
        catch (Exception ex) {
            LOG.warn("Could not update item {} in database!", (Object)this, (Object)ex);
        }
    }

    private void insertIntoDb() {
        assert (!this._existsInDb && this.getObjectId() != 0);
        if (this._wear) {
            return;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("INSERT INTO items (owner_id, item_id, count, loc, loc_data, enchant_level, object_id, custom_type1, custom_type2, mana_left, time, agathion_energy) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");){
            ps.setInt(1, this._ownerId);
            ps.setInt(2, this._itemId);
            ps.setLong(3, this.getCount());
            ps.setString(4, this._loc.name());
            ps.setInt(5, this._locData);
            ps.setInt(6, this.getEnchantLevel());
            ps.setInt(7, this.getObjectId());
            ps.setInt(8, this._type1);
            ps.setInt(9, this._type2);
            ps.setInt(10, this.getMana());
            ps.setLong(11, this.getTime());
            ps.setInt(12, this.getAgathionRemainingEnergy());
            ps.executeUpdate();
            this._existsInDb = true;
            this._storedInDb = true;
            if (this._augmentation != null) {
                this.updateItemAttributes(con);
            }
            if (this._elementals != null) {
                this.updateItemElements(con);
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not insert item {} into database!", (Object)this, (Object)ex);
        }
    }

    private void removeFromDb() {
        assert (this._existsInDb);
        if (this._wear) {
            return;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            try (PreparedStatement ps = con.prepareStatement("DELETE FROM items WHERE object_id = ?");){
                ps.setInt(1, this.getObjectId());
                ps.executeUpdate();
                this._existsInDb = false;
                this._storedInDb = false;
            }
            ps = con.prepareStatement("DELETE FROM item_attributes WHERE itemId = ?");
            try {
                ps.setInt(1, this.getObjectId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = con.prepareStatement("DELETE FROM item_elementals WHERE itemId = ?");
            try {
                ps.setInt(1, this.getObjectId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not delete item {} in database!", (Object)this, (Object)ex);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this._item) + "[" + this.getObjectId() + "]" + (String)(this.getEnchantLevel() > 0 ? " +" + this.getEnchantLevel() : "");
    }

    public void resetOwnerTimer() {
        if (this.itemLootSchedule != null) {
            this.itemLootSchedule.cancel(true);
        }
        this.itemLootSchedule = null;
    }

    public void setItemLootSchedule(ScheduledFuture<?> sf) {
        this.itemLootSchedule = sf;
    }

    public ScheduledFuture<?> getItemLootSchedule() {
        return this.itemLootSchedule;
    }

    public void setProtected(boolean isProtected) {
        this._protected = isProtected;
    }

    public boolean isProtected() {
        return this._protected;
    }

    public boolean isNightLure() {
        return this._itemId >= 8505 && this._itemId <= 8513 || this._itemId == 8485;
    }

    public void setCountDecrease(boolean decrease) {
        this._decrease = decrease;
    }

    public boolean getCountDecrease() {
        return this._decrease;
    }

    public void setInitCount(int InitCount) {
        this._initCount = InitCount;
    }

    public long getInitCount() {
        return this._initCount;
    }

    public void restoreInitCount() {
        if (this._decrease) {
            this.setCount(this._initCount);
        }
    }

    public boolean isTimeLimitedItem() {
        return this._time > 0L;
    }

    public long getTime() {
        return this._time;
    }

    public long getRemainingTime() {
        return this._time - System.currentTimeMillis();
    }

    public void endOfLife() {
        L2PcInstance player = this.getActingPlayer();
        if (player != null) {
            if (this.isEquipped()) {
                L2ItemInstance[] unequiped = player.getInventory().unEquipItemInSlotAndRecord(this.getLocationSlot());
                InventoryUpdate iu = new InventoryUpdate();
                for (L2ItemInstance item : unequiped) {
                    item.unChargeAllShots();
                    iu.addModifiedItem(item);
                }
                player.sendPacket(iu);
                player.broadcastUserInfo();
            }
            if (this.getItemLocation() != ItemLocation.WAREHOUSE) {
                player.getInventory().destroyItem("L2ItemInstance", this, player, null);
                InventoryUpdate iu = new InventoryUpdate();
                iu.addRemovedItem(this);
                player.sendPacket(iu);
                StatusUpdate su = new StatusUpdate(player);
                su.addAttribute(14, player.getCurrentLoad());
                player.sendPacket(su);
            } else {
                player.getWarehouse().destroyItem("L2ItemInstance", this, player, null);
            }
            player.sendPacket(SystemMessageId.TIME_LIMITED_ITEM_DELETED);
            L2World.getInstance().removeObject(this);
        }
    }

    public void scheduleLifeTimeTask() {
        if (!this.isTimeLimitedItem()) {
            return;
        }
        if (this.getRemainingTime() <= 0L) {
            this.endOfLife();
        } else {
            if (this._lifeTimeTask != null) {
                this._lifeTimeTask.cancel(false);
            }
            this._lifeTimeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleLifeTimeTask(this), this.getRemainingTime());
        }
    }

    public void updateElementAttrBonus(L2PcInstance player) {
        if (this._elementals == null) {
            return;
        }
        for (Elementals elm : this._elementals) {
            elm.updateBonus(player, this.isArmor());
        }
    }

    public void removeElementAttrBonus(L2PcInstance player) {
        if (this._elementals == null) {
            return;
        }
        for (Elementals elm : this._elementals) {
            elm.removeBonus(player);
        }
    }

    public void setDropperObjectId(int id) {
        this._dropperObjectId = id;
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (this._dropperObjectId != 0) {
            activeChar.sendPacket(new DropItem(this, this._dropperObjectId));
        } else {
            activeChar.sendPacket(new SpawnItem(this));
        }
    }

    public DropProtection getDropProtection() {
        return this._dropProtection;
    }

    public boolean isPublished() {
        return this._published;
    }

    public void publish() {
        this._published = true;
    }

    @Override
    public boolean decayMe() {
        if (Configuration.general().saveDroppedItem()) {
            ItemsOnGroundManager.getInstance().removeObject(this);
        }
        return super.decayMe();
    }

    public boolean isQuestItem() {
        return this.getItem().isQuestItem();
    }

    public boolean isElementable() {
        if (this.getItemLocation() == ItemLocation.INVENTORY || this.getItemLocation() == ItemLocation.PAPERDOLL) {
            return this.getItem().isElementable();
        }
        return false;
    }

    public boolean isFreightable() {
        return this.getItem().isFreightable();
    }

    public int useSkillDisTime() {
        return this.getItem().useSkillDisTime();
    }

    public int getOlyEnchantLevel() {
        L2PcInstance player = this.getActingPlayer();
        int enchant = this.getEnchantLevel();
        if (player == null) {
            return enchant;
        }
        if (player.isInOlympiadMode() && Configuration.olympiad().getEnchantLimit() >= 0 && enchant > Configuration.olympiad().getEnchantLimit()) {
            enchant = Configuration.olympiad().getEnchantLimit();
        }
        return enchant;
    }

    public int getDefaultEnchantLevel() {
        return this._item.getDefaultEnchantLevel();
    }

    public boolean hasPassiveSkills() {
        return this.getItemType() == EtcItemType.RUNE && this.getItemLocation() == ItemLocation.INVENTORY && this.getOwnerId() > 0 && this.getItem().hasSkills();
    }

    public void giveSkillsToOwner() {
        if (!this.hasPassiveSkills()) {
            return;
        }
        L2PcInstance player = this.getActingPlayer();
        if (player != null) {
            for (SkillHolder sh : this.getItem().getSkills()) {
                if (!sh.getSkill().isPassive()) continue;
                player.addSkill(sh.getSkill(), false);
            }
        }
    }

    public void removeSkillsFromOwner() {
        if (!this.hasPassiveSkills()) {
            return;
        }
        L2PcInstance player = this.getActingPlayer();
        if (player != null) {
            for (SkillHolder sh : this.getItem().getSkills()) {
                if (!sh.getSkill().isPassive()) continue;
                player.removeSkill(sh.getSkill(), false, true);
            }
        }
    }

    @Override
    public boolean isItem() {
        return true;
    }

    @Override
    public L2PcInstance getActingPlayer() {
        return L2World.getInstance().getPlayer(this.getOwnerId());
    }

    public int getEquipReuseDelay() {
        return this._item.getEquipReuseDelay();
    }

    public void onBypassFeedback(L2PcInstance activeChar, String command) {
        if (command.startsWith("Quest")) {
            String questName = command.substring(6);
            String event = null;
            int idx = questName.indexOf(32);
            if (idx > 0) {
                event = questName.substring(idx).trim();
            }
            if (event != null) {
                EventDispatcher.getInstance().notifyEventAsync(new ItemBypass(this, activeChar, event), this.getItem());
            } else {
                EventDispatcher.getInstance().notifyEventAsync(new ItemTalk(this, activeChar), this.getItem());
            }
        }
    }

    @Override
    public boolean isChargedShot(ShotType type) {
        return (this._shotsMask & type.getMask()) == type.getMask();
    }

    @Override
    public void setChargedShot(ShotType type, boolean charged) {
        this._shotsMask = charged ? (this._shotsMask |= type.getMask()) : (this._shotsMask &= ~type.getMask());
    }

    public void unChargeAllShots() {
        this._shotsMask = 0;
    }

    public int[] getEnchantOptions() {
        EnchantOptions op = EnchantItemOptionsData.getInstance().getOptions(this);
        if (op != null) {
            return op.getOptions();
        }
        return DEFAULT_ENCHANT_OPTIONS;
    }

    public void clearEnchantStats() {
        L2PcInstance player = this.getActingPlayer();
        if (player == null) {
            this._enchantOptions.clear();
            return;
        }
        for (Options op : this._enchantOptions) {
            op.remove(player);
        }
        this._enchantOptions.clear();
    }

    public void applyEnchantStats() {
        L2PcInstance player = this.getActingPlayer();
        if (!this.isEquipped() || player == null || this.getEnchantOptions() == DEFAULT_ENCHANT_OPTIONS) {
            return;
        }
        for (int id : this.getEnchantOptions()) {
            Options options = OptionData.getInstance().getOptions(id);
            if (options != null) {
                options.apply(player);
                this._enchantOptions.add(options);
                continue;
            }
            if (id == 0) continue;
            LOG.warn("Couldn't find option Id {} for item {}!", (Object)id, (Object)this);
        }
    }

    @Override
    public void setHeading(int heading) {
    }

    public void deleteMe() {
        if (this._lifeTimeTask != null && !this._lifeTimeTask.isDone()) {
            this._lifeTimeTask.cancel(false);
            this._lifeTimeTask = null;
        }
    }

    public int getAgathionRemainingEnergy() {
        return this.agathionEnergy;
    }

    public void setAgathionRemainingEnergy(int agathionEnergy) {
        this.agathionEnergy = agathionEnergy;
        this._storedInDb = false;
    }

    public static class ScheduleConsumeManaTask
    implements Runnable {
        private static final Logger LOG = LoggerFactory.getLogger(ScheduleConsumeManaTask.class);
        private final L2ItemInstance _shadowItem;

        public ScheduleConsumeManaTask(L2ItemInstance item) {
            this._shadowItem = item;
        }

        @Override
        public void run() {
            try {
                if (this._shadowItem != null) {
                    this._shadowItem.decreaseMana(true);
                }
            }
            catch (Exception ex) {
                LOG.warn("There has been an error decreasing Mana!", ex);
            }
        }
    }

    public class ItemDropTask
    implements Runnable {
        private int _x;
        private int _y;
        private int _z;
        private final L2Character _dropper;
        private final L2ItemInstance _itm;

        public ItemDropTask(L2ItemInstance item, L2Character dropper, int x, int y, int z) {
            this._x = x;
            this._y = y;
            this._z = z;
            this._dropper = dropper;
            this._itm = item;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            assert (this._itm.getWorldRegion() == null);
            if (this._dropper != null) {
                Location dropDest = GeoData.getInstance().moveCheck(this._dropper.getX(), this._dropper.getY(), this._dropper.getZ(), this._x, this._y, this._z, this._dropper.getInstanceId());
                this._x = dropDest.getX();
                this._y = dropDest.getY();
                this._z = dropDest.getZ();
            }
            if (this._dropper != null) {
                L2ItemInstance.this.setInstanceId(this._dropper.getInstanceId());
            } else {
                L2ItemInstance.this.setInstanceId(0);
            }
            L2ItemInstance l2ItemInstance = this._itm;
            synchronized (l2ItemInstance) {
                this._itm.setIsVisible(true);
                this._itm.setXYZ(this._x, this._y, this._z);
                this._itm.setWorldRegion(L2World.getInstance().getRegion(L2ItemInstance.this.getLocation()));
            }
            this._itm.getWorldRegion().addVisibleObject(this._itm);
            this._itm.setDropTime(System.currentTimeMillis());
            this._itm.setDropperObjectId(this._dropper != null ? this._dropper.getObjectId() : 0);
            L2World.getInstance().addVisibleObject(this._itm, this._itm.getWorldRegion());
            if (Configuration.general().saveDroppedItem()) {
                ItemsOnGroundManager.getInstance().save(this._itm);
            }
            this._itm.setDropperObjectId(0);
        }
    }

    public static class ScheduleLifeTimeTask
    implements Runnable {
        private static final Logger LOG = LoggerFactory.getLogger(ScheduleLifeTimeTask.class);
        private final L2ItemInstance _limitedItem;

        public ScheduleLifeTimeTask(L2ItemInstance item) {
            this._limitedItem = item;
        }

        @Override
        public void run() {
            try {
                if (this._limitedItem != null) {
                    this._limitedItem.endOfLife();
                }
            }
            catch (Exception ex) {
                LOG.warn("There has been an error ending item {} life!", (Object)this._limitedItem, (Object)ex);
            }
        }
    }
}

