/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.multisell;

import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.items.L2Armor;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.multisell.ItemInfo;

public class Ingredient {
    private int _itemId;
    private long _itemCount;
    private boolean _isTaxIngredient;
    private boolean _maintainIngredient;
    private L2Item _template = null;
    private ItemInfo _itemInfo = null;

    public Ingredient(StatsSet set) {
        this(set.getInt("id"), set.getLong("count"), set.getBoolean("isTaxIngredient", false), set.getBoolean("maintainIngredient", false));
    }

    public Ingredient(int itemId, long itemCount, boolean isTaxIngredient, boolean maintainIngredient) {
        this._itemId = itemId;
        this._itemCount = itemCount;
        this._isTaxIngredient = isTaxIngredient;
        this._maintainIngredient = maintainIngredient;
        if (this._itemId > 0) {
            this._template = ItemTable.getInstance().getTemplate(this._itemId);
        }
    }

    public Ingredient getCopy() {
        return new Ingredient(this._itemId, this._itemCount, this._isTaxIngredient, this._maintainIngredient);
    }

    public final L2Item getTemplate() {
        return this._template;
    }

    public final void setItemInfo(L2ItemInstance item) {
        this._itemInfo = new ItemInfo(item);
    }

    public final void setItemInfo(ItemInfo info) {
        this._itemInfo = info;
    }

    public final ItemInfo getItemInfo() {
        return this._itemInfo;
    }

    public final int getEnchantLevel() {
        return this._itemInfo != null ? this._itemInfo.getEnchantLevel() : 0;
    }

    public final void setItemId(int itemId) {
        this._itemId = itemId;
    }

    public final int getItemId() {
        return this._itemId;
    }

    public final void setItemCount(long itemCount) {
        this._itemCount = itemCount;
    }

    public final long getItemCount() {
        return this._itemCount;
    }

    public final void setIsTaxIngredient(boolean isTaxIngredient) {
        this._isTaxIngredient = isTaxIngredient;
    }

    public final boolean isTaxIngredient() {
        return this._isTaxIngredient;
    }

    public final void setMaintainIngredient(boolean maintainIngredient) {
        this._maintainIngredient = maintainIngredient;
    }

    public final boolean getMaintainIngredient() {
        return this._maintainIngredient;
    }

    public final boolean isStackable() {
        return this._template == null || this._template.isStackable();
    }

    public final boolean isArmorOrWeapon() {
        return this._template != null && (this._template instanceof L2Armor || this._template instanceof L2Weapon);
    }

    public final int getWeight() {
        return this._template == null ? 0 : this._template.getWeight();
    }
}

