/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.quest;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.drops.DropListScope;
import com.l2jserver.gameserver.model.drops.GeneralDropItem;
import com.l2jserver.gameserver.model.drops.GroupedGeneralDropItem;
import com.l2jserver.gameserver.model.drops.IDropItem;
import com.l2jserver.gameserver.model.holders.ItemChanceHolder;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.holders.QuestItemChanceHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QuestDroplist {
    private final Map<Integer, List<QuestDropInfo>> dropsByNpcId = new HashMap<Integer, List<QuestDropInfo>>();

    private QuestDroplist(QuestDropListBuilder builder) {
        this.dropsByNpcId.putAll(builder.dropList);
    }

    public QuestDropInfo get(int npcId) {
        if (!this.dropsByNpcId.containsKey(npcId)) {
            return null;
        }
        return this.dropsByNpcId.get(npcId).get(0);
    }

    public QuestDropInfo get(L2Npc npc) {
        return this.get(npc.getId());
    }

    public QuestDropInfo get(int npcId, int itemId) {
        if (!this.dropsByNpcId.containsKey(npcId)) {
            return null;
        }
        for (QuestDropInfo dropInfo : this.dropsByNpcId.get(npcId)) {
            if (dropInfo.item().getId() != itemId) continue;
            return dropInfo;
        }
        return null;
    }

    public QuestDropInfo get(int npcId, ItemHolder item) {
        return this.get(npcId, item.getId());
    }

    public QuestDropInfo get(L2Npc npc, ItemHolder item) {
        return this.get(npc.getId(), item.getId());
    }

    public Set<Integer> getNpcIds() {
        return this.dropsByNpcId.keySet();
    }

    public Set<Integer> getItemIds() {
        return this.dropsByNpcId.values().stream().flatMap(Collection::stream).map(QuestDropInfo::drop).flatMap(dropItem -> {
            if (dropItem instanceof GeneralDropItem) {
                GeneralDropItem gen = (GeneralDropItem)dropItem;
                return Stream.of(Integer.valueOf(gen.getItemId()));
            }
            if (dropItem instanceof GroupedGeneralDropItem) {
                GroupedGeneralDropItem grp = (GroupedGeneralDropItem)dropItem;
                return grp.getItems().stream().map(GeneralDropItem::getItemId);
            }
            return Stream.empty();
        }).collect(Collectors.toSet());
    }

    public static IDropItem singleDropItem(ItemChanceHolder itemHolder) {
        return QuestDroplist.singleDropItem(itemHolder.getId(), itemHolder.getCount(), itemHolder.getCount(), itemHolder.getChance());
    }

    public static IDropItem singleDropItem(ItemChanceHolder itemHolder, double chance) {
        return QuestDroplist.singleDropItem(itemHolder.getId(), itemHolder.getCount(), itemHolder.getCount(), chance);
    }

    public static IDropItem singleDropItem(ItemChanceHolder itemHolder, long amount) {
        return QuestDroplist.singleDropItem(itemHolder.getId(), amount, amount, itemHolder.getChance());
    }

    public static IDropItem singleDropItem(int itemId, long amount) {
        return QuestDroplist.singleDropItem(itemId, amount, amount, 100.0);
    }

    public static IDropItem singleDropItem(int itemId, double chance) {
        return QuestDroplist.singleDropItem(itemId, 1L, 1L, chance);
    }

    public static IDropItem singleDropItem(int itemId, long minAmount, long maxAmount, double chance) {
        return DropListScope.QUEST.newDropItem(itemId, minAmount, maxAmount, chance);
    }

    public static IDropItem groupedDropItem(double chance, ItemChanceHolder ... itemHolders) {
        return QuestDroplist.groupedDropItem(chance, List.of(itemHolders));
    }

    private static IDropItem groupedDropItem(double chance, List<? extends ItemChanceHolder> itemHolders) {
        GroupedGeneralDropItem group = DropListScope.QUEST.newGroupedDropItem(chance);
        List<GeneralDropItem> dropItems = itemHolders.stream().map(QuestDroplist::singleDropItem).filter(GeneralDropItem.class::isInstance).map(GeneralDropItem.class::cast).toList();
        group.setItems(dropItems);
        return group;
    }

    public static QuestDropListBuilder builder() {
        return new QuestDropListBuilder();
    }

    public static class QuestDropListBuilder {
        private final Map<Integer, List<QuestDropInfo>> dropList = new HashMap<Integer, List<QuestDropInfo>>();
        private Map.Entry<Integer, QuestDropInfo> lastAdded = null;

        public QuestDropListBuilder addSingleDrop(int npcId, QuestItemChanceHolder questItem, long minAmount, long maxAmount, double chance, int[] requiredItemIds) {
            List dropsForMob = this.dropList.computeIfAbsent(npcId, ArrayList::new);
            QuestDropInfo dropInfo = new QuestDropInfo(questItem, QuestDroplist.singleDropItem(questItem.getId(), minAmount, maxAmount, chance), requiredItemIds);
            dropsForMob.add(dropInfo);
            this.updateLastAdded(npcId, dropInfo);
            return this;
        }

        public QuestDropListBuilder addSingleDrop(int npcId, QuestItemChanceHolder questItem, long minAmount, long maxAmount, double chance) {
            return this.addSingleDrop(npcId, questItem, minAmount, maxAmount, chance, null);
        }

        public QuestDropListBuilder addSingleDrop(int npcId, QuestItemChanceHolder questItem) {
            return this.addSingleDrop(npcId, questItem, questItem.getCount(), questItem.getCount(), questItem.getChance());
        }

        public QuestDropListBuilder addSingleDrop(int npcId, QuestItemChanceHolder questItem, long amount, double chance) {
            return this.addSingleDrop(npcId, new QuestItemChanceHolder(questItem.getId(), chance, amount, questItem.getLimit()));
        }

        public QuestDropListBuilder addSingleDrop(int npcId, QuestItemChanceHolder questItem, long amount) {
            return this.addSingleDrop(npcId, new QuestItemChanceHolder(questItem.getId(), questItem.getChance(), amount, questItem.getLimit()));
        }

        public QuestDropListBuilder addSingleDrop(int npcId, QuestItemChanceHolder questItem, double chance) {
            return this.addSingleDrop(npcId, new QuestItemChanceHolder(questItem.getId(), chance, questItem.getCount(), questItem.getLimit()));
        }

        public QuestDropListBuilder addSingleDrop(int npcId, int itemId) {
            return this.addSingleDrop(npcId, new QuestItemChanceHolder(itemId, 100.0, 1L, 0L));
        }

        public QuestDropListBuilder addSingleDrop(int npcId, int itemId, long amount) {
            return this.addSingleDrop(npcId, new QuestItemChanceHolder(itemId, 100.0, amount, 0L));
        }

        public QuestDropListBuilder addSingleDrop(int npcId, int itemId, double chance) {
            return this.addSingleDrop(npcId, new QuestItemChanceHolder(itemId, chance, 1L, 0L));
        }

        public QuestDropListBuilder addSingleDrop(int npcId, int itemId, long amount, double chance) {
            return this.addSingleDrop(npcId, new QuestItemChanceHolder(itemId, chance, amount, 0L));
        }

        public QuestDropListBuilder withRequiredItems(int ... itemIds) {
            if (this.lastAdded == null) {
                throw new IllegalStateException("Cannot add required items without adding a drop first.");
            }
            int[] uniqueItemIds = Optional.ofNullable(itemIds).map(ids -> Arrays.stream(ids).distinct().toArray()).orElse(null);
            QuestDropInfo oldDropInfo = this.lastAdded.getValue();
            QuestDropInfo newDropInfo = new QuestDropInfo(oldDropInfo.item(), oldDropInfo.drop(), uniqueItemIds);
            List<QuestDropInfo> dropsForNpc = this.dropList.get(this.lastAdded.getKey());
            dropsForNpc.remove(oldDropInfo);
            dropsForNpc.add(newDropInfo);
            this.updateLastAdded(this.lastAdded.getKey(), newDropInfo);
            return this;
        }

        public SingleDropBuilder bulkAddSingleDrop(QuestItemChanceHolder questItem) {
            return new SingleDropBuilder(this, questItem);
        }

        public SingleDropBuilder bulkAddSingleDrop(QuestItemChanceHolder questItem, double chance) {
            return this.bulkAddSingleDrop(new QuestItemChanceHolder(questItem.getId(), chance, questItem.getCount(), questItem.getLimit()));
        }

        public SingleDropBuilder bulkAddSingleDrop(int itemId, double chance) {
            return this.bulkAddSingleDrop(new QuestItemChanceHolder(itemId, chance, 1L, 0L));
        }

        private QuestDropListBuilder addGroupedDrop(int npcId, QuestDropInfo dropInfo) {
            List dropsForMob = this.dropList.computeIfAbsent(npcId, ArrayList::new);
            dropsForMob.add(dropInfo);
            this.updateLastAdded(npcId, dropInfo);
            return this;
        }

        public GroupedDropBuilder addGroupedDrop(int npcId, double chanceForGroup) {
            return new GroupedDropBuilder(this, npcId, chanceForGroup);
        }

        public GroupedDropForSingleItemBuilder addGroupedDropForSingleItem(int npcId, QuestItemChanceHolder questItem, double chanceForGroup) {
            return new GroupedDropForSingleItemBuilder(this, npcId, questItem, chanceForGroup);
        }

        private void updateLastAdded(int npcId, QuestDropInfo dropInfo) {
            this.lastAdded = Map.entry(npcId, dropInfo);
        }

        public QuestDroplist build() {
            return new QuestDroplist(this);
        }

        public static class SingleDropBuilder {
            private final QuestDropListBuilder parentBuilder;
            private final QuestItemChanceHolder item;
            private final Set<Integer> npcIds = new HashSet<Integer>();
            private int[] requiredItems = null;

            public SingleDropBuilder(QuestDropListBuilder parentBuilder, QuestItemChanceHolder item) {
                this.parentBuilder = parentBuilder;
                this.item = item;
            }

            public SingleDropBuilder withNpcs(Set<Integer> npcIds) {
                this.npcIds.addAll(npcIds);
                return this;
            }

            public SingleDropBuilder withNpcs(int ... npcIds) {
                return this.withNpcs(Arrays.stream(npcIds).boxed().collect(Collectors.toSet()));
            }

            public SingleDropBuilder withRequiredItems(int ... itemIds) {
                this.requiredItems = itemIds;
                return this;
            }

            public QuestDropListBuilder build() {
                this.npcIds.forEach(npcId -> this.parentBuilder.addSingleDrop((int)npcId, this.item).withRequiredItems(this.requiredItems));
                return this.parentBuilder;
            }
        }

        public static class GroupedDropBuilder {
            private final QuestDropListBuilder parentBuilder;
            private final int npcId;
            private final double chance;
            protected final List<QuestItemChanceHolder> items = new ArrayList<QuestItemChanceHolder>();

            private GroupedDropBuilder(QuestDropListBuilder parentBuilder, int npcId, double chanceForGroup) {
                this.parentBuilder = parentBuilder;
                this.npcId = npcId;
                this.chance = chanceForGroup;
            }

            public GroupedDropBuilder withDropItem(QuestItemChanceHolder questItem) {
                this.items.add(questItem);
                return this;
            }

            public GroupedDropBuilder withDropItem(QuestItemChanceHolder questItem, long amount) {
                return this.withDropItem(new QuestItemChanceHolder(questItem.getId(), questItem.getChance(), amount, questItem.getLimit()));
            }

            public GroupedDropBuilder withDropItem(QuestItemChanceHolder questItem, double chanceWithinGroup) {
                return this.withDropItem(new QuestItemChanceHolder(questItem.getId(), chanceWithinGroup, questItem.getCount(), questItem.getLimit()));
            }

            public GroupedDropBuilder withDropItem(QuestItemChanceHolder questItem, long amount, double chanceWithinGroup) {
                return this.withDropItem(new QuestItemChanceHolder(questItem.getId(), chanceWithinGroup, amount, questItem.getLimit()));
            }

            public GroupedDropBuilder withDropItem(int itemId, double chanceWithinGroup) {
                return this.withDropItem(new QuestItemChanceHolder(itemId, chanceWithinGroup, 1L, 0L));
            }

            public GroupedDropBuilder withDropItem(int itemId, long amount, double chanceWithinGroup) {
                return this.withDropItem(new QuestItemChanceHolder(itemId, chanceWithinGroup, amount, 0L));
            }

            public QuestDropListBuilder build() {
                return this.parentBuilder.addGroupedDrop(this.npcId, new QuestDropInfo(this.items.get(0), QuestDroplist.groupedDropItem(this.chance, this.items)));
            }
        }
    }

    public record QuestDropInfo(QuestItemChanceHolder item, IDropItem drop, int[] requiredItems) {
        public QuestDropInfo(QuestItemChanceHolder item, IDropItem drop) {
            this(item, drop, null);
        }

        public long getLimit() {
            return this.item.getLimit();
        }
    }

    public static class GroupedDropForSingleItemBuilder
    extends QuestDropListBuilder.GroupedDropBuilder {
        private final QuestItemChanceHolder questItem;

        private GroupedDropForSingleItemBuilder(QuestDropListBuilder parentBuilder, int npcId, QuestItemChanceHolder questItem, double chanceForGroup) {
            super(parentBuilder, npcId, chanceForGroup);
            this.questItem = questItem;
        }

        public GroupedDropForSingleItemBuilder withAmount(long amount, double chanceWithinGroup) {
            this.withDropItem(this.questItem, amount, chanceWithinGroup);
            return this;
        }

        public QuestDropListBuilder orElse(long amount) {
            double sumOfChances = this.items.stream().mapToDouble(ItemChanceHolder::getChance).sum();
            this.withDropItem(this.questItem, amount, 100.0 - sumOfChances);
            return super.build();
        }

        @Override
        public QuestDropListBuilder build() {
            return super.build();
        }
    }
}

