/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.skills;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.SkillTreesData;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.MountType;
import com.l2jserver.gameserver.enums.ShotType;
import com.l2jserver.gameserver.instancemanager.HandysBlockCheckerManager;
import com.l2jserver.gameserver.model.ArenaParticipantsHolder;
import com.l2jserver.gameserver.model.L2ExtractableProductItem;
import com.l2jserver.gameserver.model.L2ExtractableSkill;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2BlockInstance;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.AbnormalVisualEffect;
import com.l2jserver.gameserver.model.skills.AttributeType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.model.skills.EffectScope;
import com.l2jserver.gameserver.model.skills.SkillOperateType;
import com.l2jserver.gameserver.model.skills.targets.AffectObject;
import com.l2jserver.gameserver.model.skills.targets.AffectObjectStaticImpl;
import com.l2jserver.gameserver.model.skills.targets.AffectScope;
import com.l2jserver.gameserver.model.skills.targets.TargetType;
import com.l2jserver.gameserver.model.stats.BaseStats;
import com.l2jserver.gameserver.model.stats.Formulas;
import com.l2jserver.gameserver.model.stats.TraitType;
import com.l2jserver.gameserver.model.stats.functions.AbstractFunction;
import com.l2jserver.gameserver.model.stats.functions.FuncTemplate;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Skill
implements IIdentifiable {
    private static final Logger LOG = LoggerFactory.getLogger(Skill.class);
    private final int _id;
    private final int _level;
    private final int _displayId;
    private final int _displayLevel;
    private final String _name;
    private final SkillOperateType _operateType;
    private final int _magic;
    private final TraitType _traitType;
    private final boolean _reuseDelayLock;
    private final int _mpConsume1;
    private final int _mpConsume2;
    private final int _mpPerChanneling;
    private final int _hpConsume;
    private final int _itemConsumeCount;
    private final int _itemConsumeId;
    private final int _castRange;
    private final int _effectRange;
    private final boolean _isAbnormalInstant;
    private final int _abnormalLvl;
    private final AbnormalType _abnormalType;
    private final int _abnormalTime;
    private AbnormalVisualEffect[] _abnormalVisualEffects = null;
    private AbnormalVisualEffect[] _abnormalVisualEffectsSpecial = null;
    private AbnormalVisualEffect[] _abnormalVisualEffectsEvent = null;
    private final boolean _stayAfterDeath;
    private final boolean _stayOnSubclassChange;
    private final boolean _isRecoveryHerb;
    private int _refId;
    private final int hitTime;
    private final int hitCancelTime;
    private final int _coolTime;
    private final int _reuseHashCode;
    private final int _reuseDelay;
    private final int _magicLevel;
    private final int _lvlBonusRate;
    private final int _activateRate;
    private final int _minChance;
    private final int _maxChance;
    private final int[] affectLimit;
    private AffectObject affectObject;
    private final int affectRange;
    private AffectScope affectScope;
    private TargetType targetType;
    private final int[] fanRange;
    private final boolean _nextActionIsAttack;
    private final boolean _blockedInOlympiad;
    private final AttributeType _attributeType;
    private final int _attributePower;
    private final BaseStats _basicProperty;
    private final boolean _overhit;
    private final int _minPledgeClass;
    private final int _chargeConsume;
    private final int _soulMaxConsume;
    private final int _effectPoint;
    private List<Condition> _preCondition;
    private List<Condition> _itemPreCondition;
    private Set<MountType> _rideState;
    private List<FuncTemplate> _funcTemplates;
    private final Map<EffectScope, List<AbstractEffect>> _effectLists = new EnumMap<EffectScope, List<AbstractEffect>>(EffectScope.class);
    private final boolean _isDebuff;
    private final boolean _isSuicideAttack;
    private final boolean _irreplaceableBuff;
    private final boolean _excludedFromCheck;
    private final boolean _simultaneousCast;
    private L2ExtractableSkill _extractableItems = null;
    private final String _icon;
    private volatile Byte[] _effectTypes;
    private final int _channelingSkillId;
    private final int _channelingTickInitialDelay;
    private final int _channelingTickInterval;

    public Skill(StatsSet set) {
        String[] state;
        this._id = set.getInt("skill_id");
        this._level = set.getInt("level");
        this._displayId = set.getInt("displayId", this._id);
        this._displayLevel = set.getInt("displayLevel", this._level);
        this._name = set.getString("name", "");
        this._operateType = set.getEnum("operateType", SkillOperateType.class);
        this._magic = set.getInt("isMagic", 0);
        this._traitType = set.getEnum("trait", TraitType.class, TraitType.NONE);
        this._reuseDelayLock = set.getBoolean("reuseDelayLock", false);
        this._mpConsume1 = set.getInt("mpConsume1", 0);
        this._mpConsume2 = set.getInt("mpConsume2", 0);
        this._mpPerChanneling = set.getInt("mpPerChanneling", this._mpConsume2);
        this._hpConsume = set.getInt("hpConsume", 0);
        this._itemConsumeCount = set.getInt("itemConsumeCount", 0);
        this._itemConsumeId = set.getInt("itemConsumeId", 0);
        this._castRange = set.getInt("castRange", -1);
        this._effectRange = set.getInt("effectRange", -1);
        this._abnormalLvl = set.getInt("abnormalLvl", 0);
        this._abnormalType = set.getEnum("abnormalType", AbnormalType.class, AbnormalType.NONE);
        int abnormalTime = set.getInt("abnormalTime", 0);
        Integer skillDuration = Configuration.character().getSkillDuration().get(this._id);
        if (Configuration.character().modifySkillDuration() && skillDuration != null) {
            if (this.getLevel() < 100 || this.getLevel() > 140) {
                abnormalTime = skillDuration;
            } else if (this.getLevel() < 140) {
                abnormalTime += skillDuration.intValue();
            }
        }
        this._abnormalTime = abnormalTime;
        this._isAbnormalInstant = set.getBoolean("abnormalInstant", false);
        this.parseAbnormalVisualEffect(set.getString("abnormalVisualEffect", null));
        this._stayAfterDeath = set.getBoolean("stayAfterDeath", false);
        this._stayOnSubclassChange = set.getBoolean("stayOnSubclassChange", true);
        this.hitTime = set.getInt("hitTime", 0);
        this.hitCancelTime = set.getInt("hitCancelTime", 0);
        this._coolTime = set.getInt("coolTime", 0);
        this._isDebuff = set.getBoolean("isDebuff", false);
        this._isRecoveryHerb = set.getBoolean("isRecoveryHerb", false);
        this._reuseHashCode = SkillData.getSkillHashCode(this._id, this._level);
        Integer skillReuse = Configuration.character().getSkillReuse().get(this._id);
        if (Configuration.character().modifySkillReuse() && skillReuse != null) {
            if (Configuration.general().debug()) {
                LOG.info("*** Skill {} ({}) changed reuse from {} to {} seconds.", this._name, this._level, set.getInt("reuseDelay", 0), skillReuse);
            }
            this._reuseDelay = skillReuse;
        } else {
            this._reuseDelay = set.getInt("reuseDelay", 0);
        }
        String rideState = set.getString("rideState", null);
        if (rideState != null && (state = rideState.split(";")).length > 0) {
            this._rideState = new HashSet<MountType>(state.length);
            for (String s : state) {
                try {
                    this._rideState.add(MountType.valueOf(s));
                }
                catch (Exception e) {
                    LOG.warn("Bad data in rideState for skill {}!", (Object)this, (Object)e);
                }
            }
        }
        this.affectLimit = set.getIntArray("affectLimit", "0-0", "-");
        this.affectObject = set.getEnum("affectObject", AffectObjectStaticImpl.class, AffectObjectStaticImpl.ALL);
        this.affectScope = this.isToggle() ? AffectScope.SINGLE : set.getEnum("affectScope", AffectScope.class, AffectScope.NONE);
        this.affectRange = set.getInt("affectRange", 0);
        this.targetType = set.getEnum("targetType", TargetType.class, TargetType.SELF);
        this.fanRange = set.getIntArray("fanRange", "0,0,0,0", ",");
        this._magicLevel = set.getInt("magicLvl", 0);
        this._lvlBonusRate = set.getInt("lvlBonusRate", 0);
        this._activateRate = set.getInt("activateRate", -1);
        this._minChance = set.getInt("minChance", Configuration.character().getMinAbnormalStateSuccessRate());
        this._maxChance = set.getInt("maxChance", Configuration.character().getMaxAbnormalStateSuccessRate());
        this._nextActionIsAttack = set.getBoolean("nextActionAttack", false);
        this._blockedInOlympiad = set.getBoolean("blockedInOlympiad", false);
        this._attributeType = set.getEnum("attributeType", AttributeType.class, AttributeType.NONE);
        this._attributePower = set.getInt("attributePower", 0);
        this._basicProperty = set.getEnum("basicProperty", BaseStats.class, BaseStats.NONE);
        this._overhit = set.getBoolean("overHit", false);
        this._isSuicideAttack = set.getBoolean("isSuicideAttack", false);
        this._minPledgeClass = set.getInt("minPledgeClass", 0);
        this._chargeConsume = set.getInt("chargeConsume", 0);
        this._soulMaxConsume = set.getInt("soulMaxConsumeCount", 0);
        this._effectPoint = set.getInt("effectPoint", 0);
        this._irreplaceableBuff = set.getBoolean("irreplaceableBuff", false);
        this._excludedFromCheck = set.getBoolean("excludedFromCheck", false);
        this._simultaneousCast = set.getBoolean("simultaneousCast", false);
        String capsuled_items = set.getString("capsuled_items_skill", null);
        if (capsuled_items != null) {
            if (capsuled_items.isEmpty()) {
                LOG.warn("Empty Extractable Item Skill data in Skill Id: {}", (Object)this._id);
            }
            this._extractableItems = this.parseExtractableSkill(this._id, this._level, capsuled_items);
        }
        this._icon = set.getString("icon", "icon.skill0000");
        this._channelingSkillId = set.getInt("channelingSkillId", 0);
        this._channelingTickInterval = set.getInt("channelingTickInterval", 2) * 1000;
        this._channelingTickInitialDelay = set.getInt("channelingTickInitialDelay", this._channelingTickInterval / 1000) * 1000;
    }

    public void updateTargetSystem(TargetType targetType, AffectScope affectScope, AffectObject affectObject) {
        this.targetType = targetType;
        this.affectScope = affectScope;
        this.affectObject = affectObject;
    }

    public TraitType getTraitType() {
        return this._traitType;
    }

    public AttributeType getAttributeType() {
        return this._attributeType;
    }

    public int getAttributePower() {
        return this._attributePower;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public boolean isAOE() {
        return this.affectScope == AffectScope.FAN || this.affectScope == AffectScope.POINT_BLANK || this.affectScope == AffectScope.RANGE || this.affectScope == AffectScope.RANGE_SORT_BY_HP || this.affectScope == AffectScope.RING_RANGE || this.affectScope == AffectScope.SQUARE || this.affectScope == AffectScope.SQUARE_PB;
    }

    public boolean isDamage() {
        return this.hasEffectType(L2EffectType.MAGICAL_ATTACK, L2EffectType.HP_DRAIN, L2EffectType.PHYSICAL_ATTACK);
    }

    public boolean isOverhit() {
        return this._overhit;
    }

    public boolean isSuicideAttack() {
        return this._isSuicideAttack;
    }

    public boolean isAbnormalInstant() {
        return this._isAbnormalInstant;
    }

    public AbnormalType getAbnormalType() {
        return this._abnormalType;
    }

    public int getAbnormalLvl() {
        return this._abnormalLvl;
    }

    public int getAbnormalTime() {
        return this._abnormalTime;
    }

    public AbnormalVisualEffect[] getAbnormalVisualEffects() {
        return this._abnormalVisualEffects;
    }

    public boolean hasAbnormalVisualEffects() {
        return this._abnormalVisualEffects != null && this._abnormalVisualEffects.length > 0;
    }

    public AbnormalVisualEffect[] getAbnormalVisualEffectsSpecial() {
        return this._abnormalVisualEffectsSpecial;
    }

    public boolean hasAbnormalVisualEffectsSpecial() {
        return this._abnormalVisualEffectsSpecial != null && this._abnormalVisualEffectsSpecial.length > 0;
    }

    public AbnormalVisualEffect[] getAbnormalVisualEffectsEvent() {
        return this._abnormalVisualEffectsEvent;
    }

    public boolean hasAbnormalVisualEffectsEvent() {
        return this._abnormalVisualEffectsEvent != null && this._abnormalVisualEffectsEvent.length > 0;
    }

    public int getMagicLevel() {
        return this._magicLevel;
    }

    public int getLvlBonusRate() {
        return this._lvlBonusRate;
    }

    public int getActivateRate() {
        return this._activateRate;
    }

    public int getMinChance() {
        return this._minChance;
    }

    public int getMaxChance() {
        return this._maxChance;
    }

    public boolean isRemovedOnAnyActionExceptMove() {
        return this._abnormalType == AbnormalType.INVINCIBILITY || this._abnormalType == AbnormalType.HIDE;
    }

    public boolean isRemovedOnDamage() {
        return this._abnormalType == AbnormalType.SLEEP || this._abnormalType == AbnormalType.FORCE_MEDITATION || this._abnormalType == AbnormalType.HIDE;
    }

    public boolean isBlockedInOlympiad() {
        return this._blockedInOlympiad;
    }

    public int getChannelingSkillId() {
        return this._channelingSkillId;
    }

    public boolean nextActionIsAttack() {
        return this._nextActionIsAttack;
    }

    public int getCastRange() {
        return this._castRange;
    }

    public int getEffectRange() {
        return this._effectRange;
    }

    public int getHpConsume() {
        return this._hpConsume;
    }

    @Override
    public int getId() {
        return this._id;
    }

    public boolean isDebuff() {
        return this._isDebuff;
    }

    public boolean isRecoveryHerb() {
        return this._isRecoveryHerb;
    }

    public int getDisplayId() {
        return this._displayId;
    }

    public int getDisplayLevel() {
        return this._displayLevel;
    }

    public BaseStats getBasicProperty() {
        return this._basicProperty;
    }

    public int getItemConsumeCount() {
        return this._itemConsumeCount;
    }

    public int getItemConsumeId() {
        return this._itemConsumeId;
    }

    public int getLevel() {
        return this._level;
    }

    public boolean isPhysical() {
        return this._magic == 0;
    }

    public boolean isMagic() {
        return this._magic == 1;
    }

    public boolean isStatic() {
        return this._magic == 2;
    }

    public boolean isDance() {
        return this._magic == 3;
    }

    public boolean isTrigger() {
        return this._magic == 4;
    }

    public boolean isReuseDelayLocked() {
        return this._reuseDelayLock;
    }

    public int getMpConsume1() {
        return this._mpConsume1;
    }

    public int getMpConsume2() {
        return this._mpConsume2;
    }

    public int getMpPerChanneling() {
        return this._mpPerChanneling;
    }

    public String getName() {
        return this._name;
    }

    public int getReuseDelay() {
        return this._reuseDelay;
    }

    public int getReuseHashCode() {
        return this._reuseHashCode;
    }

    public int getHitTime() {
        return this.hitTime;
    }

    public int getHitCancelTime() {
        return this.hitCancelTime;
    }

    public int getCoolTime() {
        return this._coolTime;
    }

    public int getAffectLimit() {
        if (this.affectLimit[1] == 0) {
            return 0;
        }
        return this.affectLimit[0] + Rnd.get((int)this.affectLimit[1]);
    }

    public AffectObject getAffectObject() {
        return this.affectObject;
    }

    public int getAffectRange() {
        return this.affectRange;
    }

    public AffectScope getAffectScope() {
        return this.affectScope;
    }

    public int[] getFanRange() {
        return this.fanRange;
    }

    public boolean isActive() {
        return this._operateType != null && this._operateType.isActive();
    }

    public boolean isPassive() {
        return this._operateType != null && this._operateType.isPassive();
    }

    public boolean isToggle() {
        return this._operateType != null && this._operateType.isToggle();
    }

    public boolean isContinuous() {
        return this._operateType != null && this._operateType.isContinuous() || this.isSelfContinuous();
    }

    public boolean isSelfContinuous() {
        return this._operateType != null && this._operateType.isSelfContinuous();
    }

    public boolean isChanneling() {
        return this._operateType != null && this._operateType.isChanneling();
    }

    public boolean isFlyType() {
        return this._operateType != null && this._operateType.isFlyType();
    }

    public boolean isTransformation() {
        return this._abnormalType == AbnormalType.TRANSFORM;
    }

    public int getEffectPoint() {
        return this._effectPoint;
    }

    public boolean useSoulShot() {
        return this.hasEffectType(L2EffectType.PHYSICAL_ATTACK, new L2EffectType[0]);
    }

    public boolean useSpiritShot() {
        return this._magic == 1;
    }

    public boolean useFishShot() {
        return this.hasEffectType(L2EffectType.FISHING, new L2EffectType[0]);
    }

    public int getMinPledgeClass() {
        return this._minPledgeClass;
    }

    public boolean isHeroSkill() {
        return SkillTreesData.getInstance().isHeroSkill(this._id, this._level);
    }

    public boolean isGMSkill() {
        return SkillTreesData.getInstance().isGMSkill(this._id, this._level);
    }

    public boolean is7Signs() {
        return this._id > 4360 && this._id < 4367;
    }

    public boolean isHealingPotionSkill() {
        return this.getAbnormalType() == AbnormalType.HP_RECOVER;
    }

    public int getChargeConsume() {
        return this._chargeConsume;
    }

    public int getMaxSoulConsumeCount() {
        return this._soulMaxConsume;
    }

    public boolean isStayAfterDeath() {
        return this._stayAfterDeath;
    }

    public boolean isStayOnSubclassChange() {
        return this._stayOnSubclassChange;
    }

    public boolean isBad() {
        return this._effectPoint < 0 && this.targetType != TargetType.SELF && this.targetType != TargetType.SUMMON;
    }

    public boolean checkCondition(L2Character activeChar, L2Object object, boolean itemOrWeapon) {
        List<Condition> preCondition;
        if (activeChar.canOverrideCond(PcCondOverride.SKILL_CONDITIONS) && !Configuration.general().gmSkillRestriction()) {
            return true;
        }
        if (activeChar.isPlayer() && !this.canBeUseWhileRiding((L2PcInstance)activeChar)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(this._id);
            activeChar.sendPacket(sm);
            return false;
        }
        List<Condition> list = preCondition = itemOrWeapon ? this._itemPreCondition : this._preCondition;
        if (preCondition == null || preCondition.isEmpty()) {
            return true;
        }
        L2Character target = object instanceof L2Character ? (L2Character)object : null;
        for (Condition cond : preCondition) {
            if (cond.test(activeChar, target, this)) continue;
            String msg = cond.getMessage();
            int msgId = cond.getMessageId();
            if (msgId != 0) {
                SystemMessage sm = SystemMessage.getSystemMessage(msgId);
                if (cond.isAddName()) {
                    sm.addSkillName(this._id);
                }
                activeChar.sendPacket(sm);
            } else if (msg != null) {
                activeChar.sendMessage(msg);
            }
            return false;
        }
        return true;
    }

    public boolean canBeUseWhileRiding(L2PcInstance player) {
        return this._rideState == null || this._rideState.contains((Object)player.getMountType());
    }

    public List<L2Object> getTargets(L2Character creature) {
        return this.getTargets(creature, creature.getTarget());
    }

    public List<L2Object> getTargets(L2Character creature, L2Object target) {
        return this.targetType.getTargets(this, creature, target);
    }

    @Deprecated
    public static boolean checkForAreaOffensiveSkills(L2Character caster, L2Character target, Skill skill, boolean sourceInArena) {
        if (target == null || target.isDead() || target == caster) {
            return false;
        }
        L2PcInstance player = caster.getActingPlayer();
        L2PcInstance targetPlayer = target.getActingPlayer();
        if (player != null) {
            if (targetPlayer != null) {
                if (targetPlayer == caster || targetPlayer == player) {
                    return false;
                }
                if (targetPlayer.inObserverMode()) {
                    return false;
                }
                if (skill.isBad() && player.getSiegeState() > 0 && player.isInsideZone(ZoneId.SIEGE) && player.getSiegeState() == targetPlayer.getSiegeState() && player.getSiegeSide() == targetPlayer.getSiegeSide()) {
                    return false;
                }
                if (skill.isBad() && target.isInsideZone(ZoneId.PEACE)) {
                    return false;
                }
                if (player.isInParty() && targetPlayer.isInParty()) {
                    if (player.getParty().getLeaderObjectId() == targetPlayer.getParty().getLeaderObjectId()) {
                        return false;
                    }
                    if (player.getParty().isInCommandChannel() && player.getParty().getCommandChannel() == targetPlayer.getParty().getCommandChannel()) {
                        return false;
                    }
                }
                if (!TvTEvent.checkForTvTSkill(player, targetPlayer, skill)) {
                    return false;
                }
                if (!(sourceInArena || targetPlayer.isInsideZone(ZoneId.PVP) && !targetPlayer.isInsideZone(ZoneId.SIEGE))) {
                    if (player.getAllyId() != 0 && player.getAllyId() == targetPlayer.getAllyId()) {
                        return false;
                    }
                    if (player.getClanId() != 0 && player.getClanId() == targetPlayer.getClanId()) {
                        return false;
                    }
                    if (!player.checkPvpSkill(targetPlayer, skill)) {
                        return false;
                    }
                }
            }
        } else if (targetPlayer == null && target instanceof L2Attackable && caster instanceof L2Attackable) {
            return false;
        }
        return GeoData.getInstance().canSeeTarget((L2Object)caster, target);
    }

    public List<AbstractFunction> getStatFuncs(AbstractEffect effect, L2Character player) {
        if (this._funcTemplates == null) {
            return Collections.emptyList();
        }
        if (!(player instanceof L2Playable) && !(player instanceof L2Attackable)) {
            return Collections.emptyList();
        }
        ArrayList<AbstractFunction> funcs = new ArrayList<AbstractFunction>(this._funcTemplates.size());
        for (FuncTemplate t : this._funcTemplates) {
            AbstractFunction f = t.getFunc(player, null, this, (Object)this);
            if (f == null) continue;
            funcs.add(f);
        }
        return funcs;
    }

    public List<AbstractEffect> getEffects(EffectScope effectScope) {
        return this._effectLists.get((Object)effectScope);
    }

    public boolean hasEffects(EffectScope effectScope) {
        List<AbstractEffect> effects = this._effectLists.get((Object)effectScope);
        return effects != null && !effects.isEmpty();
    }

    public void applyEffectScope(EffectScope effectScope, BuffInfo info, boolean applyInstantEffects, boolean addContinuousEffects) {
        if (effectScope != null && this.hasEffects(effectScope)) {
            for (AbstractEffect effect : this.getEffects(effectScope)) {
                if (effect == null) continue;
                if (effect.isInstant()) {
                    if (!applyInstantEffects || !effect.calcSuccess(info)) continue;
                    effect.onStart(info);
                    continue;
                }
                if (!addContinuousEffects || !effect.canStart(info)) continue;
                info.addEffect(effect);
            }
        }
    }

    public void applyEffects(L2Character effector, L2Character effected) {
        this.applyEffects(effector, effected, -1, false, false, true, 0);
    }

    public void applyEffects(L2Character effector, L2Character effected, boolean instant, int abnormalTime) {
        this.applyEffects(effector, effected, -1, false, false, instant, abnormalTime);
    }

    public void applyEffects(L2Character effector, L2Character effected, int index, boolean self, boolean passive, boolean instant, int abnormalTime) {
        BuffInfo info;
        boolean addContinuousEffects;
        if (effected == null) {
            return;
        }
        if (effector != effected && this.isBad() && (effected.isInvul() || effector.isGM() && !effector.getAccessLevel().canGiveDamage())) {
            return;
        }
        if (this.isDebuff() ? effected.isDebuffBlocked() : effected.isBuffBlocked() && !this.isBad()) {
            return;
        }
        if (effected.isInvulAgainst(this.getId(), this.getLevel())) {
            effected.sendDebugMessage("Skill " + String.valueOf(this) + " has been ignored (invul against)");
            return;
        }
        boolean bl = addContinuousEffects = !passive && (this._operateType.isToggle() || this._operateType.isContinuous() && Formulas.calcEffectSuccess(effector, effected, this));
        if (!self && !passive) {
            info = new BuffInfo(effector, effected, index, this);
            if (effector.isPlayer() && this.getMaxSoulConsumeCount() > 0) {
                info.setCharges(effector.getActingPlayer().decreaseSouls(this.getMaxSoulConsumeCount()));
            }
            if (addContinuousEffects && abnormalTime > 0) {
                info.setAbnormalTime(abnormalTime);
            }
            this.applyEffectScope(EffectScope.GENERAL, info, instant, addContinuousEffects);
            EffectScope pvpOrPveEffectScope = effector.isPlayable() && effected.isAttackable() ? EffectScope.PVE : (effector.isPlayable() && effected.isPlayable() ? EffectScope.PVP : null);
            this.applyEffectScope(pvpOrPveEffectScope, info, instant, addContinuousEffects);
            this.applyEffectScope(EffectScope.CHANNELING, info, instant, addContinuousEffects);
            if (addContinuousEffects) {
                effected.getEffectList().add(info);
            }
            if (effected.isPlayer() && effected.hasServitor() && !this.isTransformation() && this.getAbnormalType() != AbnormalType.SUMMON_CONDITION && (addContinuousEffects && this.isContinuous() && !this.isDebuff() || this.isRecoveryHerb())) {
                this.applyEffects(effector, effected.getSummon(), this.isRecoveryHerb(), 0);
            }
        }
        if (self) {
            addContinuousEffects = !passive && (this._operateType.isToggle() || (this._operateType.isContinuous() || this._operateType.isSelfContinuous()) && Formulas.calcEffectSuccess(effector, effector, this));
            info = new BuffInfo(effector, effector, this);
            if (addContinuousEffects && abnormalTime > 0) {
                info.setAbnormalTime(abnormalTime);
            }
            this.applyEffectScope(EffectScope.SELF, info, instant, addContinuousEffects);
            if (addContinuousEffects && this.hasEffectType(L2EffectType.BUFF, new L2EffectType[0])) {
                info.getEffector().getEffectList().add(info);
            }
            if (addContinuousEffects && info.getEffected().isPlayer() && info.getEffected().hasServitor() && this.isContinuous() && !this.isDebuff() && this.getId() != CommonSkill.SERVITOR_SHARE.getId()) {
                this.applyEffects(effector, info.getEffected().getSummon(), false, 0);
            }
        }
        if (passive) {
            info = new BuffInfo(effector, effector, this);
            this.applyEffectScope(EffectScope.PASSIVE, info, false, true);
            effector.getEffectList().add(info);
        }
    }

    public void activateSkill(L2Character caster, L2Object target) {
        this.activateSkill(caster, null, List.of(target));
    }

    public void activateSkill(L2Character caster, List<L2Object> targets) {
        this.activateSkill(caster, null, targets);
    }

    public void activateSkill(L2CubicInstance cubic, List<L2Object> targets) {
        this.activateSkill(cubic.getOwner(), cubic, targets);
    }

    private void activateSkill(L2Character caster, L2CubicInstance cubic, List<L2Object> targets) {
        switch (this.getId()) {
            case 5852: 
            case 5853: {
                L2PcInstance player;
                L2BlockInstance block = targets.get(0) instanceof L2BlockInstance ? (L2BlockInstance)targets.get(0) : null;
                L2PcInstance l2PcInstance = player = caster.isPlayer() ? (L2PcInstance)caster : null;
                if (block == null || player == null) {
                    return;
                }
                int arena = player.getBlockCheckerArena();
                if (arena == -1) break;
                ArenaParticipantsHolder holder = HandysBlockCheckerManager.getInstance().getHolder(arena);
                if (holder == null) {
                    return;
                }
                int team = holder.getPlayerTeam(player);
                int color = block.getColorEffect();
                if (team == 0 && color == 0) {
                    block.changeColor(player, holder, team);
                    break;
                }
                if (team != 1 || color != 83) break;
                block.changeColor(player, holder, team);
                break;
            }
            default: {
                for (L2Object obj : targets) {
                    L2Character target = (L2Character)obj;
                    if (Formulas.calcBuffDebuffReflection(target, this)) {
                        this.applyEffects(target, caster, false, 0);
                        BuffInfo info = new BuffInfo(caster, target, this);
                        this.applyEffectScope(EffectScope.GENERAL, info, true, false);
                        EffectScope pvpOrPveEffectScope = caster.isPlayable() && target.isAttackable() ? EffectScope.PVE : (caster.isPlayable() && target.isPlayable() ? EffectScope.PVP : null);
                        this.applyEffectScope(pvpOrPveEffectScope, info, true, false);
                        this.applyEffectScope(EffectScope.CHANNELING, info, true, false);
                        continue;
                    }
                    this.applyEffects(caster, target);
                }
            }
        }
        if (this.hasEffects(EffectScope.SELF)) {
            if (caster.isAffectedBySkill(this.getId())) {
                caster.stopSkillEffects(true, this.getId());
            }
            this.applyEffects(caster, caster, -1, true, false, true, 0);
        }
        if (cubic == null) {
            if (this.useSpiritShot()) {
                caster.setChargedShot(caster.isChargedShot(ShotType.BLESSED_SPIRITSHOTS) ? ShotType.BLESSED_SPIRITSHOTS : ShotType.SPIRITSHOTS, false);
            } else if (this.useSoulShot()) {
                caster.setChargedShot(ShotType.SOULSHOTS, false);
            }
        }
        if (this.isSuicideAttack()) {
            caster.doDie(caster);
        }
    }

    public void attach(FuncTemplate f) {
        if (this._funcTemplates == null) {
            this._funcTemplates = new ArrayList<FuncTemplate>(1);
        }
        this._funcTemplates.add(f);
    }

    public void addEffect(EffectScope effectScope, AbstractEffect effect) {
        List effects = this._effectLists.computeIfAbsent(effectScope, k -> new ArrayList(1));
        effects.add(effect);
    }

    public void attach(Condition c, boolean itemOrWeapon) {
        if (itemOrWeapon) {
            if (this._itemPreCondition == null) {
                this._itemPreCondition = new ArrayList<Condition>();
            }
            this._itemPreCondition.add(c);
        } else {
            if (this._preCondition == null) {
                this._preCondition = new ArrayList<Condition>();
            }
            this._preCondition.add(c);
        }
    }

    public String toString() {
        return "Skill " + this._name + "(" + this._id + "," + this._level + ")";
    }

    public int getReferenceItemId() {
        return this._refId;
    }

    public void setReferenceItemId(int val) {
        this._refId = val;
    }

    public boolean isIrreplaceableBuff() {
        return this._irreplaceableBuff;
    }

    public boolean canBeStolen() {
        return !this.isPassive() && !this.isToggle() && !this.isDebuff() && !this.isHeroSkill() && !this.isGMSkill() && !this.isIrreplaceableBuff() && (!this.isStatic() || this.getId() == CommonSkill.CARAVANS_SECRET_MEDICINE.getId() || this.getMagicLevel() < 0);
    }

    public boolean isClanSkill() {
        return SkillTreesData.getInstance().isClanSkill(this._id, this._level);
    }

    public boolean isExcludedFromCheck() {
        return this._excludedFromCheck;
    }

    public boolean isSimultaneousCast() {
        return this._simultaneousCast;
    }

    private L2ExtractableSkill parseExtractableSkill(int skillId, int skillLvl, String values) {
        String[] prodLists = values.split(";");
        ArrayList<L2ExtractableProductItem> products = new ArrayList<L2ExtractableProductItem>();
        for (String prodList : prodLists) {
            String[] prodData = prodList.split(",");
            if (prodData.length < 3) {
                LOG.warn("Extractable skills data: Error in Skill Id: {} Level: {} -> wrong separator!", (Object)skillId, (Object)skillLvl);
            }
            ArrayList<ItemHolder> items = null;
            double chance = 0.0;
            int length = prodData.length - 1;
            try {
                items = new ArrayList<ItemHolder>(length / 2);
                for (int j = 0; j < length; j += 2) {
                    int prodId = Integer.parseInt(prodData[j]);
                    int quantity = Integer.parseInt(prodData[j + 1]);
                    if (prodId <= 0 || quantity <= 0) {
                        LOG.warn("Extractable skills data: Error in Skill Id: {} Level: {} wrong production Id: {} or wrong quantity: {}!", skillId, skillLvl, prodId, quantity);
                    }
                    items.add(new ItemHolder(prodId, quantity));
                }
                chance = Double.parseDouble(prodData[length]);
            }
            catch (Exception e) {
                LOG.warn("Extractable skills data: Error in Skill Id: {} Level: {} -> incomplete/invalid production data or wrong separator!", (Object)skillId, (Object)skillLvl);
            }
            products.add(new L2ExtractableProductItem(items, chance));
        }
        if (products.isEmpty()) {
            LOG.warn("Extractable skills data: Error in Skill Id: {} Level: {} -> There are no production items!", (Object)skillId, (Object)skillLvl);
        }
        return new L2ExtractableSkill(SkillData.getSkillHashCode(skillId, skillLvl), products);
    }

    private void parseAbnormalVisualEffect(String abnormalVisualEffects) {
        if (abnormalVisualEffects != null) {
            String[] data = abnormalVisualEffects.split(";");
            ArrayList<AbnormalVisualEffect> avesEvent = null;
            ArrayList<AbnormalVisualEffect> avesSpecial = null;
            ArrayList<AbnormalVisualEffect> aves = null;
            for (String ave2 : data) {
                AbnormalVisualEffect ave = AbnormalVisualEffect.valueOf(ave2);
                if (ave.isEvent()) {
                    if (avesEvent == null) {
                        avesEvent = new ArrayList<AbnormalVisualEffect>(1);
                    }
                    avesEvent.add(ave);
                    continue;
                }
                if (ave.isSpecial()) {
                    if (avesSpecial == null) {
                        avesSpecial = new ArrayList<AbnormalVisualEffect>(1);
                    }
                    avesSpecial.add(ave);
                    continue;
                }
                if (aves == null) {
                    aves = new ArrayList<AbnormalVisualEffect>(1);
                }
                aves.add(ave);
            }
            if (avesEvent != null) {
                this._abnormalVisualEffectsEvent = avesEvent.toArray(new AbnormalVisualEffect[0]);
            }
            if (avesSpecial != null) {
                this._abnormalVisualEffectsSpecial = avesSpecial.toArray(new AbnormalVisualEffect[0]);
            }
            if (aves != null) {
                this._abnormalVisualEffects = aves.toArray(new AbnormalVisualEffect[0]);
            }
        }
    }

    public L2ExtractableSkill getExtractableSkill() {
        return this._extractableItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasEffectType(L2EffectType effectType, L2EffectType ... effectTypes) {
        if (this._effectTypes != null) ** GOTO lbl16
        var3_3 = this;
        synchronized (this) {
            if (this._effectTypes != null) ** GOTO lbl15
            effectTypesSet = new HashSet<Byte>();
            var5_6 = this._effectLists.values().iterator();
            while (true) {
                if (var5_6.hasNext()) {
                    effectList = var5_6.next();
                    if (effectList == null) continue;
                } else {
                    effectTypesArray = effectTypesSet.toArray(new Byte[0]);
                    Arrays.sort(effectTypesArray);
                    this._effectTypes = effectTypesArray;
lbl15:
                    // 2 sources

                    // ** MonitorExit[var3_3] (shouldn't be in output)
lbl16:
                    // 2 sources

                    if (Arrays.binarySearch((Object[])this._effectTypes, (Object)((byte)effectType.ordinal())) >= 0) {
                        return true;
                    }
                    break;
                }
                var7_9 = effectList.iterator();
                while (true) {
                    if (!var7_9.hasNext()) ** break;
                    effect = var7_9.next();
                    if (effect == null) continue;
                    effectTypesSet.add((byte)effect.getEffectType().ordinal());
                }
                break;
            }
            var3_3 = effectTypes;
            var4_5 = var3_3.length;
            var5_7 = 0;
            while (true) {
                if (var5_7 >= var4_5) {
                    return false;
                }
                type = var3_3[var5_7];
                if (Arrays.binarySearch((Object[])this._effectTypes, (Object)((byte)type.ordinal())) >= 0) {
                    return true;
                }
                ++var5_7;
            }
        }
    }

    public String getIcon() {
        return this._icon;
    }

    public int getChannelingTickInterval() {
        return this._channelingTickInterval;
    }

    public int getChannelingTickInitialDelay() {
        return this._channelingTickInitialDelay;
    }

    public Set<MountType> getRideState() {
        return this._rideState;
    }
}

