/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.skills.targets;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.skills.targets.AffectObject;

public enum AffectObjectStaticImpl implements AffectObject
{
    ALL{

        @Override
        public boolean affectObject(L2Character caster, L2Object object) {
            return true;
        }
    }
    ,
    CLAN{

        @Override
        public boolean affectObject(L2Character caster, L2Object object) {
            if (caster.isPlayable()) {
                int clanId = caster.getClanId();
                if (clanId == 0) {
                    return false;
                }
                if (!object.isPlayable()) {
                    return false;
                }
                L2Character creature = (L2Character)object;
                return clanId == creature.getClanId();
            }
            if (caster.isNpc()) {
                // empty if block
            }
            return false;
        }
    }
    ,
    FRIEND{

        @Override
        public boolean affectObject(L2Character caster, L2Object object) {
            return !object.isAutoAttackable(caster);
        }
    }
    ,
    HIDDEN_PLACE{

        @Override
        public boolean affectObject(L2Character caster, L2Object object) {
            return false;
        }
    }
    ,
    INVISIBLE{

        @Override
        public boolean affectObject(L2Character caster, L2Object object) {
            return !object.isVisibleFor(caster) || object.isInvisible();
        }
    }
    ,
    NONE{

        @Override
        public boolean affectObject(L2Character caster, L2Object object) {
            return false;
        }
    }
    ,
    NOT_FRIEND{

        @Override
        public boolean affectObject(L2Character caster, L2Object object) {
            if (object instanceof L2Character) {
                L2Character target = (L2Character)object;
                if (target.isDead()) {
                    return false;
                }
                if (caster instanceof L2Npc) {
                    return target instanceof L2Playable;
                }
            }
            return object.isAutoAttackable(caster);
        }
    }
    ,
    OBJECT_DEAD_NPC_BODY{

        @Override
        public boolean affectObject(L2Character caster, L2Object object) {
            if (!object.isNpc()) {
                return false;
            }
            L2Npc npc = (L2Npc)object;
            return npc.isDead();
        }
    }
    ,
    UNDEAD_REAL_ENEMY{

        @Override
        public boolean affectObject(L2Character caster, L2Object object) {
            if (!object.isNpc()) {
                return false;
            }
            L2Npc npc = (L2Npc)object;
            return npc.isUndead();
        }
    }
    ,
    WYVERN_OBJECT{

        @Override
        public boolean affectObject(L2Character caster, L2Object object) {
            if (!object.isNpc()) {
                return false;
            }
            return 12621 == object.getId();
        }
    };

    private static final int WYVERN_ID = 12621;

    @Override
    public abstract boolean affectObject(L2Character var1, L2Object var2);
}

