/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.form;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.model.zone.L2ZoneForm;
import java.awt.Polygon;
import java.awt.Rectangle;

public class ZoneNPoly
extends L2ZoneForm {
    private final Polygon _p;
    private final int _z1;
    private final int _z2;

    public ZoneNPoly(int[] x, int[] y, int z1, int z2) {
        this._p = new Polygon(x, y, x.length);
        this._z1 = Math.min(z1, z2);
        this._z2 = Math.max(z1, z2);
    }

    @Override
    public Rectangle getBoundingBox() {
        return this._p.getBounds();
    }

    @Override
    public boolean isInsideZone(int x, int y, int z) {
        return this._p.contains(x, y) && z >= this._z1 && z <= this._z2;
    }

    @Override
    public boolean intersectsRectangle(int ax1, int ax2, int ay1, int ay2) {
        return this._p.intersects(Math.min(ax1, ax2), Math.min(ay1, ay2), Math.abs(ax2 - ax1), Math.abs(ay2 - ay1));
    }

    @Override
    public double getDistanceToZone(int x, int y) {
        int[] _x = this._p.xpoints;
        int[] _y = this._p.ypoints;
        double shortestDist = Math.pow(_x[0] - x, 2.0) + Math.pow(_y[0] - y, 2.0);
        for (int i = 1; i < this._p.npoints; ++i) {
            double test = Math.pow(_x[i] - x, 2.0) + Math.pow(_y[i] - y, 2.0);
            if (!(test < shortestDist)) continue;
            shortestDist = test;
        }
        return Math.sqrt(shortestDist);
    }

    @Override
    public int getLowZ() {
        return this._z1;
    }

    @Override
    public int getHighZ() {
        return this._z2;
    }

    @Override
    public void visualizeZone(int z) {
        int[] _x = this._p.xpoints;
        int[] _y = this._p.ypoints;
        for (int i = 0; i < this._p.npoints; ++i) {
            int nextIndex = i + 1;
            if (nextIndex == _x.length) {
                nextIndex = 0;
            }
            int vx = _x[nextIndex] - _x[i];
            int vy = _y[nextIndex] - _y[i];
            float length = (float)Math.sqrt(vx * vx + vy * vy);
            length /= 10.0f;
            int o = 1;
            while ((float)o <= length) {
                float k = (float)o / length;
                this.dropDebugItem(57, 1, (int)((float)_x[i] + k * (float)vx), (int)((float)_y[i] + k * (float)vy), z);
                ++o;
            }
        }
    }

    @Override
    public int[] getRandomPoint() {
        int _minX = this._p.getBounds().x;
        int _maxX = this._p.getBounds().x + this._p.getBounds().width;
        int _minY = this._p.getBounds().y;
        int _maxY = this._p.getBounds().y + this._p.getBounds().height;
        int x = Rnd.get((int)_minX, (int)_maxX);
        int y = Rnd.get((int)_minY, (int)_maxY);
        int antiBlocker = 0;
        while (!this._p.contains(x, y) && antiBlocker++ < 1000) {
            x = Rnd.get((int)_minX, (int)_maxX);
            y = Rnd.get((int)_minY, (int)_maxY);
        }
        return new int[]{x, y, GeoData.getInstance().getHeight(x, y, this._z1)};
    }
}

