/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.zone.AbstractZoneSettings;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.TaskZoneSettings;

public class L2DynamicZone
extends L2ZoneType {
    private final L2WorldRegion _region;
    private final L2Character _owner;
    private final Skill _skill;

    public L2DynamicZone(L2WorldRegion region, L2Character owner, Skill skill) {
        super(-1);
        this._region = region;
        this._owner = owner;
        this._skill = skill;
        AbstractZoneSettings settings = ZoneManager.getSettings(this.getName());
        if (settings == null) {
            settings = new TaskZoneSettings();
        }
        this.setSettings(settings);
        this.getSettings().setTask(ThreadPoolManager.getInstance().scheduleGeneral(this::remove, skill.getAbnormalTime() * 1000));
    }

    @Override
    public TaskZoneSettings getSettings() {
        return (TaskZoneSettings)super.getSettings();
    }

    @Override
    protected void onEnter(L2Character character) {
        if (character.isPlayer()) {
            character.sendMessage("You have entered a temporary zone!");
        }
        if (this._owner != null) {
            this._skill.applyEffects(this._owner, character);
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (character.isPlayer()) {
            character.sendMessage("You have left a temporary zone!");
        }
        if (character == this._owner) {
            this.remove();
            return;
        }
        character.stopSkillEffects(true, this._skill.getId());
    }

    protected void remove() {
        if (this.getSettings().getTask() == null || this._skill == null) {
            return;
        }
        this.getSettings().getTask().cancel(false);
        this._region.removeZone(this);
        for (L2Character member : this.getCharactersInside()) {
            member.stopSkillEffects(true, this._skill.getId());
        }
        this._owner.stopSkillEffects(true, this._skill.getId());
    }

    @Override
    public void onDieInside(L2Character character) {
        if (character == this._owner) {
            this.remove();
        } else {
            character.stopSkillEffects(true, this._skill.getId());
        }
    }

    @Override
    public void onReviveInside(L2Character character) {
        this._skill.applyEffects(this._owner, character);
    }
}

