/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;

public final class AllyDismiss
extends L2GameClientPacket {
    private static final String _C__8F_ALLYDISMISS = "[C] 8F AllyDismiss";
    private String _clanName;

    @Override
    protected void readImpl() {
        this._clanName = this.readS();
    }

    @Override
    protected void runImpl() {
        if (this._clanName == null) {
            return;
        }
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        L2Clan leaderClan = player.getClan();
        if (leaderClan == null) {
            player.sendPacket(SystemMessageId.YOU_ARE_NOT_A_CLAN_MEMBER);
            return;
        }
        if (leaderClan.getAllyId() == 0) {
            player.sendPacket(SystemMessageId.NO_CURRENT_ALLIANCES);
            return;
        }
        if (!player.isClanLeader() || leaderClan.getId() != leaderClan.getAllyId()) {
            player.sendPacket(SystemMessageId.FEATURE_ONLY_FOR_ALLIANCE_LEADER);
            return;
        }
        L2Clan clan = ClanTable.getInstance().getClanByName(this._clanName);
        if (clan == null) {
            player.sendPacket(SystemMessageId.CLAN_DOESNT_EXISTS);
            return;
        }
        if (clan.getId() == leaderClan.getId()) {
            player.sendPacket(SystemMessageId.ALLIANCE_LEADER_CANT_WITHDRAW);
            return;
        }
        if (clan.getAllyId() != leaderClan.getAllyId()) {
            player.sendPacket(SystemMessageId.DIFFERENT_ALLIANCE);
            return;
        }
        long currentTime = System.currentTimeMillis();
        leaderClan.setAllyPenaltyExpiryTime(currentTime + Configuration.character().getDaysBeforeAcceptNewClanWhenDismissed(), 3);
        leaderClan.updateClanInDB();
        clan.setAllyId(0);
        clan.setAllyName(null);
        clan.changeAllyCrest(0, true);
        clan.setAllyPenaltyExpiryTime(currentTime + Configuration.character().getDaysBeforeJoinAllyWhenDismissed(), 2);
        clan.updateClanInDB();
        player.sendPacket(SystemMessageId.YOU_HAVE_EXPELED_A_CLAN);
    }

    @Override
    public String getType() {
        return _C__8F_ALLYDISMISS;
    }
}

