/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;

public final class AllyLeave
extends L2GameClientPacket {
    private static final String _C__8E_ALLYLEAVE = "[C] 8E AllyLeave";

    @Override
    protected void readImpl() {
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        L2Clan clan = player.getClan();
        if (clan == null) {
            player.sendPacket(SystemMessageId.YOU_ARE_NOT_A_CLAN_MEMBER);
            return;
        }
        if (!player.isClanLeader()) {
            player.sendPacket(SystemMessageId.ONLY_CLAN_LEADER_WITHDRAW_ALLY);
            return;
        }
        if (clan.getAllyId() == 0) {
            player.sendPacket(SystemMessageId.NO_CURRENT_ALLIANCES);
            return;
        }
        if (clan.getId() == clan.getAllyId()) {
            player.sendPacket(SystemMessageId.ALLIANCE_LEADER_CANT_WITHDRAW);
            return;
        }
        clan.setAllyId(0);
        clan.setAllyName(null);
        clan.changeAllyCrest(0, true);
        clan.setAllyPenaltyExpiryTime(System.currentTimeMillis() + Configuration.character().getDaysBeforeJoiningAllianceAfterLeaving(), 1);
        clan.updateClanInDB();
        player.sendPacket(SystemMessageId.YOU_HAVE_WITHDRAWN_FROM_ALLIANCE);
    }

    @Override
    public String getType() {
        return _C__8E_ALLYLEAVE;
    }
}

