/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.CharSelectInfoPackage;
import com.l2jserver.gameserver.model.events.Containers;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.BaseEvent;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerDelete;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.CharDeleteFail;
import com.l2jserver.gameserver.network.serverpackets.CharDeleteSuccess;
import com.l2jserver.gameserver.network.serverpackets.CharSelectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CharacterDelete
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(CharacterDelete.class);
    private static final String _C__0C_CHARACTERDELETE = "[C] 0D CharacterDelete";
    private int _charSlot;

    @Override
    protected void readImpl() {
        this._charSlot = this.readD();
    }

    @Override
    protected void runImpl() {
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getCharacterSelect().tryPerformAction("CharacterDelete")) {
            this.sendPacket(new CharDeleteFail(1));
            return;
        }
        if (Configuration.general().debug()) {
            LOG.debug("Deleting slot: {}", (Object)this._charSlot);
        }
        try {
            byte answer = ((L2GameClient)this.getClient()).markToDeleteChar(this._charSlot);
            switch (answer) {
                default: {
                    break;
                }
                case 0: {
                    this.sendPacket(new CharDeleteSuccess());
                    CharSelectInfoPackage charInfo = ((L2GameClient)this.getClient()).getCharSelection(this._charSlot);
                    EventDispatcher.getInstance().notifyEvent((BaseEvent)new PlayerDelete(charInfo.getObjectId(), charInfo.getName(), (L2GameClient)this.getClient()), Containers.Players());
                    break;
                }
                case 1: {
                    this.sendPacket(new CharDeleteFail(2));
                    break;
                }
                case 2: {
                    this.sendPacket(new CharDeleteFail(3));
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error:", e);
        }
        CharSelectionInfo cl = new CharSelectionInfo(((L2GameClient)this.getClient()).getAccountName(), ((L2GameClient)this.getClient()).getSessionId().playOkID1, 0);
        this.sendPacket(cl);
        ((L2GameClient)this.getClient()).setCharSelection(cl.getCharInfo());
    }

    @Override
    public String getType() {
        return _C__0C_CHARACTERDELETE;
    }
}

