/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.SkillTreesData;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.IllegalActionPunishmentType;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2VillageMasterInstance;
import com.l2jserver.gameserver.model.base.AcquireSkillType;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerSkillLearned;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillDone;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillList;
import com.l2jserver.gameserver.network.serverpackets.ExStorageMaxCount;
import com.l2jserver.gameserver.network.serverpackets.PledgeSkillList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestAcquireSkill
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestAcquireSkill.class);
    private static final String _C__7C_REQUESTACQUIRESKILL = "[C] 7C RequestAcquireSkill";
    private static final String[] QUEST_VAR_NAMES = new String[]{"EmergentAbility65-", "EmergentAbility70-", "ClassAbility75-", "ClassAbility80-"};
    private int _id;
    private int _level;
    private AcquireSkillType _skillType;
    private int _subType;

    @Override
    protected void readImpl() {
        this._id = this.readD();
        this._level = this.readD();
        this._skillType = AcquireSkillType.getAcquireSkillType(this.readD());
        if (this._skillType == AcquireSkillType.SUBPLEDGE) {
            this._subType = this.readD();
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (this._level < 1 || this._level > 1000 || this._id < 1 || this._id > 32000) {
            Util.handleIllegalPlayerAction(activeChar, "Wrong Packet Data in Acquired Skill");
            LOG.warn("Received wrong packet data from player {} with skill id: {} and level: {}!" + this._level, activeChar, this._id, this._level);
            return;
        }
        L2Npc trainer = activeChar.getLastFolkNPC();
        if (!(trainer instanceof L2NpcInstance)) {
            return;
        }
        if (!trainer.canInteract(activeChar) && !activeChar.isGM()) {
            return;
        }
        Skill skill = SkillData.getInstance().getSkill(this._id, this._level);
        if (skill == null) {
            LOG.warn("Player {} is trying to learn an invalid skill Id: {} level: {}!", activeChar, this._id, this._level);
            return;
        }
        L2SkillLearn skillLearn = SkillTreesData.getInstance().getSkillLearn(this._skillType, this._id, this._level, activeChar);
        if (!this.canBeLearn(activeChar, skill, skillLearn)) {
            return;
        }
        switch (this._skillType) {
            case CLASS: {
                if (!this.checkPlayerSkill(activeChar, trainer, skillLearn)) break;
                this.giveSkill(activeChar, trainer, skill);
                break;
            }
            case TRANSFORM: {
                if (!RequestAcquireSkill.canTransform(activeChar)) {
                    activeChar.sendPacket(SystemMessageId.NOT_COMPLETED_QUEST_FOR_SKILL_ACQUISITION);
                    Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " is requesting skill Id: " + this._id + " level " + this._level + " without required quests!", IllegalActionPunishmentType.NONE);
                    return;
                }
                if (!this.checkPlayerSkill(activeChar, trainer, skillLearn)) break;
                this.giveSkill(activeChar, trainer, skill);
                break;
            }
            case FISHING: {
                if (!this.checkPlayerSkill(activeChar, trainer, skillLearn)) break;
                this.giveSkill(activeChar, trainer, skill);
                break;
            }
            case PLEDGE: {
                if (!activeChar.isClanLeader()) {
                    return;
                }
                L2Clan clan = activeChar.getClan();
                int repCost = skillLearn.getLevelUpSp();
                if (clan.getReputationScore() >= repCost) {
                    if (Configuration.character().lifeCrystalNeeded()) {
                        for (ItemHolder item : skillLearn.getRequiredItems()) {
                            if (!activeChar.destroyItemByItemId("Consume", item.getId(), item.getCount(), trainer, false)) {
                                activeChar.sendPacket(SystemMessageId.ITEM_OR_PREREQUISITES_MISSING_TO_LEARN_SKILL);
                                L2VillageMasterInstance.showPledgeSkillList(activeChar);
                                return;
                            }
                            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                            sm.addItemName(item.getId());
                            sm.addLong(item.getCount());
                            activeChar.sendPacket(sm);
                        }
                    }
                    clan.takeReputationScore(repCost, true);
                    SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                    cr.addInt(repCost);
                    activeChar.sendPacket(cr);
                    clan.addNewSkill(skill);
                    clan.broadcastToOnlineMembers(new PledgeSkillList(clan));
                    activeChar.sendPacket(new AcquireSkillDone());
                    L2VillageMasterInstance.showPledgeSkillList(activeChar);
                    break;
                }
                activeChar.sendPacket(SystemMessageId.ACQUIRE_SKILL_FAILED_BAD_CLAN_REP_SCORE);
                L2VillageMasterInstance.showPledgeSkillList(activeChar);
                break;
            }
            case SUBPLEDGE: {
                L2Clan clan = activeChar.getClan();
                int repCost = skillLearn.getLevelUpSp();
                if (clan.getReputationScore() < repCost) {
                    activeChar.sendPacket(SystemMessageId.ACQUIRE_SKILL_FAILED_BAD_CLAN_REP_SCORE);
                    return;
                }
                for (ItemHolder item : skillLearn.getRequiredItems()) {
                    if (!activeChar.destroyItemByItemId("SubSkills", item.getId(), item.getCount(), trainer, false)) {
                        activeChar.sendPacket(SystemMessageId.ITEM_OR_PREREQUISITES_MISSING_TO_LEARN_SKILL);
                        return;
                    }
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                    sm.addItemName(item.getId());
                    sm.addLong(item.getCount());
                    activeChar.sendPacket(sm);
                }
                if (repCost > 0) {
                    clan.takeReputationScore(repCost, true);
                    SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                    cr.addInt(repCost);
                    activeChar.sendPacket(cr);
                }
                clan.addNewSkill(skill, this._subType);
                clan.broadcastToOnlineMembers(new PledgeSkillList(clan));
                activeChar.sendPacket(new AcquireSkillDone());
                RequestAcquireSkill.showSubUnitSkillList(activeChar);
                break;
            }
            case TRANSFER: {
                if (!this.checkPlayerSkill(activeChar, trainer, skillLearn)) break;
                this.giveSkill(activeChar, trainer, skill);
                break;
            }
            case SUBCLASS: {
                QuestState st = activeChar.getQuestState("SubClassSkills");
                if (st == null) {
                    Quest subClassSkillsQuest = QuestManager.getInstance().getQuest("SubClassSkills");
                    if (subClassSkillsQuest != null) {
                        st = subClassSkillsQuest.newQuestState(activeChar);
                    } else {
                        LOG.warn("Player {} does not have sub-class quest for skill Id: {} level: {}!", activeChar, this._id, this._level);
                        return;
                    }
                }
                for (String varName : QUEST_VAR_NAMES) {
                    for (int i = 1; i <= Configuration.character().getMaxSubclass(); ++i) {
                        String itemOID = st.getGlobalQuestVar(varName + i);
                        if (itemOID.isEmpty() || itemOID.endsWith(";") || itemOID.equals("0")) continue;
                        if (Util.isDigit(itemOID)) {
                            int itemObjId = Integer.parseInt(itemOID);
                            L2ItemInstance item = activeChar.getInventory().getItemByObjectId(itemObjId);
                            if (item != null) {
                                for (ItemHolder itemIdCount : skillLearn.getRequiredItems()) {
                                    if (item.getId() != itemIdCount.getId()) continue;
                                    if (this.checkPlayerSkill(activeChar, trainer, skillLearn)) {
                                        this.giveSkill(activeChar, trainer, skill);
                                        st.saveGlobalQuestVar(varName + i, skill.getId() + ";");
                                    }
                                    return;
                                }
                                continue;
                            }
                            LOG.warn("Nonexistent item for object Id " + itemObjId + ", for Sub-Class skill Id: " + this._id + " level: " + this._level + " for player " + activeChar.getName() + "!");
                            continue;
                        }
                        LOG.warn("Invalid item object Id " + itemOID + ", for Sub-Class skill Id: " + this._id + " level: " + this._level + " for player " + activeChar.getName() + "!");
                    }
                }
                activeChar.sendPacket(SystemMessageId.ITEM_OR_PREREQUISITES_MISSING_TO_LEARN_SKILL);
                break;
            }
            case COLLECT: {
                if (!this.checkPlayerSkill(activeChar, trainer, skillLearn)) break;
                this.giveSkill(activeChar, trainer, skill);
                break;
            }
            default: {
                LOG.warn("Received wrong packet data in Acquired Skill, unknown skill type {}!", (Object)this._skillType);
            }
        }
    }

    private boolean canBeLearn(L2PcInstance activeChar, Skill skill, L2SkillLearn skl) {
        int prevSkillLevel = activeChar.getSkillLevel(this._id);
        switch (this._skillType) {
            case SUBPLEDGE: {
                L2Clan clan = activeChar.getClan();
                if (clan == null) {
                    return false;
                }
                if (!activeChar.isClanLeader() || !activeChar.hasClanPrivilege(ClanPrivilege.CL_TROOPS_FAME)) {
                    return false;
                }
                if (clan.getFortId() == 0 && clan.getCastleId() == 0) {
                    return false;
                }
                if (clan.isLearnableSubPledgeSkill(skill, this._subType)) break;
                activeChar.sendPacket(SystemMessageId.SQUAD_SKILL_ALREADY_ACQUIRED);
                Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " is requesting skill Id: " + this._id + " level " + this._level + " without knowing it's previous level!");
                return false;
            }
            case TRANSFER: {
                if (skl != null) break;
                Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " is requesting transfer skill Id: " + this._id + " level " + this._level + " what is not included in transfer skills!");
                break;
            }
            case SUBCLASS: {
                if (activeChar.isSubClassActive()) {
                    activeChar.sendPacket(SystemMessageId.SKILL_NOT_FOR_SUBCLASS);
                    Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " is requesting skill Id: " + this._id + " level " + this._level + " while Sub-Class is active!");
                    return false;
                }
            }
            default: {
                if (prevSkillLevel == this._level) {
                    LOG.warn("Player {} is trying to learn a skill that already knows, Id: {} level: {}!", activeChar, this._id, this._level);
                    return false;
                }
                if (this._level == 1 || prevSkillLevel == this._level - 1) break;
                activeChar.sendPacket(SystemMessageId.PREVIOUS_LEVEL_SKILL_NOT_LEARNED);
                Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " is requesting skill Id: " + this._id + " level " + this._level + " without knowing it's previous level!");
                return false;
            }
        }
        return true;
    }

    public static void showSubUnitSkillList(L2PcInstance activeChar) {
        List<L2SkillLearn> skills = SkillTreesData.getInstance().getAvailableSubPledgeSkills(activeChar.getClan());
        if (skills.size() == 0) {
            activeChar.sendPacket(SystemMessageId.NO_MORE_SKILLS_TO_LEARN);
        } else {
            activeChar.sendPacket(new AcquireSkillList(AcquireSkillType.SUBPLEDGE, skills));
        }
    }

    private boolean checkPlayerSkill(L2PcInstance player, L2Npc trainer, L2SkillLearn s) {
        if (s != null && s.getSkillId() == this._id && s.getSkillLevel() == this._level) {
            if (s.getGetLevel() > player.getLevel()) {
                player.sendPacket(SystemMessageId.YOU_DONT_MEET_SKILL_LEVEL_REQUIREMENTS);
                Util.handleIllegalPlayerAction(player, "Player " + player.getName() + ", level " + player.getLevel() + " is requesting skill Id: " + this._id + " level " + this._level + " without having minimum required level, " + s.getGetLevel() + "!", IllegalActionPunishmentType.NONE);
                return false;
            }
            int levelUpSp = s.getCalculatedLevelUpSp(player.getClassId(), player.getLearningClass());
            if (levelUpSp > 0 && levelUpSp > player.getSp()) {
                player.sendPacket(SystemMessageId.NOT_ENOUGH_SP_TO_LEARN_SKILL);
                return false;
            }
            if (!Configuration.character().divineInspirationSpBookNeeded() && this._id == CommonSkill.DIVINE_INSPIRATION.getId()) {
                return true;
            }
            if (!s.getPreReqSkills().isEmpty()) {
                for (SkillHolder skill : s.getPreReqSkills()) {
                    if (player.getSkillLevel(skill.getSkillId()) == skill.getSkillLvl()) continue;
                    if (skill.getSkillId() == CommonSkill.ONYX_BEAST_TRANSFORMATION.getId()) {
                        player.sendPacket(SystemMessageId.YOU_MUST_LEARN_ONYX_BEAST_SKILL);
                    } else {
                        player.sendPacket(SystemMessageId.ITEM_OR_PREREQUISITES_MISSING_TO_LEARN_SKILL);
                    }
                    return false;
                }
            }
            if (!s.getRequiredItems().isEmpty()) {
                for (ItemHolder item : s.getRequiredItems()) {
                    long reqItemCount = player.getInventory().getInventoryItemCount(item.getId(), -1);
                    if (reqItemCount >= item.getCount()) continue;
                    player.sendPacket(SystemMessageId.ITEM_OR_PREREQUISITES_MISSING_TO_LEARN_SKILL);
                    return false;
                }
                for (ItemHolder itemIdCount : s.getRequiredItems()) {
                    if (player.destroyItemByItemId("SkillLearn", itemIdCount.getId(), itemIdCount.getCount(), trainer, true)) continue;
                    Util.handleIllegalPlayerAction(player, "Somehow player " + player.getName() + ", level " + player.getLevel() + " lose required item Id: " + itemIdCount.getId() + " to learn skill while learning skill Id: " + this._id + " level " + this._level + "!", IllegalActionPunishmentType.NONE);
                }
            }
            if (levelUpSp > 0) {
                player.setSp(player.getSp() - levelUpSp);
                StatusUpdate su = new StatusUpdate(player);
                su.addAttribute(13, player.getSp());
                player.sendPacket(su);
            }
            return true;
        }
        return false;
    }

    private void giveSkill(L2PcInstance player, L2Npc trainer, Skill skill) {
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.LEARNED_SKILL_S1);
        sm.addSkillName(skill);
        player.sendPacket(sm);
        player.sendPacket(new AcquireSkillDone());
        player.addSkill(skill, true);
        player.sendSkillList();
        player.updateShortCuts(this._id, this._level);
        if (this._id >= 1368 && this._id <= 1372) {
            player.sendPacket(new ExStorageMaxCount(player));
        }
        EventDispatcher.getInstance().notifyEventAsync(new PlayerSkillLearned(trainer, player, skill, this._skillType), trainer);
    }

    public static boolean canTransform(L2PcInstance player) {
        if (Configuration.character().transformationWithoutQuest()) {
            return true;
        }
        return player.hasQuestCompleted("Q00136_MoreThanMeetsTheEye");
    }

    @Override
    public String getType() {
        return _C__7C_REQUESTACQUIRESKILL;
    }
}

