/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.FriendPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestAnswerFriendInvite
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestAnswerFriendInvite.class);
    private static final String _C__78_REQUESTANSWERFRIENDINVITE = "[C] 78 RequestAnswerFriendInvite";
    private int _response;

    @Override
    protected void readImpl() {
        this._response = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = this.getActiveChar();
        if (player == null) {
            return;
        }
        L2PcInstance requestor = player.getActiveRequester();
        if (requestor == null) {
            return;
        }
        if (player.isFriend(requestor.getObjectId()) || requestor.isFriend(player.getObjectId())) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_ALREADY_IN_FRIENDS_LIST);
            sm.addCharName(player);
            requestor.sendPacket(sm);
            return;
        }
        if (player.getFriends().size() >= Configuration.character().getFriendListLimit()) {
            player.sendPacket(SystemMessageId.YOU_CAN_ONLY_ENTER_UP_128_NAMES_IN_YOUR_FRIENDS_LIST);
            return;
        }
        if (requestor.getFriends().size() >= Configuration.character().getFriendListLimit()) {
            requestor.sendPacket(SystemMessageId.THE_FRIENDS_LIST_OF_THE_PERSON_YOU_ARE_TRYING_TO_ADD_IS_FULL_SO_REGISTRATION_IS_NOT_POSSIBLE);
            return;
        }
        if (this._response == 1) {
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement statement = con.prepareStatement("INSERT INTO character_friends (charId, friendId) VALUES (?, ?), (?, ?)");){
                statement.setInt(1, requestor.getObjectId());
                statement.setInt(2, player.getObjectId());
                statement.setInt(3, player.getObjectId());
                statement.setInt(4, requestor.getObjectId());
                statement.execute();
                requestor.sendPacket(SystemMessageId.YOU_HAVE_SUCCEEDED_INVITING_FRIEND);
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.S1_ADDED_TO_FRIENDS);
                msg.addString(player.getName());
                requestor.sendPacket(msg);
                requestor.addFriend(player.getObjectId());
                msg = SystemMessage.getSystemMessage(SystemMessageId.S1_JOINED_AS_FRIEND);
                msg.addString(requestor.getName());
                player.sendPacket(msg);
                player.addFriend(requestor.getObjectId());
                player.sendPacket(new FriendPacket(true, requestor.getObjectId()));
                requestor.sendPacket(new FriendPacket(true, player.getObjectId()));
            }
            catch (Exception e) {
                LOG.warn("Could not add friend objectid: {}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            requestor.sendPacket(SystemMessageId.FAILED_TO_INVITE_A_FRIEND);
        }
        player.setActiveRequester(null);
        requestor.onTransactionResponse();
    }

    @Override
    public String getType() {
        return _C__78_REQUESTANSWERFRIENDINVITE;
    }
}

