/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.AdminData;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.PlayerAction;
import com.l2jserver.gameserver.handler.AdminCommandHandler;
import com.l2jserver.gameserver.handler.BypassHandler;
import com.l2jserver.gameserver.handler.CommunityBoardHandler;
import com.l2jserver.gameserver.handler.IAdminCommandHandler;
import com.l2jserver.gameserver.handler.IBypassHandler;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Hero;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcManorBypass;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerBypass;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ConfirmDlg;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.util.GMAudit;
import com.l2jserver.gameserver.util.Util;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestBypassToServer
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestBypassToServer.class);
    private static final String _C__23_REQUESTBYPASSTOSERVER = "[C] 23 RequestBypassToServer";
    private static final String[] _possibleNonHtmlCommands = new String[]{"_bbs", "bbs", "_mail", "_friend", "_match", "_diary", "_olympiad?command", "manor_menu_select"};
    private String _command;

    @Override
    protected void readImpl() {
        this._command = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar;
        block48: {
            activeChar = ((L2GameClient)this.getClient()).getActiveChar();
            if (activeChar == null) {
                return;
            }
            if (this._command.isEmpty()) {
                LOG.warn("Player {} sent empty bypass!", (Object)activeChar.getName());
                activeChar.logout();
                return;
            }
            boolean requiresBypassValidation = true;
            for (String possibleNonHtmlCommand : _possibleNonHtmlCommands) {
                if (!this._command.startsWith(possibleNonHtmlCommand)) continue;
                requiresBypassValidation = false;
                break;
            }
            int bypassOriginId = 0;
            if (requiresBypassValidation) {
                bypassOriginId = activeChar.validateHtmlAction(this._command);
                if (bypassOriginId == -1) {
                    LOG.warn("Player {} sent non cached bypass: '{}'", (Object)activeChar.getName(), (Object)this._command);
                    return;
                }
                if (bypassOriginId > 0 && !Util.isInsideRangeOfObjectId(activeChar, bypassOriginId, 150)) {
                    return;
                }
            }
            if (!((L2GameClient)this.getClient()).getFloodProtectors().getServerBypass().tryPerformAction(this._command)) {
                return;
            }
            try {
                if (this._command.startsWith("admin_")) {
                    String command = this._command.split(" ")[0];
                    IAdminCommandHandler ach = AdminCommandHandler.getInstance().getHandler(command);
                    if (ach == null) {
                        if (activeChar.isGM()) {
                            activeChar.sendMessage("The command " + command.substring(6) + " does not exist!");
                        }
                        LOG.warn("{} requested not registered admin command '{}'", (Object)activeChar, (Object)command);
                        return;
                    }
                    if (!AdminData.getInstance().hasAccess(command, activeChar.getAccessLevel())) {
                        activeChar.sendMessage("You don't have the access rights to use this command!");
                        LOG.warn("Character {} tried to use admin command {}, without proper access level!", (Object)activeChar.getName(), (Object)command);
                        return;
                    }
                    if (AdminData.getInstance().requireConfirm(command)) {
                        activeChar.setAdminConfirmCmd(this._command);
                        ConfirmDlg dlg = new ConfirmDlg(SystemMessageId.S1);
                        dlg.addString("Are you sure you want execute command " + this._command.substring(6) + " ?");
                        activeChar.addAction(PlayerAction.ADMIN_COMMAND);
                        activeChar.sendPacket(dlg);
                    } else {
                        if (Configuration.general().gmAudit()) {
                            GMAudit.auditGMAction(activeChar.getName() + " [" + activeChar.getObjectId() + "]", this._command, activeChar.getTarget() != null ? activeChar.getTarget().getName() : "no-target");
                        }
                        ach.useAdminCommand(this._command, activeChar);
                    }
                } else if (CommunityBoardHandler.getInstance().isCommunityBoardCommand(this._command)) {
                    CommunityBoardHandler.getInstance().handleParseCommand(this._command, activeChar);
                } else if (this._command.equals("come_here") && activeChar.isGM()) {
                    RequestBypassToServer.comeHere(activeChar);
                } else if (this._command.startsWith("npc_")) {
                    L2Object object;
                    endOfId = this._command.indexOf(95, 5);
                    String id = endOfId > 0 ? this._command.substring(4, endOfId) : this._command.substring(4);
                    if (Util.isDigit(id) && (object = L2World.getInstance().findObject(Integer.parseInt(id))) != null && object.isNpc() && endOfId > 0 && activeChar.isInsideRadius(object, 150, false, false)) {
                        ((L2Npc)object).onBypassFeedback(activeChar, this._command.substring(endOfId + 1));
                    }
                    activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                } else if (this._command.startsWith("item_")) {
                    endOfId = this._command.indexOf(95, 5);
                    String id = endOfId > 0 ? this._command.substring(5, endOfId) : this._command.substring(5);
                    try {
                        L2ItemInstance item = activeChar.getInventory().getItemByObjectId(Integer.parseInt(id));
                        if (item != null && endOfId > 0) {
                            item.onBypassFeedback(activeChar, this._command.substring(endOfId + 1));
                        }
                        activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                    }
                    catch (NumberFormatException nfe) {
                        LOG.warn("NFE for command [{}]", (Object)this._command, (Object)nfe);
                    }
                } else if (this._command.startsWith("_match")) {
                    String params = this._command.substring(this._command.indexOf("?") + 1);
                    StringTokenizer st = new StringTokenizer(params, "&");
                    int heroclass = Integer.parseInt(st.nextToken().split("=")[1]);
                    int heropage = Integer.parseInt(st.nextToken().split("=")[1]);
                    int heroid = Hero.getInstance().getHeroByClass(heroclass);
                    if (heroid > 0) {
                        Hero.getInstance().showHeroFights(activeChar, heroclass, heroid, heropage);
                    }
                } else if (this._command.startsWith("_diary")) {
                    String params = this._command.substring(this._command.indexOf("?") + 1);
                    StringTokenizer st = new StringTokenizer(params, "&");
                    int heroclass = Integer.parseInt(st.nextToken().split("=")[1]);
                    int heropage = Integer.parseInt(st.nextToken().split("=")[1]);
                    int heroid = Hero.getInstance().getHeroByClass(heroclass);
                    if (heroid > 0) {
                        Hero.getInstance().showHeroDiary(activeChar, heroclass, heroid, heropage);
                    }
                } else if (this._command.startsWith("_olympiad?command")) {
                    int arenaId = Integer.parseInt(this._command.split("=")[2]);
                    IBypassHandler handler = BypassHandler.getInstance().getHandler("arenachange");
                    if (handler != null) {
                        handler.useBypass("arenachange " + (arenaId - 1), activeChar, null);
                    }
                } else if (this._command.startsWith("manor_menu_select")) {
                    L2Npc lastNpc = activeChar.getLastFolkNPC();
                    if (Configuration.general().allowManor() && lastNpc != null && lastNpc.canInteract(activeChar)) {
                        String[] split = this._command.substring(this._command.indexOf("?") + 1).split("&");
                        int ask = Integer.parseInt(split[0].split("=")[1]);
                        int state = Integer.parseInt(split[1].split("=")[1]);
                        boolean time = split[2].split("=")[1].equals("1");
                        EventDispatcher.getInstance().notifyEventAsync(new NpcManorBypass(activeChar, lastNpc, ask, state, time), lastNpc);
                    }
                } else {
                    IBypassHandler handler = BypassHandler.getInstance().getHandler(this._command);
                    if (handler != null) {
                        if (bypassOriginId > 0) {
                            L2Object bypassOrigin = activeChar.getKnownList().getKnownObjects().get(bypassOriginId);
                            if (bypassOrigin != null && bypassOrigin.isInstanceTypes(InstanceType.L2Character)) {
                                handler.useBypass(this._command, activeChar, (L2Character)bypassOrigin);
                            } else {
                                handler.useBypass(this._command, activeChar, null);
                            }
                        } else {
                            handler.useBypass(this._command, activeChar, null);
                        }
                    } else {
                        LOG.warn("{} sent not handled RequestBypassToServer: [{}]", (Object)this.getClient(), (Object)this._command);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Exception processing bypass from player {}: {}", activeChar.getName(), this._command, e);
                if (!activeChar.isGM()) break block48;
                StringBuilder sb = new StringBuilder(200);
                sb.append("<html><body>");
                sb.append("Bypass error: ").append(e).append("<br1>");
                sb.append("Bypass command: ").append(this._command).append("<br1>");
                sb.append("StackTrace:<br1>");
                for (StackTraceElement ste : e.getStackTrace()) {
                    sb.append(ste.toString()).append("<br1>");
                }
                sb.append("</body></html>");
                NpcHtmlMessage msg = new NpcHtmlMessage(0, 1, sb.toString());
                msg.disableValidation();
                activeChar.sendPacket(msg);
            }
        }
        EventDispatcher.getInstance().notifyEventAsync(new PlayerBypass(activeChar, this._command), activeChar);
    }

    private static void comeHere(L2PcInstance activeChar) {
        L2Object obj = activeChar.getTarget();
        if (obj == null) {
            return;
        }
        if (obj instanceof L2Npc) {
            L2Npc npc = (L2Npc)obj;
            npc.setTarget(activeChar);
            npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, activeChar.getLocation());
        }
    }

    @Override
    public String getType() {
        return _C__23_REQUESTBYPASSTOSERVER;
    }
}

