/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SiegeDefenderList;

public final class RequestConfirmSiegeWaitingList
extends L2GameClientPacket {
    private static final String _C__AE_RequestConfirmSiegeWaitingList = "[C] AE RequestConfirmSiegeWaitingList";
    private int _approved;
    private int _castleId;
    private int _clanId;

    @Override
    protected void readImpl() {
        this._castleId = this.readD();
        this._clanId = this.readD();
        this._approved = this.readD();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (activeChar.getClan() == null) {
            return;
        }
        Castle castle = CastleManager.getInstance().getCastleById(this._castleId);
        if (castle == null) {
            return;
        }
        if (castle.getOwnerId() != activeChar.getClanId() || !activeChar.isClanLeader()) {
            return;
        }
        L2Clan clan = ClanTable.getInstance().getClan(this._clanId);
        if (clan == null) {
            return;
        }
        if (!castle.getSiege().getIsRegistrationOver()) {
            if (this._approved == 1) {
                if (!castle.getSiege().checkIsDefenderWaiting(clan)) return;
                castle.getSiege().approveSiegeDefenderClan(this._clanId);
            } else if (castle.getSiege().checkIsDefenderWaiting(clan) || castle.getSiege().checkIsDefender(clan)) {
                castle.getSiege().removeSiegeClan(this._clanId);
            }
        }
        activeChar.sendPacket(new SiegeDefenderList(castle));
    }

    @Override
    public String getType() {
        return _C__AE_RequestConfirmSiegeWaitingList;
    }
}

