/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestDestroyItem
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestDestroyItem.class);
    private static final String _C__60_REQUESTDESTROYITEM = "[C] 60 RequestDestroyItem";
    private int _objectId;
    private long _count;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._count = this.readQ();
    }

    @Override
    protected void runImpl() {
        L2ItemInstance removedItem;
        InventoryUpdate iu;
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (this._count <= 0L) {
            if (this._count < 0L) {
                Util.handleIllegalPlayerAction(activeChar, "[RequestDestroyItem] Character " + activeChar.getName() + " of account " + activeChar.getAccountName() + " tried to destroy item with oid " + this._objectId + " but has count < 0!");
            }
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("destroy")) {
            activeChar.sendMessage("You are destroying items too fast.");
            return;
        }
        long count = this._count;
        if (activeChar.isProcessingTransaction() || activeChar.getPrivateStoreType() != PrivateStoreType.NONE) {
            activeChar.sendPacket(SystemMessageId.CANNOT_TRADE_DISCARD_DROP_ITEM_WHILE_IN_SHOPMODE);
            return;
        }
        L2ItemInstance itemToRemove = activeChar.getInventory().getItemByObjectId(this._objectId);
        if (itemToRemove == null) {
            activeChar.sendPacket(SystemMessageId.CANNOT_DISCARD_THIS_ITEM);
            return;
        }
        if (activeChar.isCastingNow() && activeChar.getCurrentSkill() != null && activeChar.getCurrentSkill().getSkill().getItemConsumeId() == itemToRemove.getId()) {
            activeChar.sendPacket(SystemMessageId.CANNOT_DISCARD_THIS_ITEM);
            return;
        }
        if (activeChar.isCastingSimultaneouslyNow() && activeChar.getLastSimultaneousSkillCast() != null && activeChar.getLastSimultaneousSkillCast().getItemConsumeId() == itemToRemove.getId()) {
            activeChar.sendPacket(SystemMessageId.CANNOT_DISCARD_THIS_ITEM);
            return;
        }
        int itemId = itemToRemove.getId();
        if (!activeChar.canOverrideCond(PcCondOverride.DESTROY_ALL_ITEMS) && !itemToRemove.isDestroyable() || CursedWeaponsManager.getInstance().isCursed(itemId)) {
            if (itemToRemove.isHeroItem()) {
                activeChar.sendPacket(SystemMessageId.HERO_WEAPONS_CANT_DESTROYED);
            } else {
                activeChar.sendPacket(SystemMessageId.CANNOT_DISCARD_THIS_ITEM);
            }
            return;
        }
        if (!itemToRemove.isStackable() && count > 1L) {
            Util.handleIllegalPlayerAction(activeChar, "[RequestDestroyItem] Character " + activeChar.getName() + " of account " + activeChar.getAccountName() + " tried to destroy a non-stackable item with oid " + this._objectId + " but has count > 1!");
            return;
        }
        if (!activeChar.getInventory().canManipulateWithItemId(itemToRemove.getId())) {
            activeChar.sendMessage("You cannot use this item.");
            return;
        }
        if (this._count > itemToRemove.getCount()) {
            count = itemToRemove.getCount();
        }
        if (itemToRemove.getItem().isPetItem()) {
            if (activeChar.hasSummon() && activeChar.getSummon().getControlObjectId() == this._objectId) {
                activeChar.getSummon().unSummon(activeChar);
            }
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement statement = con.prepareStatement("DELETE FROM pets WHERE item_obj_id=?");){
                statement.setInt(1, this._objectId);
                statement.execute();
            }
            catch (Exception e) {
                LOG.warn("Could not delete pet objectid: ", e);
            }
        }
        if (itemToRemove.isTimeLimitedItem()) {
            itemToRemove.endOfLife();
        }
        if (itemToRemove.isEquipped()) {
            if (itemToRemove.getEnchantLevel() > 0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                sm.addInt(itemToRemove.getEnchantLevel());
                sm.addItemName(itemToRemove);
                activeChar.sendPacket(sm);
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISARMED);
                sm.addItemName(itemToRemove);
                activeChar.sendPacket(sm);
            }
            L2ItemInstance[] unequiped = activeChar.getInventory().unEquipItemInSlotAndRecord(itemToRemove.getLocationSlot());
            iu = new InventoryUpdate();
            for (L2ItemInstance itm : unequiped) {
                iu.addModifiedItem(itm);
            }
            activeChar.sendPacket(iu);
        }
        if ((removedItem = activeChar.getInventory().destroyItem("Destroy", itemToRemove, count, activeChar, null)) == null) {
            return;
        }
        if (!Configuration.general().forceInventoryUpdate()) {
            iu = new InventoryUpdate();
            if (removedItem.getCount() == 0L) {
                iu.addRemovedItem(removedItem);
            } else {
                iu.addModifiedItem(removedItem);
            }
            activeChar.sendPacket(iu);
        } else {
            this.sendPacket(new ItemList(activeChar, true));
        }
        StatusUpdate su = new StatusUpdate(activeChar);
        su.addAttribute(14, activeChar.getCurrentLoad());
        activeChar.sendPacket(su);
    }

    @Override
    public String getType() {
        return _C__60_REQUESTDESTROYITEM;
    }
}

