/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;

public class RequestDispel
extends L2GameClientPacket {
    private static final String _C_D0_4B_REQUESTDISPEL = "[C] D0:4B RequestDispel";
    private int _objectId;
    private int _skillId;
    private int _skillLevel;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._skillId = this.readD();
        this._skillLevel = this.readD();
    }

    @Override
    protected void runImpl() {
        if (this._skillId <= 0 || this._skillLevel <= 0) {
            return;
        }
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        Skill skill = SkillData.getInstance().getSkill(this._skillId, this._skillLevel);
        if (skill == null) {
            return;
        }
        if (skill.isIrreplaceableBuff() || skill.isStayAfterDeath() || skill.isDebuff()) {
            return;
        }
        if (skill.getAbnormalType() == AbnormalType.TRANSFORM) {
            return;
        }
        if (skill.isDance() && !Configuration.character().danceCancelBuff()) {
            return;
        }
        if (activeChar.getObjectId() == this._objectId) {
            activeChar.stopSkillEffects(true, this._skillId);
        } else if (activeChar.hasSummon() && activeChar.getSummon().getObjectId() == this._objectId) {
            activeChar.getSummon().stopSkillEffects(true, this._skillId);
        }
    }

    @Override
    public String getType() {
        return _C_D0_4B_REQUESTDISPEL;
    }
}

