/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExAskJoinMPCC;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestExAskJoinMPCC
extends L2GameClientPacket {
    private static final String _C__D0_06_REQUESTEXASKJOINMPCC = "[C] D0:06 RequestExAskJoinMPCC";
    private String _name;

    @Override
    protected void readImpl() {
        this._name = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2PcInstance player = L2World.getInstance().getPlayer(this._name);
        if (player == null) {
            return;
        }
        if (activeChar.isInParty() && player.isInParty() && activeChar.getParty().equals(player.getParty())) {
            return;
        }
        if (activeChar.isInParty()) {
            L2Party activeParty = activeChar.getParty();
            if (activeParty.getLeader().equals(activeChar)) {
                if (activeParty.isInCommandChannel() && activeParty.getCommandChannel().getLeader().equals(activeChar)) {
                    if (player.isInParty()) {
                        if (player.getParty().isInCommandChannel()) {
                            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_ALREADY_MEMBER_OF_COMMAND_CHANNEL);
                            sm.addString(player.getName());
                            activeChar.sendPacket(sm);
                        } else {
                            this.askJoinMPCC(activeChar, player);
                        }
                    } else {
                        activeChar.sendMessage(player.getName() + " doesn't have party and cannot be invited to Command Channel.");
                    }
                } else if (activeParty.isInCommandChannel() && !activeParty.getCommandChannel().getLeader().equals(activeChar)) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CANNOT_INVITE_TO_COMMAND_CHANNEL);
                    activeChar.sendPacket(sm);
                } else if (player.isInParty()) {
                    if (player.getParty().isInCommandChannel()) {
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_ALREADY_MEMBER_OF_COMMAND_CHANNEL);
                        sm.addString(player.getName());
                        activeChar.sendPacket(sm);
                    } else {
                        this.askJoinMPCC(activeChar, player);
                    }
                } else {
                    activeChar.sendMessage(player.getName() + " doesn't have party and cannot be invited to Command Channel.");
                }
            } else {
                activeChar.sendPacket(SystemMessageId.CANNOT_INVITE_TO_COMMAND_CHANNEL);
            }
        }
    }

    private void askJoinMPCC(L2PcInstance requestor, L2PcInstance target) {
        boolean hasRight = false;
        if (requestor.isClanLeader() && requestor.getClan().getLevel() >= 5) {
            hasRight = true;
        } else if (requestor.getInventory().getItemByItemId(8871) != null) {
            hasRight = true;
        } else if (requestor.getPledgeClass() >= 5 && requestor.getKnownSkill(391) != null) {
            hasRight = true;
        }
        if (!hasRight) {
            requestor.sendPacket(SystemMessageId.COMMAND_CHANNEL_ONLY_BY_LEVEL_5_CLAN_LEADER_PARTY_LEADER);
            return;
        }
        L2PcInstance targetLeader = target.getParty().getLeader();
        if (!targetLeader.isProcessingRequest()) {
            requestor.onTransactionRequest(targetLeader);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.COMMAND_CHANNEL_CONFIRM_FROM_C1);
            sm.addString(requestor.getName());
            targetLeader.sendPacket(sm);
            targetLeader.sendPacket(new ExAskJoinMPCC(requestor.getName()));
            requestor.sendMessage("You invited " + targetLeader.getName() + " to your Command Channel.");
        } else {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_BUSY_TRY_LATER);
            sm.addString(targetLeader.getName());
            requestor.sendPacket(sm);
        }
    }

    @Override
    public String getType() {
        return _C__D0_06_REQUESTEXASKJOINMPCC;
    }
}

