/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.instancemanager.RaidBossPointsManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExGetBossRecord;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestGetBossRecord
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestGetBossRecord.class);
    private static final String _C__D0_40_REQUESTGETBOSSRECORD = "[C] D0:40 RequestGetBossRecord";
    private int _bossId;

    @Override
    protected void readImpl() {
        this._bossId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (this._bossId != 0) {
            LOG.info("C5: RequestGetBossRecord: d: {} ActiveChar: {}", (Object)this._bossId, (Object)activeChar);
        }
        int points = RaidBossPointsManager.getInstance().getPointsByOwnerId(activeChar.getObjectId());
        int ranking = RaidBossPointsManager.getInstance().calculateRanking(activeChar.getObjectId());
        Map<Integer, Integer> list = RaidBossPointsManager.getInstance().getList(activeChar);
        activeChar.sendPacket(new ExGetBossRecord(ranking, points, list));
    }

    @Override
    public String getType() {
        return _C__D0_40_REQUESTGETBOSSRECORD;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }
}

