/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.targets.TargetType;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestMagicSkillUse
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestMagicSkillUse.class);
    private static final String _C__39_REQUESTMAGICSKILLUSE = "[C] 39 RequestMagicSkillUse";
    private int _magicId;
    private boolean _ctrlPressed;
    private boolean _shiftPressed;

    @Override
    protected void readImpl() {
        this._magicId = this.readD();
        this._ctrlPressed = this.readD() != 0;
        this._shiftPressed = this.readC() != 0;
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = this.getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (activeChar.isDead()) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.isFakeDeath()) {
            activeChar.sendPacket(SystemMessageId.CANT_MOVE_SITTING);
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        Skill skill = activeChar.getKnownSkill(this._magicId);
        if (skill == null && (skill = activeChar.getCustomSkill(this._magicId)) == null && (skill = activeChar.getTransformSkill(this._magicId)) == null) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            LOG.warn("Skill Id {} not found in player : {}", (Object)this._magicId, (Object)activeChar);
            return;
        }
        if (activeChar.isPlayable() && activeChar.isInAirShip()) {
            activeChar.sendPacket(SystemMessageId.ACTION_PROHIBITED_WHILE_MOUNTED_OR_ON_AN_AIRSHIP);
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if ((activeChar.isTransformed() || activeChar.isInStance()) && !activeChar.hasTransformSkill(skill.getId())) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!Configuration.character().karmaPlayerCanTeleport() && activeChar.getKarma() > 0 && skill.hasEffectType(L2EffectType.TELEPORT, new L2EffectType[0])) {
            return;
        }
        if (skill.isToggle() && activeChar.isMounted()) {
            return;
        }
        if (!(!skill.isContinuous() || skill.isDebuff() || skill.getTargetType() != TargetType.SELF || activeChar.isInAirShip() && activeChar.isInBoat())) {
            activeChar.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, activeChar.getLocation());
        }
        activeChar.useMagic(skill, this._ctrlPressed, this._shiftPressed);
    }

    @Override
    public String getType() {
        return _C__39_REQUESTMAGICSKILLUSE;
    }
}

