/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.MacroType;
import com.l2jserver.gameserver.model.Macro;
import com.l2jserver.gameserver.model.MacroCmd;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestMakeMacro
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestMakeMacro.class);
    private static final String _C__CD_REQUESTMAKEMACRO = "[C] CD RequestMakeMacro";
    private Macro _macro;
    private int _commandsLength = 0;
    private static final int MAX_MACRO_LENGTH = 12;

    @Override
    protected void readImpl() {
        int _id = this.readD();
        String _name = this.readS();
        String _desc = this.readS();
        String _acronym = this.readS();
        int _icon = this.readC();
        int _count = this.readC();
        if (_count > 12) {
            _count = 12;
        }
        if (Configuration.general().debug()) {
            LOG.info("Make macro id: {}\tname: {}\tdesc: {}\tacronym: {}\ticon: {}\tcount: {}", _id, _name, _desc, _acronym, _icon, _count);
        }
        ArrayList<MacroCmd> commands = new ArrayList<MacroCmd>(_count);
        for (int i = 0; i < _count; ++i) {
            int entry = this.readC();
            int type = this.readC();
            int d1 = this.readD();
            int d2 = this.readC();
            String command = this.readS();
            this._commandsLength += command.length();
            commands.add(new MacroCmd(entry, MacroType.values()[type < 1 || type > 6 ? 0 : type], d1, d2, command));
        }
        this._macro = new Macro(_id, _icon, _name, _desc, _acronym, commands);
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (this._commandsLength > 255) {
            player.sendPacket(SystemMessageId.INVALID_MACRO);
            return;
        }
        if (player.getMacros().getAllMacros().size() > 48) {
            player.sendPacket(SystemMessageId.YOU_MAY_CREATE_UP_TO_48_MACROS);
            return;
        }
        if (this._macro.getName().isEmpty()) {
            player.sendPacket(SystemMessageId.ENTER_THE_MACRO_NAME);
            return;
        }
        if (this._macro.getDescr().length() > 32) {
            player.sendPacket(SystemMessageId.MACRO_DESCRIPTION_MAX_32_CHARS);
            return;
        }
        player.registerMacro(this._macro);
    }

    @Override
    public String getType() {
        return _C__CD_REQUESTMAKEMACRO;
    }
}

