/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListDelete;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestOustPledgeMember
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestOustPledgeMember.class);
    private static final String _C__29_REQUESTOUSTPLEDGEMEMBER = "[C] 29 RequestOustPledgeMember";
    private String _target;

    @Override
    protected void readImpl() {
        this._target = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (activeChar.getClan() == null) {
            activeChar.sendPacket(SystemMessageId.YOU_ARE_NOT_A_CLAN_MEMBER);
            return;
        }
        if (!activeChar.hasClanPrivilege(ClanPrivilege.CL_DISMISS)) {
            activeChar.sendPacket(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT);
            return;
        }
        if (activeChar.getName().equalsIgnoreCase(this._target)) {
            activeChar.sendPacket(SystemMessageId.YOU_CANNOT_DISMISS_YOURSELF);
            return;
        }
        L2Clan clan = activeChar.getClan();
        L2ClanMember member = clan.getClanMember(this._target);
        if (member == null) {
            LOG.warn("Target ({}) is not member of the clan", (Object)this._target);
            return;
        }
        if (member.isOnline() && member.getPlayerInstance().isInCombat()) {
            activeChar.sendPacket(SystemMessageId.CLAN_MEMBER_CANNOT_BE_DISMISSED_DURING_COMBAT);
            return;
        }
        clan.removeClanMember(member.getObjectId(), System.currentTimeMillis() + Configuration.character().getDaysBeforeJoinAClan());
        clan.setCharPenaltyExpiryTime(System.currentTimeMillis() + Configuration.character().getDaysBeforeJoinAClan());
        clan.updateClanInDB();
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_MEMBER_S1_EXPELLED);
        sm.addString(member.getName());
        clan.broadcastToOnlineMembers(sm);
        activeChar.sendPacket(SystemMessageId.YOU_HAVE_SUCCEEDED_IN_EXPELLING_CLAN_MEMBER);
        activeChar.sendPacket(SystemMessageId.YOU_MUST_WAIT_BEFORE_ACCEPTING_A_NEW_MEMBER);
        clan.broadcastToOnlineMembers(new PledgeShowMemberListDelete(this._target));
        if (member.isOnline()) {
            L2PcInstance player = member.getPlayerInstance();
            player.sendPacket(SystemMessageId.CLAN_MEMBERSHIP_TERMINATED);
        }
    }

    @Override
    public String getType() {
        return _C__29_REQUESTOUSTPLEDGEMEMBER;
    }
}

