/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.data.sql.impl.CrestTable;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Crest;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;

public final class RequestSetPledgeCrest
extends L2GameClientPacket {
    private static final String _C__09_REQUESTSETPLEDGECREST = "[C] 09 RequestSetPledgeCrest";
    private int _length;
    private byte[] _data = null;

    @Override
    protected void readImpl() {
        this._length = this.readD();
        if (this._length > 256) {
            return;
        }
        this._data = new byte[this._length];
        this.readB(this._data);
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (this._length < 0) {
            activeChar.sendPacket(SystemMessageId.WRONG_SIZE_UPLOADED_CREST);
            return;
        }
        if (this._length > 256) {
            activeChar.sendPacket(SystemMessageId.THE_SIZE_OF_THE_IMAGE_FILE_IS_INAPPROPRIATE);
            return;
        }
        L2Clan clan = activeChar.getClan();
        if (clan == null) {
            return;
        }
        if (clan.getDissolvingExpiryTime() > System.currentTimeMillis()) {
            activeChar.sendPacket(SystemMessageId.CANNOT_SET_CREST_WHILE_DISSOLUTION_IN_PROGRESS);
            return;
        }
        if (!activeChar.hasClanPrivilege(ClanPrivilege.CL_REGISTER_CREST)) {
            activeChar.sendPacket(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT);
            return;
        }
        if (this._length == 0) {
            if (clan.getCrestId() != 0) {
                clan.changeClanCrest(0);
                activeChar.sendPacket(SystemMessageId.CLAN_CREST_HAS_BEEN_DELETED);
            }
        } else {
            if (clan.getLevel() < 3) {
                activeChar.sendPacket(SystemMessageId.CLAN_LVL_3_NEEDED_TO_SET_CREST);
                return;
            }
            L2Crest crest = CrestTable.getInstance().createCrest(this._data, L2Crest.CrestType.PLEDGE);
            if (crest != null) {
                clan.changeClanCrest(crest.getId());
                activeChar.sendPacket(SystemMessageId.CLAN_CREST_WAS_SUCCESSFULLY_REGISTRED);
            }
        }
    }

    @Override
    public String getType() {
        return _C__09_REQUESTSETPLEDGECREST;
    }
}

