/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.NextAction;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.enums.Race;
import com.l2jserver.gameserver.handler.IItemHandler;
import com.l2jserver.gameserver.handler.ItemHandler;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.items.L2EtcItem;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.ArmorType;
import com.l2jserver.gameserver.model.items.type.ItemType2;
import com.l2jserver.gameserver.model.items.type.WeaponType;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExUseSharedGroupItem;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UseItem
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(UseItem.class);
    private static final String _C__19_USEITEM = "[C] 19 UseItem";
    private static final int FORMAL_WEAR_ID = 6408;
    private int _objectId;
    private boolean _ctrlPressed;
    private int _itemId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._ctrlPressed = this.readD() != 0;
    }

    @Override
    protected void runImpl() {
        SkillHolder[] skills;
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (Configuration.general().debug()) {
            LOG.debug("{} uses item with object Id {}.", (Object)activeChar, (Object)this._objectId);
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getUseItem().tryPerformAction("use item")) {
            return;
        }
        if (activeChar.getActiveTradeList() != null) {
            activeChar.cancelActiveTrade();
        }
        if (activeChar.getPrivateStoreType() != PrivateStoreType.NONE) {
            activeChar.sendPacket(SystemMessageId.CANNOT_TRADE_DISCARD_DROP_ITEM_WHILE_IN_SHOPMODE);
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2ItemInstance item = activeChar.getInventory().getItemByObjectId(this._objectId);
        if (item == null) {
            return;
        }
        if (item.getItem().getType2() == ItemType2.QUEST) {
            activeChar.sendPacket(SystemMessageId.CANNOT_USE_QUEST_ITEMS);
            return;
        }
        if (activeChar.isStunned() || activeChar.isSleeping() || activeChar.isAfraid() || activeChar.isAlikeDead()) {
            return;
        }
        this._itemId = item.getId();
        if (activeChar.isDead() || !activeChar.getInventory().canManipulateWithItemId(this._itemId)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addItemName(item);
            activeChar.sendPacket(sm);
            return;
        }
        if (!item.isEquipped() && !item.getItem().checkCondition(activeChar, activeChar, true)) {
            return;
        }
        if (activeChar.isFishing() && (this._itemId < 6535 || this._itemId > 6540)) {
            activeChar.sendPacket(SystemMessageId.CANNOT_DO_WHILE_FISHING_3);
            return;
        }
        if (!Configuration.character().karmaPlayerCanTeleport() && activeChar.getKarma() > 0 && (skills = item.getItem().getSkills()) != null) {
            for (SkillHolder sHolder : skills) {
                Skill skill = sHolder.getSkill();
                if (skill == null || !skill.hasEffectType(L2EffectType.TELEPORT, new L2EffectType[0])) continue;
                return;
            }
        }
        int reuseDelay = item.getReuseDelay();
        int sharedReuseGroup = item.getSharedReuseGroup();
        if (reuseDelay > 0) {
            long reuse = activeChar.getItemRemainingReuseTime(item.getObjectId());
            if (reuse > 0L) {
                this.reuseData(activeChar, item, reuse);
                this.sendSharedGroupUpdate(activeChar, sharedReuseGroup, reuse, reuseDelay);
                return;
            }
            long reuseOnGroup = activeChar.getReuseDelayOnGroup(sharedReuseGroup);
            if (reuseOnGroup > 0L) {
                this.reuseData(activeChar, item, reuseOnGroup);
                this.sendSharedGroupUpdate(activeChar, sharedReuseGroup, reuseOnGroup, reuseDelay);
                return;
            }
        }
        if (item.isEquipable()) {
            if (activeChar.isCursedWeaponEquipped() && this._itemId == 6408) {
                return;
            }
            if (FortSiegeManager.getInstance().isCombat(this._itemId)) {
                return;
            }
            if (activeChar.isCombatFlagEquipped()) {
                return;
            }
            switch (item.getItem().getBodyPart()) {
                case 128: 
                case 256: 
                case 16384: {
                    if (activeChar.getActiveWeaponItem() != null && activeChar.getActiveWeaponItem().getId() == 9819) {
                        activeChar.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                        return;
                    }
                    if (activeChar.isMounted()) {
                        activeChar.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                        return;
                    }
                    if (activeChar.isDisarmed()) {
                        activeChar.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                        return;
                    }
                    if (activeChar.isCursedWeaponEquipped()) {
                        return;
                    }
                    if (item.isEquipped() || !item.isWeapon() || activeChar.canOverrideCond(PcCondOverride.ITEM_CONDITIONS)) break;
                    L2Weapon wpn = (L2Weapon)item.getItem();
                    switch (activeChar.getRace()) {
                        case KAMAEL: {
                            if (wpn.getItemType() != WeaponType.NONE) break;
                            activeChar.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                            return;
                        }
                        case HUMAN: 
                        case DWARF: 
                        case ELF: 
                        case DARK_ELF: 
                        case ORC: {
                            switch (wpn.getItemType()) {
                                case RAPIER: 
                                case CROSSBOW: 
                                case ANCIENTSWORD: {
                                    activeChar.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                                    return;
                                }
                            }
                        }
                    }
                    break;
                }
                case 64: 
                case 512: 
                case 1024: 
                case 2048: 
                case 4096: 
                case 8192: 
                case 32768: {
                    if (activeChar.getRace() != Race.KAMAEL || item.getItem().getItemType() != ArmorType.HEAVY && item.getItem().getItemType() != ArmorType.MAGIC) break;
                    activeChar.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                    return;
                }
                case 0x400000: {
                    if (item.isEquipped() || activeChar.getInventory().getTalismanSlots() != 0) break;
                    activeChar.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                    return;
                }
            }
            if (activeChar.isCastingNow() || activeChar.isCastingSimultaneouslyNow()) {
                NextAction nextAction = new NextAction(CtrlEvent.EVT_FINISH_CASTING, CtrlIntention.AI_INTENTION_CAST, () -> activeChar.useEquippableItem(this._objectId, true));
                activeChar.getAI().setNextAction(nextAction);
            } else if (activeChar.isAttackingNow()) {
                ThreadPoolManager.getInstance().scheduleGeneral(() -> activeChar.useEquippableItem(this._objectId, false), TimeUnit.MILLISECONDS.convert(activeChar.getAttackEndTime() - System.nanoTime(), TimeUnit.NANOSECONDS));
            } else {
                activeChar.useEquippableItem(this._objectId, true);
            }
        } else {
            L2Weapon weaponItem = activeChar.getActiveWeaponItem();
            if (weaponItem != null && weaponItem.getItemType() == WeaponType.FISHINGROD && (this._itemId >= 6519 && this._itemId <= 6527 || this._itemId >= 7610 && this._itemId <= 7613 || this._itemId >= 7807 && this._itemId <= 7809 || this._itemId >= 8484 && this._itemId <= 8486 || this._itemId >= 8505 && this._itemId <= 8513)) {
                activeChar.getInventory().setPaperdollItem(7, item);
                activeChar.broadcastUserInfo();
                this.sendPacket(new ItemList(activeChar, false));
                return;
            }
            L2EtcItem etcItem = item.getEtcItem();
            IItemHandler handler = ItemHandler.getInstance().getHandler(etcItem);
            if (handler == null) {
                if (etcItem != null && etcItem.getHandlerName() != null) {
                    LOG.warn("Unmanaged Item handler: {} for Item Id: {}!", (Object)etcItem.getHandlerName(), (Object)this._itemId);
                } else if (Configuration.general().debug()) {
                    LOG.warn("No Item handler registered for Item Id: {}!", (Object)this._itemId);
                }
                return;
            }
            if (handler.useItem(activeChar, item, this._ctrlPressed) && reuseDelay > 0) {
                activeChar.addTimeStampItem(item, reuseDelay);
                this.sendSharedGroupUpdate(activeChar, sharedReuseGroup, reuseDelay, reuseDelay);
            }
        }
    }

    private void reuseData(L2PcInstance activeChar, L2ItemInstance item, long remainingTime) {
        SystemMessage sm;
        int hours = (int)(remainingTime / 3600000L);
        int minutes = (int)(remainingTime % 3600000L) / 60000;
        int seconds = (int)(remainingTime / 1000L % 60L);
        if (hours > 0) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.S2_HOURS_S3_MINUTES_S4_SECONDS_REMAINING_FOR_REUSE_S1);
            sm.addItemName(item);
            sm.addInt(hours);
            sm.addInt(minutes);
        } else if (minutes > 0) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.S2_MINUTES_S3_SECONDS_REMAINING_FOR_REUSE_S1);
            sm.addItemName(item);
            sm.addInt(minutes);
        } else {
            sm = SystemMessage.getSystemMessage(SystemMessageId.S2_SECONDS_REMAINING_FOR_REUSE_S1);
            sm.addItemName(item);
        }
        sm.addInt(seconds);
        activeChar.sendPacket(sm);
    }

    private void sendSharedGroupUpdate(L2PcInstance activeChar, int group, long remaining, int reuse) {
        if (group > 0) {
            activeChar.sendPacket(new ExUseSharedGroupItem(this._itemId, group, remaining, reuse));
        }
    }

    @Override
    public String getType() {
        return _C__19_USEITEM;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return !Configuration.character().getPlayerSpawnProtectionAllowedItems().contains(this._itemId);
    }
}

