/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.enums.HtmlActionScope;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHtmlPacket
extends L2GameServerPacket {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHtmlPacket.class);
    public static final char VAR_PARAM_START_CHAR = '$';
    private final int _npcObjId;
    private String _html = null;
    private boolean _disabledValidation = false;

    protected AbstractHtmlPacket() {
        this._npcObjId = 0;
    }

    protected AbstractHtmlPacket(int npcObjId) {
        if (npcObjId < 0) {
            throw new IllegalArgumentException();
        }
        this._npcObjId = npcObjId;
    }

    protected AbstractHtmlPacket(String html) {
        this._npcObjId = 0;
        this.setHtml(html);
    }

    protected AbstractHtmlPacket(int npcObjId, String html) {
        if (npcObjId < 0) {
            throw new IllegalArgumentException();
        }
        this._npcObjId = npcObjId;
        this.setHtml(html);
    }

    public final void disableValidation() {
        this._disabledValidation = true;
    }

    public final void setHtml(String html) {
        if (((String)html).length() > 17200) {
            LOG.warn("Html is too long! this will crash the client!", new Throwable());
            this._html = ((String)html).substring(0, 17200);
        }
        if (!((String)html).contains("<html")) {
            html = "<html><body>" + (String)html + "</body></html>";
        }
        this._html = html;
    }

    public final boolean setFile(String prefix, String path) {
        String content = HtmCache.getInstance().getHtm(prefix, path);
        if (content == null) {
            this.setHtml("<html><body>My Text is missing:<br>" + path + "</body></html>");
            LOG.warn("Missing html page {}", (Object)path);
            return false;
        }
        this.setHtml(content);
        return true;
    }

    public final void replace(String pattern, String value) {
        this._html = this._html.replaceAll(pattern, value.replace("$", "\\$"));
    }

    public final void replace(String pattern, boolean val) {
        this.replace(pattern, String.valueOf(val));
    }

    public final void replace(String pattern, int val) {
        this.replace(pattern, String.valueOf(val));
    }

    public final void replace(String pattern, long val) {
        this.replace(pattern, String.valueOf(val));
    }

    public final void replace(String pattern, double val) {
        this.replace(pattern, String.valueOf(val));
    }

    @Override
    public final void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        player.clearHtmlActions(this.getScope());
        if (this._disabledValidation) {
            return;
        }
        Util.buildHtmlActionCache(player, this.getScope(), this._npcObjId, this._html);
    }

    public final int getNpcObjId() {
        return this._npcObjId;
    }

    public final String getHtml() {
        return this._html;
    }

    public abstract HtmlActionScope getScope();
}

