/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.json.ExperienceData;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.model.CharSelectInfoPackage;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharSelectionInfo
extends L2GameServerPacket {
    private static final Logger LOG = LoggerFactory.getLogger(CharSelectionInfo.class);
    private final String _loginName;
    private final int _sessionId;
    private int _activeId;
    private final List<CharSelectInfoPackage> _characterPackages;

    public CharSelectionInfo(String loginName, int sessionId) {
        this._sessionId = sessionId;
        this._loginName = loginName;
        this._characterPackages = CharSelectionInfo.loadCharacterSelectInfo(this._loginName);
        this._activeId = -1;
    }

    public CharSelectionInfo(String loginName, int sessionId, int activeId) {
        this._sessionId = sessionId;
        this._loginName = loginName;
        this._characterPackages = CharSelectionInfo.loadCharacterSelectInfo(this._loginName);
        this._activeId = activeId;
    }

    public List<CharSelectInfoPackage> getCharInfo() {
        return this._characterPackages;
    }

    @Override
    protected final void writeImpl() {
        CharSelectInfoPackage charInfoPackage;
        int i;
        this.writeC(9);
        int size = this._characterPackages.size();
        this.writeD(size);
        this.writeD(Configuration.character().getCharMaxNumber());
        this.writeC(0);
        long lastAccess = 0L;
        if (this._activeId == -1) {
            for (i = 0; i < size; ++i) {
                charInfoPackage = this._characterPackages.get(i);
                if (lastAccess >= charInfoPackage.getLastAccess()) continue;
                lastAccess = charInfoPackage.getLastAccess();
                this._activeId = i;
            }
        }
        for (i = 0; i < size; ++i) {
            charInfoPackage = this._characterPackages.get(i);
            this.writeS(charInfoPackage.getName());
            this.writeD(charInfoPackage.getObjectId());
            this.writeS(this._loginName);
            this.writeD(this._sessionId);
            this.writeD(charInfoPackage.getClanId());
            this.writeD(0);
            this.writeD(charInfoPackage.getSex());
            this.writeD(charInfoPackage.getRace());
            this.writeD(charInfoPackage.getBaseClassId());
            this.writeD(1);
            this.writeD(charInfoPackage.getX());
            this.writeD(charInfoPackage.getY());
            this.writeD(charInfoPackage.getZ());
            this.writeF(charInfoPackage.getCurrentHp());
            this.writeF(charInfoPackage.getCurrentMp());
            this.writeD(charInfoPackage.getSp());
            this.writeQ(charInfoPackage.getExp());
            this.writeF(ExperienceData.getInstance().getPercentFromCurrentLevel(charInfoPackage.getExp(), charInfoPackage.getLevel()));
            this.writeD(charInfoPackage.getLevel());
            this.writeD(charInfoPackage.getKarma());
            this.writeD(charInfoPackage.getPkKills());
            this.writeD(charInfoPackage.getPvPKills());
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            for (int slot : this.getPaperdollOrder()) {
                this.writeD(charInfoPackage.getPaperdollItemId(slot));
            }
            this.writeD(charInfoPackage.getHairStyle());
            this.writeD(charInfoPackage.getHairColor());
            this.writeD(charInfoPackage.getFace());
            this.writeF(charInfoPackage.getMaxHp());
            this.writeF(charInfoPackage.getMaxMp());
            this.writeD(charInfoPackage.getDeleteTimer() > 0L ? (int)((charInfoPackage.getDeleteTimer() - System.currentTimeMillis()) / 1000L) : 0);
            this.writeD(charInfoPackage.getClassId());
            this.writeD(i == this._activeId ? 1 : 0);
            this.writeC(Math.min(charInfoPackage.getEnchantEffect(), 127));
            this.writeD(charInfoPackage.getAugmentationId());
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeF(0.0);
            this.writeF(0.0);
            this.writeD(charInfoPackage.getVitalityPoints());
        }
    }

    private static List<CharSelectInfoPackage> loadCharacterSelectInfo(String loginName) {
        ArrayList<CharSelectInfoPackage> characterList = new ArrayList<CharSelectInfoPackage>();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement statement = con.prepareStatement("SELECT * FROM characters WHERE account_name=? ORDER BY createDate");){
            statement.setString(1, loginName);
            try (ResultSet charList = statement.executeQuery();){
                while (charList.next()) {
                    CharSelectInfoPackage charInfopackage = CharSelectionInfo.restoreChar(charList);
                    if (charInfopackage == null) continue;
                    characterList.add(charInfopackage);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Could not restore char info: {}", (Object)e.getMessage(), (Object)e);
        }
        return characterList;
    }

    private static void loadCharacterSubclassInfo(CharSelectInfoPackage charInfopackage, int ObjectId, int activeClassId) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement statement = con.prepareStatement("SELECT exp, sp, level FROM character_subclasses WHERE charId=? && class_id=? ORDER BY charId");){
            statement.setInt(1, ObjectId);
            statement.setInt(2, activeClassId);
            try (ResultSet charList = statement.executeQuery();){
                if (charList.next()) {
                    charInfopackage.setExp(charList.getLong("exp"));
                    charInfopackage.setSp(charList.getInt("sp"));
                    charInfopackage.setLevel(charList.getInt("level"));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Could not restore char subclass info: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static CharSelectInfoPackage restoreChar(ResultSet chardata) throws Exception {
        int objectId = chardata.getInt("charId");
        String name = chardata.getString("char_name");
        long deletetime = chardata.getLong("deletetime");
        if (deletetime > 0L && System.currentTimeMillis() > deletetime) {
            L2Clan clan = ClanTable.getInstance().getClan(chardata.getInt("clanid"));
            if (clan != null) {
                clan.removeClanMember(objectId, 0L);
            }
            L2GameClient.deleteCharByObjId(objectId);
            return null;
        }
        CharSelectInfoPackage charInfopackage = new CharSelectInfoPackage(objectId, name);
        charInfopackage.setAccessLevel(chardata.getInt("accesslevel"));
        charInfopackage.setLevel(chardata.getInt("level"));
        charInfopackage.setMaxCp(chardata.getInt("maxCp"));
        charInfopackage.setCurrentCp(chardata.getInt("curCp"));
        charInfopackage.setMaxHp(chardata.getInt("maxhp"));
        charInfopackage.setCurrentHp(chardata.getDouble("curhp"));
        charInfopackage.setMaxMp(chardata.getInt("maxmp"));
        charInfopackage.setCurrentMp(chardata.getDouble("curmp"));
        charInfopackage.setKarma(chardata.getInt("karma"));
        charInfopackage.setPkKills(chardata.getInt("pkkills"));
        charInfopackage.setPvPKills(chardata.getInt("pvpkills"));
        charInfopackage.setFace(chardata.getInt("face"));
        charInfopackage.setHairStyle(chardata.getInt("hairstyle"));
        charInfopackage.setHairColor(chardata.getInt("haircolor"));
        charInfopackage.setSex(chardata.getInt("sex"));
        charInfopackage.setExp(chardata.getLong("exp"));
        charInfopackage.setSp(chardata.getInt("sp"));
        charInfopackage.setVitalityPoints(chardata.getInt("vitality_points"));
        charInfopackage.setClanId(chardata.getInt("clanid"));
        charInfopackage.setRace(chardata.getInt("race"));
        int baseClassId = chardata.getInt("base_class");
        int activeClassId = chardata.getInt("classid");
        charInfopackage.setX(chardata.getInt("x"));
        charInfopackage.setY(chardata.getInt("y"));
        charInfopackage.setZ(chardata.getInt("z"));
        if (Configuration.customs().multiLangEnable()) {
            String lang = chardata.getString("language");
            if (!Configuration.customs().getMultiLangAllowed().contains(lang)) {
                lang = Configuration.customs().getMultiLangDefault();
            }
            charInfopackage.setHtmlPrefix("data/lang/" + lang + "/");
        }
        if (baseClassId != activeClassId) {
            CharSelectionInfo.loadCharacterSubclassInfo(charInfopackage, objectId, activeClassId);
        }
        charInfopackage.setClassId(activeClassId);
        int weaponObjId = charInfopackage.getPaperdollObjectId(5);
        if (weaponObjId < 1) {
            weaponObjId = charInfopackage.getPaperdollObjectId(5);
        }
        if (weaponObjId > 0) {
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement statement = con.prepareStatement("SELECT augAttributes FROM item_attributes WHERE itemId=?");){
                statement.setInt(1, weaponObjId);
                try (ResultSet result = statement.executeQuery();){
                    if (result.next()) {
                        int augment = result.getInt("augAttributes");
                        charInfopackage.setAugmentationId(augment == -1 ? 0 : augment);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Could not restore augmentation info: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (baseClassId == 0 && activeClassId > 0) {
            charInfopackage.setBaseClassId(activeClassId);
        } else {
            charInfopackage.setBaseClassId(baseClassId);
        }
        charInfopackage.setDeleteTimer(deletetime);
        charInfopackage.setLastAccess(chardata.getLong("lastAccess"));
        return charInfopackage;
    }
}

