/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.olympiad.AbstractOlympiadGame;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameClassed;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameManager;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameNonClassed;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTask;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTeams;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.ArrayList;
import java.util.List;

public class ExOlympiadMatchList
extends L2GameServerPacket {
    private final List<OlympiadGameTask> _games = new ArrayList<OlympiadGameTask>();

    public ExOlympiadMatchList() {
        for (int i = 0; i < OlympiadGameManager.getInstance().getNumberOfStadiums(); ++i) {
            OlympiadGameTask task = OlympiadGameManager.getInstance().getOlympiadTask(i);
            if (task == null || !task.isGameStarted() || task.isBattleFinished()) continue;
            this._games.add(task);
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(254);
        this.writeH(212);
        this.writeD(0);
        this.writeD(this._games.size());
        this.writeD(0);
        for (OlympiadGameTask curGame : this._games) {
            AbstractOlympiadGame game = curGame.getGame();
            if (game == null) continue;
            this.writeD(game.getStadiumId());
            if (game instanceof OlympiadGameNonClassed) {
                this.writeD(1);
            } else if (game instanceof OlympiadGameClassed) {
                this.writeD(2);
            } else if (game instanceof OlympiadGameTeams) {
                this.writeD(-1);
            } else {
                this.writeD(0);
            }
            this.writeD(curGame.isRunning() ? 2 : 1);
            this.writeS(game.getPlayerNames()[0]);
            this.writeS(game.getPlayerNames()[1]);
        }
    }
}

