/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class ExShowBaseAttributeCancelWindow
extends L2GameServerPacket {
    private final L2ItemInstance[] _items;
    private long _price;

    public ExShowBaseAttributeCancelWindow(L2PcInstance player) {
        this._items = player.getInventory().getElementItems();
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(116);
        this.writeD(this._items.length);
        for (L2ItemInstance item : this._items) {
            this.writeD(item.getObjectId());
            this.writeQ(this.getPrice(item));
        }
    }

    private long getPrice(L2ItemInstance item) {
        switch (item.getItem().getCrystalType()) {
            case S: {
                if (item.getItem() instanceof L2Weapon) {
                    this._price = 50000L;
                    break;
                }
                this._price = 40000L;
                break;
            }
            case S80: {
                if (item.getItem() instanceof L2Weapon) {
                    this._price = 100000L;
                    break;
                }
                this._price = 80000L;
                break;
            }
            case S84: {
                this._price = item.getItem() instanceof L2Weapon ? 200000L : 160000L;
            }
        }
        return this._price;
    }
}

