/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.model.L2Seed;
import com.l2jserver.gameserver.model.SeedProduction;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;

public class ExShowSeedInfo
extends L2GameServerPacket {
    private final List<SeedProduction> _seeds;
    private final int _manorId;
    private final boolean _hideButtons;

    public ExShowSeedInfo(int manorId, boolean nextPeriod, boolean hideButtons) {
        this._manorId = manorId;
        this._hideButtons = hideButtons;
        CastleManorManager manor = CastleManorManager.getInstance();
        this._seeds = nextPeriod && !manor.isManorApproved() ? null : manor.getSeedProduction(manorId, nextPeriod);
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(35);
        this.writeC(this._hideButtons ? 1 : 0);
        this.writeD(this._manorId);
        this.writeD(0);
        if (this._seeds == null) {
            this.writeD(0);
            return;
        }
        this.writeD(this._seeds.size());
        for (SeedProduction seed : this._seeds) {
            this.writeD(seed.getId());
            this.writeQ(seed.getAmount());
            this.writeQ(seed.getStartAmount());
            this.writeQ(seed.getPrice());
            L2Seed s = CastleManorManager.getInstance().getSeed(seed.getId());
            if (s == null) {
                this.writeD(0);
                this.writeC(1);
                this.writeD(0);
                this.writeC(1);
                this.writeD(0);
                continue;
            }
            this.writeD(s.getLevel());
            this.writeC(1);
            this.writeD(s.getReward(1));
            this.writeC(1);
            this.writeD(s.getReward(2));
        }
    }
}

