/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.model.CropProcure;
import com.l2jserver.gameserver.model.L2Seed;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class ExShowSellCropList
extends L2GameServerPacket {
    private final int _manorId;
    private final Map<Integer, L2ItemInstance> _cropsItems = new HashMap<Integer, L2ItemInstance>();
    private final Map<Integer, CropProcure> _castleCrops = new HashMap<Integer, CropProcure>();

    public ExShowSellCropList(PcInventory inventory, int manorId) {
        this._manorId = manorId;
        Iterator<Object> iterator = CastleManorManager.getInstance().getCropIds().iterator();
        while (iterator.hasNext()) {
            int cropId = iterator.next();
            L2ItemInstance item = inventory.getItemByItemId(cropId);
            if (item == null) continue;
            this._cropsItems.put(cropId, item);
        }
        for (CropProcure crop : CastleManorManager.getInstance().getCropProcure(this._manorId, false)) {
            if (!this._cropsItems.containsKey(crop.getId()) || crop.getAmount() <= 0L) continue;
            this._castleCrops.put(crop.getId(), crop);
        }
    }

    @Override
    public void writeImpl() {
        this.writeC(254);
        this.writeH(44);
        this.writeD(this._manorId);
        this.writeD(this._cropsItems.size());
        for (L2ItemInstance item : this._cropsItems.values()) {
            L2Seed seed = CastleManorManager.getInstance().getSeedByCrop(item.getId());
            this.writeD(item.getObjectId());
            this.writeD(item.getId());
            this.writeD(seed.getLevel());
            this.writeC(1);
            this.writeD(seed.getReward(1));
            this.writeC(1);
            this.writeD(seed.getReward(2));
            if (this._castleCrops.containsKey(item.getId())) {
                CropProcure crop = this._castleCrops.get(item.getId());
                this.writeD(this._manorId);
                this.writeQ(crop.getAmount());
                this.writeQ(crop.getPrice());
                this.writeC(crop.getReward());
            } else {
                this.writeD(-1);
                this.writeQ(0L);
                this.writeQ(0L);
                this.writeC(0);
            }
            this.writeQ(item.getCount());
        }
    }
}

