/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.ArrayList;
import java.util.List;

public final class NpcSay
extends L2GameServerPacket {
    private final int _objectId;
    private final int _textType;
    private final int _npcId;
    private String _text;
    private final int _npcString;
    private List<String> _parameters;

    public NpcSay(int objectId, int messageType2, int npcId, String text) {
        this._objectId = objectId;
        this._textType = messageType2;
        this._npcId = 1000000 + npcId;
        this._npcString = -1;
        this._text = text;
    }

    public NpcSay(L2Npc npc, int messageType2, String text) {
        this._objectId = npc.getObjectId();
        this._textType = messageType2;
        this._npcId = 1000000 + npc.getId();
        this._npcString = -1;
        this._text = text;
    }

    public NpcSay(int objectId, int messageType2, int npcId, NpcStringId npcString) {
        this._objectId = objectId;
        this._textType = messageType2;
        this._npcId = 1000000 + npcId;
        this._npcString = npcString.getId();
    }

    public NpcSay(L2Npc npc, int messageType2, NpcStringId npcString) {
        this._objectId = npc.getObjectId();
        this._textType = messageType2;
        this._npcId = 1000000 + npc.getId();
        this._npcString = npcString.getId();
    }

    public NpcSay addStringParameter(String text) {
        if (this._parameters == null) {
            this._parameters = new ArrayList<String>();
        }
        this._parameters.add(text);
        return this;
    }

    public NpcSay addStringParameters(String ... params) {
        if (params != null && params.length > 0) {
            if (this._parameters == null) {
                this._parameters = new ArrayList<String>();
            }
            for (String item : params) {
                if (item == null || item.length() <= 0) continue;
                this._parameters.add(item);
            }
        }
        return this;
    }

    @Override
    protected void writeImpl() {
        this.writeC(48);
        this.writeD(this._objectId);
        this.writeD(this._textType);
        this.writeD(this._npcId);
        this.writeD(this._npcString);
        if (this._npcString == -1) {
            this.writeS(this._text);
        } else if (this._parameters != null) {
            for (String s : this._parameters) {
                this.writeS(s);
            }
        }
    }
}

