/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class PlaySound
extends L2GameServerPacket {
    private final int _type;
    private final String _soundFile;
    private final int _bindToObject;
    private final int _objectId;
    private final int _locX;
    private final int _locY;
    private final int _locZ;
    private final int _delay;

    public static PlaySound createSound(String soundName) {
        return new PlaySound(soundName);
    }

    public static PlaySound createSound(String soundName, L2Object obj) {
        return new PlaySound(soundName, obj);
    }

    public static PlaySound createMusic(String soundName) {
        return PlaySound.createMusic(soundName, 0);
    }

    public static PlaySound createMusic(String soundName, int delay) {
        return new PlaySound(1, soundName, delay);
    }

    public static PlaySound createVoice(String soundName) {
        return PlaySound.createVoice(soundName, 0);
    }

    public static PlaySound createVoice(String soundName, int delay) {
        return new PlaySound(2, soundName, delay);
    }

    private PlaySound(String soundFile) {
        this._type = 0;
        this._soundFile = soundFile;
        this._bindToObject = 0;
        this._objectId = 0;
        this._locX = 0;
        this._locY = 0;
        this._locZ = 0;
        this._delay = 0;
    }

    private PlaySound(String soundFile, L2Object obj) {
        this._type = 0;
        this._soundFile = soundFile;
        if (obj != null) {
            this._bindToObject = 1;
            this._objectId = obj.getObjectId();
            this._locX = obj.getX();
            this._locY = obj.getY();
            this._locZ = obj.getZ();
        } else {
            this._bindToObject = 0;
            this._objectId = 0;
            this._locX = 0;
            this._locY = 0;
            this._locZ = 0;
        }
        this._delay = 0;
    }

    private PlaySound(int type, String soundFile, int radius) {
        this._type = type;
        this._soundFile = soundFile;
        this._bindToObject = 0;
        this._objectId = 0;
        this._locX = 0;
        this._locY = 0;
        this._locZ = 0;
        this._delay = radius;
    }

    public String getSoundName() {
        return this._soundFile;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(158);
        this.writeD(this._type);
        this.writeS(this._soundFile);
        this.writeD(this._bindToObject);
        this.writeD(this._objectId);
        this.writeD(this._locX);
        this.writeD(this._locY);
        this.writeD(this._locZ);
        this.writeD(this._delay);
    }
}

