/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.script.faenor;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.script.DateRange;
import com.l2jserver.gameserver.script.IntList;
import com.l2jserver.gameserver.script.Parser;
import com.l2jserver.gameserver.script.ParserFactory;
import com.l2jserver.gameserver.script.ScriptEngine;
import com.l2jserver.gameserver.script.faenor.FaenorParser;
import java.util.Date;
import javax.script.ScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class FaenorEventParser
extends FaenorParser {
    private static final Logger LOG = LoggerFactory.getLogger(FaenorEventParser.class);
    private DateRange _eventDates = null;

    @Override
    public void parseScript(Node eventNode, ScriptContext context) {
        String id = FaenorEventParser.attribute(eventNode, "ID");
        this._eventDates = DateRange.parse(FaenorEventParser.attribute(eventNode, "Active"), this.DATE_FORMAT);
        Date currentDate = new Date();
        if (this._eventDates.getEndDate().before(currentDate)) {
            LOG.info("Event Id {} has passed... Ignored.", (Object)id);
            return;
        }
        if (this._eventDates.getStartDate().after(currentDate)) {
            LOG.info("Event Id {} is not active yet... Ignored.", (Object)id);
            ThreadPoolManager.getInstance().scheduleGeneral(() -> this.parseEventDropAndMessage(eventNode), this._eventDates.getStartDate().getTime() - currentDate.getTime());
            return;
        }
        this.parseEventDropAndMessage(eventNode);
    }

    protected void parseEventDropAndMessage(Node eventNode) {
        for (Node node = eventNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (FaenorEventParser.isNodeName(node, "DropList")) {
                this.parseEventDropList(node);
                continue;
            }
            if (!FaenorEventParser.isNodeName(node, "Message")) continue;
            this.parseEventMessage(node);
        }
    }

    private void parseEventMessage(Node sysMsg) {
        try {
            String type = FaenorEventParser.attribute(sysMsg, "Type");
            String message = FaenorEventParser.attribute(sysMsg, "Msg");
            if (type.equalsIgnoreCase("OnJoin")) {
                _bridge.onPlayerLogin(message, this._eventDates);
            }
        }
        catch (Exception ex) {
            LOG.warn("There has been an error in event parser!", ex);
        }
    }

    private void parseEventDropList(Node dropList) {
        for (Node node = dropList.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!FaenorEventParser.isNodeName(node, "AllDrop")) continue;
            this.parseEventDrop(node);
        }
    }

    private void parseEventDrop(Node drop) {
        try {
            int[] items = IntList.parse(FaenorEventParser.attribute(drop, "Items"));
            int[] count = IntList.parse(FaenorEventParser.attribute(drop, "Count"));
            double chance = FaenorEventParser.getPercent(FaenorEventParser.attribute(drop, "Chance"));
            _bridge.addEventDrop(items, count, chance, this._eventDates);
        }
        catch (Exception ex) {
            LOG.warn("There has been an error parsing drops!", ex);
        }
    }

    static {
        ScriptEngine.parserFactories.put(FaenorEventParser.getParserName("Event"), new FaenorEventParserFactory());
    }

    static class FaenorEventParserFactory
    extends ParserFactory {
        FaenorEventParserFactory() {
        }

        @Override
        public Parser create() {
            return new FaenorEventParser();
        }
    }
}

