/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnownListUpdateTaskManager {
    private static final Logger LOG = LoggerFactory.getLogger(KnownListUpdateTaskManager.class);
    private static final int FULL_UPDATE_TIMER = 1;
    private static boolean updatePass = true;
    private static int _fullUpdateTimer = 1;
    private static final Set<L2WorldRegion> FAILED_REGIONS = ConcurrentHashMap.newKeySet(1);

    private KnownListUpdateTaskManager() {
        ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new KnownListUpdate(), 1000L, Configuration.general().getKnownListUpdateInterval());
    }

    private void updateRegion(L2WorldRegion region, boolean fullUpdate, boolean forgetObjects) {
        Collection<L2Object> vObj = region.getVisibleObjects().values();
        for (L2Object object : vObj) {
            boolean aggro;
            if (object == null || !object.isVisible()) continue;
            boolean bl = aggro = Configuration.npc().guardAttackAggroMob() && object instanceof L2GuardInstance;
            if (forgetObjects) {
                object.getKnownList().forgetObjects(aggro || fullUpdate);
                continue;
            }
            for (L2WorldRegion worldRegion : region.getSurroundingRegions()) {
                if (object instanceof L2Playable || aggro && worldRegion.isActive() || fullUpdate) {
                    Collection<L2Object> inrObj = worldRegion.getVisibleObjects().values();
                    for (L2Object l2Object : inrObj) {
                        if (l2Object == object) continue;
                        object.getKnownList().addKnownObject(l2Object);
                    }
                    continue;
                }
                if (!(object instanceof L2Character) || !worldRegion.isActive()) continue;
                Collection<L2Playable> inrPls = worldRegion.getVisiblePlayable().values();
                for (L2Object l2Object : inrPls) {
                    if (l2Object == object) continue;
                    object.getKnownList().addKnownObject(l2Object);
                }
            }
        }
    }

    public static KnownListUpdateTaskManager getInstance() {
        return SingletonHolder._instance;
    }

    private class KnownListUpdate
    implements Runnable {
        @Override
        public void run() {
            try {
                L2WorldRegion[][] l2WorldRegionArray = L2World.getInstance().getWorldRegions();
                int n = l2WorldRegionArray.length;
                for (int i = 0; i < n; ++i) {
                    L2WorldRegion[] regions;
                    for (L2WorldRegion r : regions = l2WorldRegionArray[i]) {
                        try {
                            boolean failed = FAILED_REGIONS.contains(r);
                            if (r.isActive()) {
                                KnownListUpdateTaskManager.this.updateRegion(r, _fullUpdateTimer == 1 || failed, updatePass);
                            }
                            if (!failed) continue;
                            FAILED_REGIONS.remove(r);
                        }
                        catch (Exception e) {
                            LOG.warn("updateRegion({},{}) failed for region {}. Full update scheduled. {}", _fullUpdateTimer, updatePass, r.getName(), e.getMessage(), e);
                            FAILED_REGIONS.add(r);
                        }
                    }
                }
                boolean bl = updatePass = !updatePass;
                _fullUpdateTimer = _fullUpdateTimer > 0 ? --_fullUpdateTimer : 1;
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), e);
            }
        }
    }

    private static class SingletonHolder {
        protected static final KnownListUpdateTaskManager _instance = new KnownListUpdateTaskManager();

        private SingletonHolder() {
        }
    }
}

