/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.CharInfo;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.ExShowScreenMessage;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.RelationChanged;
import com.l2jserver.gameserver.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Broadcast {
    private static final Logger LOG = LoggerFactory.getLogger(Broadcast.class);

    public static void toPlayersTargettingMyself(L2Character character, L2GameServerPacket mov) {
        for (L2PcInstance player : character.getKnownList().getKnownPlayers().values()) {
            if (player.getTarget() != character) continue;
            player.sendPacket(mov);
        }
    }

    public static void toKnownPlayers(L2Character character, L2GameServerPacket mov) {
        for (L2PcInstance player : character.getKnownList().getKnownPlayers().values()) {
            if (player == null) continue;
            try {
                player.sendPacket(mov);
                if (!(mov instanceof CharInfo) || !(character instanceof L2PcInstance)) continue;
                int relation = ((L2PcInstance)character).getRelation(player);
                Integer oldrelation = character.getKnownList().getKnownRelations().get(player.getObjectId());
                if (oldrelation == null || oldrelation == relation) continue;
                player.sendPacket(new RelationChanged((L2PcInstance)character, relation, character.isAutoAttackable(player)));
                if (!character.hasSummon()) continue;
                player.sendPacket(new RelationChanged(character.getSummon(), relation, character.isAutoAttackable(player)));
            }
            catch (NullPointerException e) {
                LOG.warn(e.getMessage(), e);
            }
        }
    }

    public static void toKnownPlayersInRadius(L2Character character, L2GameServerPacket mov, int radius) {
        if (radius < 0) {
            radius = 1500;
        }
        for (L2PcInstance player : character.getKnownList().getKnownPlayers().values()) {
            if (!character.isInsideRadius(player, radius, false, false)) continue;
            player.sendPacket(mov);
        }
    }

    public static void toSelfAndKnownPlayers(L2Character character, L2GameServerPacket mov) {
        if (character instanceof L2PcInstance) {
            character.sendPacket(mov);
        }
        Broadcast.toKnownPlayers(character, mov);
    }

    public static void toSelfAndKnownPlayersInRadius(L2Character character, L2GameServerPacket mov, int radius) {
        if (radius < 0) {
            radius = 600;
        }
        if (character instanceof L2PcInstance) {
            character.sendPacket(mov);
        }
        for (L2PcInstance player : character.getKnownList().getKnownPlayers().values()) {
            if (player == null || !Util.checkIfInRange(radius, character, player, false)) continue;
            player.sendPacket(mov);
        }
    }

    public static void toAllOnlinePlayers(L2GameServerPacket packet) {
        for (L2PcInstance player : L2World.getInstance().getPlayers()) {
            if (!player.isOnline()) continue;
            player.sendPacket(packet);
        }
    }

    public static void toAllOnlinePlayers(String text) {
        Broadcast.toAllOnlinePlayers(text, false);
    }

    public static void toAllOnlinePlayers(String text, boolean isCritical) {
        Broadcast.toAllOnlinePlayers(new CreatureSay(0, isCritical ? 18 : 10, "", text));
    }

    public static void toPlayersInInstance(L2GameServerPacket packet, int instanceId) {
        for (L2PcInstance player : L2World.getInstance().getPlayers()) {
            if (!player.isOnline() || player.getInstanceId() != instanceId) continue;
            player.sendPacket(packet);
        }
    }

    public static void toAllOnlinePlayersOnScreen(String text) {
        Broadcast.toAllOnlinePlayers(new ExShowScreenMessage(text, 10000));
    }
}

