/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.Shutdown;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.util.Broadcast;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadLockDetector
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(DeadLockDetector.class);
    private final ThreadMXBean tmx = ManagementFactory.getThreadMXBean();

    public DeadLockDetector() {
        super("DeadLockDetector");
    }

    @Override
    public final void run() {
        boolean deadlock = false;
        while (!deadlock) {
            try {
                long[] ids = this.tmx.findDeadlockedThreads();
                if (ids != null) {
                    deadlock = true;
                    ThreadInfo[] tis = this.tmx.getThreadInfo(ids, true, true);
                    StringBuilder info = new StringBuilder();
                    info.append("DeadLock Found!");
                    info.append(Configuration.EOL);
                    for (ThreadInfo ti : tis) {
                        info.append(ti.toString());
                    }
                    for (ThreadInfo ti : tis) {
                        LockInfo[] locks = ti.getLockedSynchronizers();
                        MonitorInfo[] monitors = ti.getLockedMonitors();
                        if (locks.length == 0 && monitors.length == 0) continue;
                        ThreadInfo dl = ti;
                        info.append("Java-level deadlock:");
                        info.append(Configuration.EOL);
                        info.append('\t');
                        info.append(dl.getThreadName());
                        info.append(" is waiting to lock ");
                        info.append(dl.getLockInfo().toString());
                        info.append(" which is held by ");
                        info.append(dl.getLockOwnerName());
                        info.append(Configuration.EOL);
                        while ((dl = this.tmx.getThreadInfo(new long[]{dl.getLockOwnerId()}, true, true)[0]).getThreadId() != ti.getThreadId()) {
                            info.append('\t');
                            info.append(dl.getThreadName());
                            info.append(" is waiting to lock ");
                            info.append(dl.getLockInfo().toString());
                            info.append(" which is held by ");
                            info.append(dl.getLockOwnerName());
                            info.append(Configuration.EOL);
                        }
                    }
                    LOG.warn(info.toString());
                    if (Configuration.general().restartOnDeadlock()) {
                        Broadcast.toAllOnlinePlayers("Server has stability issues - restarting now.");
                        Shutdown.getInstance().startTelnetShutdown("DeadLockDetector - Auto Restart", 60, true);
                    }
                }
                Thread.sleep(Configuration.general().getDeadLockCheckInterval());
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), e);
            }
        }
    }
}

