/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

public final class EnumIntBitmask<E extends Enum<E>>
implements Cloneable {
    private final Class<E> _enumClass;
    private int _bitmask;

    public static <E extends Enum<E>> int getAllBitmask(Class<E> enumClass) {
        int allBitmask = 0;
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        if (values.length > 32) {
            throw new IllegalArgumentException("Enum too big for an integer bitmask.");
        }
        for (Enum value : values) {
            allBitmask |= 1 << value.ordinal();
        }
        return allBitmask;
    }

    public EnumIntBitmask(Class<E> enumClass, boolean all) {
        this._enumClass = enumClass;
        Enum[] values = (Enum[])this._enumClass.getEnumConstants();
        if (values.length > 32) {
            throw new IllegalArgumentException("Enum too big for an integer bitmask.");
        }
        if (all) {
            this.setAll();
        } else {
            this.clear();
        }
    }

    public EnumIntBitmask(Class<E> enumClass, int bitmask) {
        this._enumClass = enumClass;
        this._bitmask = bitmask;
    }

    public void setAll() {
        this.set((Enum[])this._enumClass.getEnumConstants());
    }

    public void clear() {
        this._bitmask = 0;
    }

    @SafeVarargs
    public final void set(E ... many) {
        this.clear();
        for (E one : many) {
            this._bitmask |= 1 << ((Enum)one).ordinal();
        }
    }

    @SafeVarargs
    public final void set(E first, E ... more) {
        this.clear();
        this.add((Enum)first, (Enum[])more);
    }

    public void setBitmask(int bitmask) {
        this._bitmask = bitmask;
    }

    @SafeVarargs
    public final void add(E first, E ... more) {
        this._bitmask |= 1 << ((Enum)first).ordinal();
        if (more != null) {
            for (E one : more) {
                this._bitmask |= 1 << ((Enum)one).ordinal();
            }
        }
    }

    @SafeVarargs
    public final void remove(E first, E ... more) {
        this._bitmask &= ~(1 << ((Enum)first).ordinal());
        if (more != null) {
            for (E one : more) {
                this._bitmask &= ~(1 << ((Enum)one).ordinal());
            }
        }
    }

    @SafeVarargs
    public final boolean has(E first, E ... more) {
        if ((this._bitmask & 1 << ((Enum)first).ordinal()) == 0) {
            return false;
        }
        for (E one : more) {
            if ((this._bitmask & 1 << ((Enum)one).ordinal()) != 0) continue;
            return false;
        }
        return true;
    }

    public EnumIntBitmask<E> clone() {
        return new EnumIntBitmask<E>(this._enumClass, this._bitmask);
    }

    public int getBitmask() {
        return this._bitmask;
    }
}

