/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ExServerPrimitive;
import com.l2jserver.gameserver.util.LinePointIterator;
import com.l2jserver.gameserver.util.LinePointIterator3D;
import java.awt.Color;

public final class GeoUtils {
    public static void debug2DLine(L2PcInstance player, int x, int y, int tx, int ty, int z) {
        int gx = GeoData.getInstance().getGeoX(x);
        int gy = GeoData.getInstance().getGeoY(y);
        int tgx = GeoData.getInstance().getGeoX(tx);
        int tgy = GeoData.getInstance().getGeoY(ty);
        ExServerPrimitive prim = new ExServerPrimitive("Debug2DLine", x, y, z);
        prim.addLine(Color.BLUE, GeoData.getInstance().getWorldX(gx), GeoData.getInstance().getWorldY(gy), z, GeoData.getInstance().getWorldX(tgx), GeoData.getInstance().getWorldY(tgy), z);
        LinePointIterator iter = new LinePointIterator(gx, gy, tgx, tgy);
        while (iter.next()) {
            int wx = GeoData.getInstance().getWorldX(iter.x());
            int wy = GeoData.getInstance().getWorldY(iter.y());
            prim.addPoint(Color.RED, wx, wy, z);
        }
        player.sendPacket(prim);
    }

    public static void debug3DLine(L2PcInstance player, int x, int y, int z, int tx, int ty, int tz) {
        int gx = GeoData.getInstance().getGeoX(x);
        int gy = GeoData.getInstance().getGeoY(y);
        int tgx = GeoData.getInstance().getGeoX(tx);
        int tgy = GeoData.getInstance().getGeoY(ty);
        ExServerPrimitive prim = new ExServerPrimitive("Debug3DLine", x, y, z);
        prim.addLine(Color.BLUE, GeoData.getInstance().getWorldX(gx), GeoData.getInstance().getWorldY(gy), z, GeoData.getInstance().getWorldX(tgx), GeoData.getInstance().getWorldY(tgy), tz);
        LinePointIterator3D iter = new LinePointIterator3D(gx, gy, z, tgx, tgy, tz);
        iter.next();
        int prevX = iter.x();
        int prevY = iter.y();
        int wx = GeoData.getInstance().getWorldX(prevX);
        int wy = GeoData.getInstance().getWorldY(prevY);
        int wz = iter.z();
        prim.addPoint(Color.RED, wx, wy, wz);
        while (iter.next()) {
            int curX = iter.x();
            int curY = iter.y();
            if (curX == prevX && curY == prevY) continue;
            wx = GeoData.getInstance().getWorldX(curX);
            wy = GeoData.getInstance().getWorldY(curY);
            wz = iter.z();
            prim.addPoint(Color.RED, wx, wy, wz);
            prevX = curX;
            prevY = curY;
        }
        player.sendPacket(prim);
    }

    private static Color getDirectionColor(int x, int y, int z, int nswe) {
        if (GeoData.getInstance().checkNearestNswe(x, y, z, nswe)) {
            return Color.GREEN;
        }
        return Color.RED;
    }

    public static void debugGrid(L2PcInstance player) {
        int blocksPerPacket;
        int geoRadius = 10;
        int iBlock = blocksPerPacket = 49;
        int iPacket = 0;
        ExServerPrimitive exsp = null;
        GeoData gd = GeoData.getInstance();
        int playerGx = gd.getGeoX(player.getX());
        int playerGy = gd.getGeoY(player.getY());
        for (int dx = -geoRadius; dx <= geoRadius; ++dx) {
            for (int dy = -geoRadius; dy <= geoRadius; ++dy) {
                if (iBlock >= blocksPerPacket) {
                    iBlock = 0;
                    if (exsp != null) {
                        ++iPacket;
                        player.sendPacket(exsp);
                    }
                    exsp = new ExServerPrimitive("DebugGrid_" + iPacket, player.getX(), player.getY(), -16000);
                }
                int gx = playerGx + dx;
                int gy = playerGy + dy;
                int x = gd.getWorldX(gx);
                int y = gd.getWorldY(gy);
                int z = gd.getNearestZ(gx, gy, player.getZ());
                Color col = GeoUtils.getDirectionColor(gx, gy, z, 8);
                exsp.addLine(col, x - 1, y - 7, z, x + 1, y - 7, z);
                exsp.addLine(col, x - 2, y - 6, z, x + 2, y - 6, z);
                exsp.addLine(col, x - 3, y - 5, z, x + 3, y - 5, z);
                exsp.addLine(col, x - 4, y - 4, z, x + 4, y - 4, z);
                col = GeoUtils.getDirectionColor(gx, gy, z, 1);
                exsp.addLine(col, x + 7, y - 1, z, x + 7, y + 1, z);
                exsp.addLine(col, x + 6, y - 2, z, x + 6, y + 2, z);
                exsp.addLine(col, x + 5, y - 3, z, x + 5, y + 3, z);
                exsp.addLine(col, x + 4, y - 4, z, x + 4, y + 4, z);
                col = GeoUtils.getDirectionColor(gx, gy, z, 4);
                exsp.addLine(col, x - 1, y + 7, z, x + 1, y + 7, z);
                exsp.addLine(col, x - 2, y + 6, z, x + 2, y + 6, z);
                exsp.addLine(col, x - 3, y + 5, z, x + 3, y + 5, z);
                exsp.addLine(col, x - 4, y + 4, z, x + 4, y + 4, z);
                col = GeoUtils.getDirectionColor(gx, gy, z, 2);
                exsp.addLine(col, x - 7, y - 1, z, x - 7, y + 1, z);
                exsp.addLine(col, x - 6, y - 2, z, x - 6, y + 2, z);
                exsp.addLine(col, x - 5, y - 3, z, x - 5, y + 3, z);
                exsp.addLine(col, x - 4, y - 4, z, x - 4, y + 4, z);
                ++iBlock;
            }
        }
        player.sendPacket(exsp);
    }

    public static int computeNswe(int lastX, int lastY, int x, int y) {
        if (x > lastX) {
            if (y > lastY) {
                return 5;
            }
            if (y < lastY) {
                return 9;
            }
            return 1;
        }
        if (x < lastX) {
            if (y > lastY) {
                return 6;
            }
            if (y < lastY) {
                return 10;
            }
            return 2;
        }
        if (y > lastY) {
            return 4;
        }
        if (y < lastY) {
            return 8;
        }
        throw new RuntimeException();
    }
}

