/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

public final class StringUtil {
    private StringUtil() {
    }

    public static String concat(String ... strings) {
        StringBuilder sbString = new StringBuilder();
        for (String string : strings) {
            sbString.append(string);
        }
        return sbString.toString();
    }

    public static StringBuilder startAppend(int sizeHint, String ... strings) {
        int length = StringUtil.getLength(strings);
        StringBuilder sbString = new StringBuilder(Math.max(sizeHint, length));
        for (String string : strings) {
            sbString.append(string);
        }
        return sbString;
    }

    public static void append(StringBuilder sbString, String ... strings) {
        sbString.ensureCapacity(sbString.length() + StringUtil.getLength(strings));
        for (String string : strings) {
            sbString.append(string);
        }
    }

    public static int getLength(Iterable<String> strings) {
        int length = 0;
        for (String string : strings) {
            length += string == null ? 4 : string.length();
        }
        return length;
    }

    public static int getLength(String[] strings) {
        int length = 0;
        for (String string : strings) {
            length += string == null ? 4 : string.length();
        }
        return length;
    }

    public static String getTraceString(StackTraceElement[] trace) {
        StringBuilder sbString = new StringBuilder();
        for (StackTraceElement element : trace) {
            sbString.append(element.toString()).append(System.lineSeparator());
        }
        return sbString.toString();
    }
}

