/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.HtmlActionScope;
import com.l2jserver.gameserver.enums.IllegalActionPunishmentType;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.tasks.player.IllegalPlayerActionTask;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.ShowBoard;
import com.l2jserver.gameserver.util.file.filter.ExtFilter;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);
    private static final NumberFormat ADENA_FORMATTER = NumberFormat.getIntegerInstance(Locale.ENGLISH);

    public static void handleIllegalPlayerAction(L2PcInstance actor, String message) {
        Util.handleIllegalPlayerAction(actor, message, Configuration.general().getDefaultPunish());
    }

    public static void handleIllegalPlayerAction(L2PcInstance actor, String message, IllegalActionPunishmentType punishment) {
        ThreadPoolManager.getInstance().scheduleGeneral(new IllegalPlayerActionTask(actor, message, punishment), 5000L);
    }

    public static double calculateAngleFrom(ILocational from, ILocational to) {
        return Util.calculateAngleFrom(from.getX(), from.getY(), to.getX(), to.getY());
    }

    public static double calculateAngleFrom(int fromX, int fromY, int toX, int toY) {
        double angleTarget = Math.toDegrees(Math.atan2(toY - fromY, toX - fromX));
        if (angleTarget < 0.0) {
            angleTarget = 360.0 + angleTarget;
        }
        return angleTarget;
    }

    public static double convertHeadingToDegree(int clientHeading) {
        return (double)clientHeading / 182.044444444;
    }

    public static int convertDegreeToClientHeading(double degree) {
        if (degree < 0.0) {
            degree = 360.0 + degree;
        }
        return (int)(degree * 182.044444444);
    }

    public static int calculateHeadingFrom(ILocational from, ILocational to) {
        return Util.calculateHeadingFrom(from.getX(), from.getY(), to.getX(), to.getY());
    }

    public static int calculateHeadingFrom(int fromX, int fromY, int toX, int toY) {
        double angleTarget = Math.toDegrees(Math.atan2(toY - fromY, toX - fromX));
        if (angleTarget < 0.0) {
            angleTarget = 360.0 + angleTarget;
        }
        return (int)(angleTarget * 182.044444444);
    }

    public static int calculateHeadingFrom(double dx, double dy) {
        double angleTarget = Math.toDegrees(Math.atan2(dy, dx));
        if (angleTarget < 0.0) {
            angleTarget = 360.0 + angleTarget;
        }
        return (int)(angleTarget * 182.044444444);
    }

    public static double calculateDistance(double x1, double y1, double z1, double x2, double y2, double z2, boolean includeZAxis, boolean squared) {
        double distance = Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + (includeZAxis ? Math.pow(z1 - z2, 2.0) : 0.0);
        return squared ? distance : Math.sqrt(distance);
    }

    public static double calculateDistance(ILocational loc1, ILocational loc2, boolean includeZAxis, boolean squared) {
        return Util.calculateDistance(loc1.getX(), loc1.getY(), loc1.getZ(), loc2.getX(), loc2.getY(), loc2.getZ(), includeZAxis, squared);
    }

    public static String capitalizeFirst(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        char[] arr = str.toCharArray();
        char c = arr[0];
        if (Character.isLetter(c)) {
            arr[0] = Character.toUpperCase(c);
        }
        return new String(arr);
    }

    @Deprecated
    public static String capitalizeWords(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        char[] charArray = str.toCharArray();
        StringBuilder result = new StringBuilder();
        charArray[0] = Character.toUpperCase(charArray[0]);
        for (int i = 0; i < charArray.length; ++i) {
            if (Character.isWhitespace(charArray[i])) {
                charArray[i + 1] = Character.toUpperCase(charArray[i + 1]);
            }
            result.append(charArray[i]);
        }
        return result.toString();
    }

    public static boolean checkIfInRange(int range, L2Object obj1, L2Object obj2, boolean includeZAxis) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1.getInstanceId() != obj2.getInstanceId()) {
            return false;
        }
        if (range == -1) {
            return true;
        }
        int rad = 0;
        if (obj1 instanceof L2Character) {
            rad += ((L2Character)obj1).getTemplate().getCollisionRadius();
        }
        if (obj2 instanceof L2Character) {
            rad += ((L2Character)obj2).getTemplate().getCollisionRadius();
        }
        double d = Math.hypot(obj1.getX() - obj2.getX(), obj1.getY() - obj2.getY());
        if (includeZAxis) {
            d = Math.hypot(d, obj1.getZ() - obj2.getZ());
        }
        return d - (double)rad / 2.0 <= (double)range;
    }

    public static boolean checkIfInShortRadius(int radius, L2Object obj1, L2Object obj2, boolean includeZAxis) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (radius == -1) {
            return true;
        }
        double d = Math.hypot(obj1.getX() - obj2.getX(), obj1.getY() - obj2.getY());
        if (includeZAxis) {
            return Math.hypot(d, obj1.getZ() - obj2.getZ()) <= (double)radius;
        }
        return d <= (double)radius;
    }

    public static int countWords(String str) {
        return str.trim().split("\\s+").length;
    }

    public static String implodeString(Iterable<String> strings, String delimiter) {
        StringJoiner sj = new StringJoiner(delimiter);
        strings.forEach(sj::add);
        return sj.toString();
    }

    public static <T> String implode(T[] array, String delimiter) {
        StringBuilder result = new StringBuilder();
        for (T val : array) {
            result.append(val.toString()).append(delimiter);
        }
        if (result.length() > 0) {
            result = new StringBuilder(result.substring(0, result.length() - 1));
        }
        return result.toString();
    }

    public static float roundTo(float number, int numPlaces) {
        if (numPlaces <= 1) {
            return Math.round(number);
        }
        float exponent = (float)Math.pow(10.0, numPlaces);
        return (float)Math.round(number * exponent) / exponent;
    }

    public static boolean isDigit(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        for (char c : text.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        for (char c : text.toCharArray()) {
            if (Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatAdena(long amount) {
        NumberFormat numberFormat = ADENA_FORMATTER;
        synchronized (numberFormat) {
            return ADENA_FORMATTER.format(amount);
        }
    }

    public static String formatDouble(double val, String format) {
        DecimalFormat formatter = new DecimalFormat(format, new DecimalFormatSymbols(Locale.ENGLISH));
        return formatter.format(val);
    }

    public static String formatDate(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static <T> boolean contains(T[] array, T obj) {
        for (T element : array) {
            if (element != obj) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] array, int obj) {
        for (int element : array) {
            if (element != obj) continue;
            return true;
        }
        return false;
    }

    public static File[] getDatapackFiles(String dirname, String extension) {
        File dir = new File(Configuration.server().getDatapackRoot(), "data/" + dirname);
        if (!dir.exists()) {
            return null;
        }
        return dir.listFiles(new ExtFilter(extension));
    }

    public static String getDateString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat.format(date.getTime());
    }

    private static void buildHtmlBypassCache(L2PcInstance player, HtmlActionScope scope, String html) {
        int bypassStartEnd;
        String htmlLower = html.toLowerCase(Locale.ENGLISH);
        int bypassEnd = 0;
        int bypassStart = htmlLower.indexOf("=\"bypass ", bypassEnd);
        while (bypassStart != -1 && (bypassEnd = htmlLower.indexOf("\"", bypassStartEnd = bypassStart + 9)) != -1) {
            int hParamPos = htmlLower.indexOf("-h ", bypassStartEnd);
            String bypass = hParamPos != -1 && hParamPos < bypassEnd ? html.substring(hParamPos + 3, bypassEnd).trim() : html.substring(bypassStartEnd, bypassEnd).trim();
            int firstParameterStart = bypass.indexOf(36);
            if (firstParameterStart != -1) {
                bypass = bypass.substring(0, firstParameterStart + 1);
            }
            if (Configuration.general().htmlActionCacheDebug()) {
                LOG.info("Cached html bypass({}): '{}'", (Object)scope.toString(), (Object)bypass);
            }
            player.addHtmlAction(scope, bypass);
            bypassStart = htmlLower.indexOf("=\"bypass ", bypassEnd);
        }
    }

    private static void buildHtmlLinkCache(L2PcInstance player, HtmlActionScope scope, String html) {
        int linkStartEnd;
        String htmlLower = html.toLowerCase(Locale.ENGLISH);
        int linkEnd = 0;
        int linkStart = htmlLower.indexOf("=\"link ", linkEnd);
        while (linkStart != -1 && (linkEnd = htmlLower.indexOf("\"", linkStartEnd = linkStart + 7)) != -1) {
            String htmlLink = html.substring(linkStartEnd, linkEnd).trim();
            if (htmlLink.isEmpty()) {
                LOG.warn("Html link path is empty!");
                continue;
            }
            if (htmlLink.contains("..")) {
                LOG.warn("Html link path is invalid {}!", (Object)htmlLink);
                continue;
            }
            if (Configuration.general().htmlActionCacheDebug()) {
                LOG.info("Cached html link({}): '{}'", (Object)scope.toString(), (Object)htmlLink);
            }
            player.addHtmlAction(scope, "link " + htmlLink);
            linkStart = htmlLower.indexOf("=\"link ", linkEnd);
        }
    }

    public static void buildHtmlActionCache(L2PcInstance player, HtmlActionScope scope, int npcObjId, String html) {
        if (player == null || scope == null || npcObjId < 0 || html == null) {
            throw new IllegalArgumentException();
        }
        if (Configuration.general().htmlActionCacheDebug()) {
            LOG.info("Set html action npc({}): {}", (Object)scope.toString(), (Object)npcObjId);
        }
        player.setHtmlActionOriginObjectId(scope, npcObjId);
        Util.buildHtmlBypassCache(player, scope, html);
        Util.buildHtmlLinkCache(player, scope, html);
    }

    public static void sendHtml(L2PcInstance activeChar, String html) {
        NpcHtmlMessage npcHtml = new NpcHtmlMessage();
        npcHtml.setHtml(html);
        activeChar.sendPacket(npcHtml);
    }

    public static void sendCBHtml(L2PcInstance activeChar, String html) {
        Util.sendCBHtml(activeChar, html, 0);
    }

    public static void sendCBHtml(L2PcInstance activeChar, String html, int npcObjId) {
        Util.sendCBHtml(activeChar, html, null, npcObjId);
    }

    public static void sendCBHtml(L2PcInstance activeChar, String html, String fillMultiEdit) {
        Util.sendCBHtml(activeChar, html, fillMultiEdit, 0);
    }

    public static void sendCBHtml(L2PcInstance activeChar, String html, String fillMultiEdit, int npcObjId) {
        if (activeChar == null || html == null) {
            return;
        }
        activeChar.clearHtmlActions(HtmlActionScope.COMM_BOARD_HTML);
        if (npcObjId > -1) {
            Util.buildHtmlActionCache(activeChar, HtmlActionScope.COMM_BOARD_HTML, npcObjId, html);
        }
        if (fillMultiEdit != null) {
            activeChar.sendPacket(new ShowBoard(html, "1001"));
            Util.fillMultiEditContent(activeChar, fillMultiEdit);
        } else if (html.length() < 16250) {
            activeChar.sendPacket(new ShowBoard(html, "101"));
            activeChar.sendPacket(new ShowBoard(null, "102"));
            activeChar.sendPacket(new ShowBoard(null, "103"));
        } else if (html.length() < 32500) {
            activeChar.sendPacket(new ShowBoard(html.substring(0, 16250), "101"));
            activeChar.sendPacket(new ShowBoard(html.substring(16250), "102"));
            activeChar.sendPacket(new ShowBoard(null, "103"));
        } else if (html.length() < 48750) {
            activeChar.sendPacket(new ShowBoard(html.substring(0, 16250), "101"));
            activeChar.sendPacket(new ShowBoard(html.substring(16250, 32500), "102"));
            activeChar.sendPacket(new ShowBoard(html.substring(32500), "103"));
        } else {
            activeChar.sendPacket(new ShowBoard("<html><body><br><center>Error: HTML was too long!</center></body></html>", "101"));
            activeChar.sendPacket(new ShowBoard(null, "102"));
            activeChar.sendPacket(new ShowBoard(null, "103"));
        }
    }

    public static void fillMultiEditContent(L2PcInstance activeChar, String text) {
        activeChar.sendPacket(new ShowBoard(Arrays.asList("0", "0", "0", "0", "0", "0", activeChar.getName(), Integer.toString(activeChar.getObjectId()), activeChar.getAccountName(), "9", " ", " ", text.replaceAll("<br>", Configuration.EOL), "0", "0", "0", "0")));
    }

    public static int getPlayersCountInRadius(int range, L2Object npc, boolean playable, boolean invisible) {
        int count = 0;
        Collection<L2Object> objs = npc.getKnownList().getKnownObjects().values();
        for (L2Object obj : objs) {
            L2Character cha;
            if (obj == null || !playable || !obj.isPlayable() && !obj.isPet() || !invisible && obj.isInvisible() || (cha = (L2Character)obj).getZ() < npc.getZ() - 100 && cha.getZ() > npc.getZ() + 100 || !GeoData.getInstance().canSeeTarget(cha.getX(), cha.getY(), cha.getZ(), npc.getX(), npc.getY(), npc.getZ()) || !Util.checkIfInRange(range, npc, obj, true) || cha.isDead()) continue;
            ++count;
        }
        return count;
    }

    public static boolean isInsideRangeOfObjectId(L2Object obj, int targetObjId, int radius) {
        L2Object target = obj.getKnownList().getKnownObjects().get(targetObjId);
        if (target == null) {
            return false;
        }
        return !(obj.calculateDistance(target, false, false) > (double)radius);
    }

    public static int min(int value1, int value2, int ... values) {
        int min = Math.min(value1, value2);
        for (int value : values) {
            if (min <= value) continue;
            min = value;
        }
        return min;
    }

    public static int max(int value1, int value2, int ... values) {
        int max = Math.max(value1, value2);
        for (int value : values) {
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public static long min(long value1, long value2, long ... values) {
        long min = Math.min(value1, value2);
        for (long value : values) {
            if (min <= value) continue;
            min = value;
        }
        return min;
    }

    public static long max(long value1, long value2, long ... values) {
        long max = Math.max(value1, value2);
        for (long value : values) {
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public static float min(float value1, float value2, float ... values) {
        float min = Math.min(value1, value2);
        for (float value : values) {
            if (!(min > value)) continue;
            min = value;
        }
        return min;
    }

    public static float max(float value1, float value2, float ... values) {
        float max = Math.max(value1, value2);
        for (float value : values) {
            if (!(max < value)) continue;
            max = value;
        }
        return max;
    }

    public static double min(double value1, double value2, double ... values) {
        double min = Math.min(value1, value2);
        for (double value : values) {
            if (!(min > value)) continue;
            min = value;
        }
        return min;
    }

    public static double max(double value1, double value2, double ... values) {
        double max = Math.max(value1, value2);
        for (double value : values) {
            if (!(max < value)) continue;
            max = value;
        }
        return max;
    }

    public static int getIndexOfMaxValue(int ... array) {
        int index = 0;
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= array[index]) continue;
            index = i;
        }
        return index;
    }

    public static int getIndexOfMinValue(int ... array) {
        int index = 0;
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= array[index]) continue;
            index = i;
        }
        return index;
    }

    public static int map(int input, int inputMin, int inputMax, int outputMin, int outputMax) {
        input = Util.constrain(input, inputMin, inputMax);
        return (input - inputMin) * (outputMax - outputMin) / (inputMax - inputMin) + outputMin;
    }

    public static long map(long input, long inputMin, long inputMax, long outputMin, long outputMax) {
        input = Util.constrain(input, inputMin, inputMax);
        return (input - inputMin) * (outputMax - outputMin) / (inputMax - inputMin) + outputMin;
    }

    public static double map(double input, double inputMin, double inputMax, double outputMin, double outputMax) {
        input = Util.constrain(input, inputMin, inputMax);
        return (input - inputMin) * (outputMax - outputMin) / (inputMax - inputMin) + outputMin;
    }

    public static int constrain(int input, int min, int max) {
        return input < min ? min : Math.min(input, max);
    }

    public static long constrain(long input, long min, long max) {
        return input < min ? min : Math.min(input, max);
    }

    public static double constrain(double input, double min, double max) {
        return input < min ? min : Math.min(input, max);
    }

    public static boolean startsWith(String[] array, String obj) {
        for (String element : array) {
            if (!element.startsWith(obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String[] array, String obj, boolean ignoreCase) {
        for (String element : array) {
            if (!element.equals(obj) && (!ignoreCase || !element.equalsIgnoreCase(obj))) continue;
            return true;
        }
        return false;
    }
}

