/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.commons;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bitlet.weupnp.GatewayDevice;
import org.bitlet.weupnp.GatewayDiscover;
import org.bitlet.weupnp.PortMappingEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class UPnPService {
    private static final Logger LOG = LoggerFactory.getLogger(UPnPService.class);
    private static final String PROTOCOL = "TCP";
    private final GatewayDiscover _gatewayDiscover = new GatewayDiscover();
    private GatewayDevice _activeGW;
    private final Set<Integer> ports = new HashSet<Integer>();

    protected UPnPService() {
    }

    public void load(int port, String description) {
        try {
            LOG.info("Looking for UPnP Gateway Devices...");
            Map gateways = this._gatewayDiscover.discover();
            if (gateways.isEmpty()) {
                LOG.info("No UPnP gateways has been found.");
                return;
            }
            this._activeGW = this._gatewayDiscover.getValidGateway();
            if (this._activeGW == null) {
                LOG.info("No active UPnP gateway found.");
                return;
            }
            LOG.info("Using UPnP gateway: {}", (Object)this._activeGW.getFriendlyName());
            LOG.info("Using local address: {} External address: {}", (Object)this._activeGW.getLocalAddress().getHostAddress(), (Object)this._activeGW.getExternalIPAddress());
            this.addPortMapping(port, description);
        }
        catch (Exception ex) {
            LOG.warn("There has been an error loading {}[{}]!", new Object[]{description, port, ex});
        }
    }

    public void removeAllPorts() {
        if (this._activeGW != null) {
            this.ports.forEach(this::deletePortMapping);
        }
    }

    private void addPortMapping(int port, String description) throws IOException, SAXException {
        PortMappingEntry portMapping = new PortMappingEntry();
        InetAddress localAddress = this._activeGW.getLocalAddress();
        if (this._activeGW.getSpecificPortMappingEntry(port, PROTOCOL, portMapping)) {
            this._activeGW.deletePortMapping(port, PROTOCOL);
        }
        if (this._activeGW.addPortMapping(port, port, localAddress.getHostAddress(), PROTOCOL, description)) {
            LOG.info("Mapping successful on {}:{}", (Object)localAddress.getHostAddress(), (Object)port);
            this.ports.add(port);
        } else {
            LOG.info("Mapping failed on [{}:{}] - Already mapped?", (Object)localAddress.getHostAddress(), (Object)port);
        }
    }

    private void deletePortMapping(int port) {
        try {
            if (this._activeGW.deletePortMapping(port, PROTOCOL)) {
                LOG.info("Mapping was deleted from [{}:{}]", (Object)this._activeGW.getLocalAddress().getHostAddress(), (Object)port);
            }
        }
        catch (Exception ex) {
            LOG.warn("There has been an error removing port {} from UPnP!", (Object)port, (Object)ex);
        }
    }

    public static UPnPService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final UPnPService INSTANCE = new UPnPService();

        private SingletonHolder() {
        }
    }
}

