/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.commons.util;

import com.l2jserver.mmocore.AcceptFilter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPv4Filter
implements AcceptFilter,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(IPv4Filter.class);
    private static final long SLEEP_TIME = 5000L;
    private final Map<Integer, Flood> _ipFloodMap = new HashMap<Integer, Flood>();

    public IPv4Filter() {
        Thread t = new Thread((Runnable)this, this.getClass().getSimpleName());
        t.setDaemon(true);
        t.start();
    }

    private static int hash(byte[] ip) {
        return ip[0] & 0xFF | ip[1] << 8 & 0xFF00 | ip[2] << 16 & 0xFF0000 | ip[3] << 24 & 0xFF000000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(SocketChannel sc) {
        Flood f;
        InetAddress addr = sc.socket().getInetAddress();
        if (!(addr instanceof Inet4Address)) {
            LOG.warn("Someone tried to connect from something other than IPv4 {}!", (Object)addr.getHostAddress());
            return false;
        }
        int h = IPv4Filter.hash(addr.getAddress());
        long current = System.currentTimeMillis();
        Map<Integer, Flood> map = this._ipFloodMap;
        synchronized (map) {
            f = this._ipFloodMap.get(h);
        }
        if (f != null) {
            if (f.trys == -1) {
                f.lastAccess = current;
                return false;
            }
            if (f.lastAccess + 1000L > current) {
                f.lastAccess = current;
                if (f.trys >= 3) {
                    f.trys = -1;
                    return false;
                }
                ++f.trys;
            } else {
                f.lastAccess = current;
            }
        } else {
            map = this._ipFloodMap;
            synchronized (map) {
                this._ipFloodMap.put(h, new Flood());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            long reference = System.currentTimeMillis() - 300000L;
            Map<Integer, Flood> map = this._ipFloodMap;
            synchronized (map) {
                Iterator<Map.Entry<Integer, Flood>> it = this._ipFloodMap.entrySet().iterator();
                while (it.hasNext()) {
                    Flood f = it.next().getValue();
                    if (f.lastAccess >= reference) continue;
                    it.remove();
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    protected static final class Flood {
        long lastAccess = System.currentTimeMillis();
        int trys = 0;

        Flood() {
        }
    }
}

