/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.DoorData;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.util.GeoUtils;
import com.l2jserver.gameserver.util.LinePointIterator;
import com.l2jserver.gameserver.util.LinePointIterator3D;
import com.l2jserver.geodriver.GeoDriver;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoData {
    private static final Logger LOG = LoggerFactory.getLogger(GeoData.class);
    private static final String FILE_NAME_FORMAT = "%d_%d.l2j";
    private static final int ELEVATED_SEE_OVER_DISTANCE = 2;
    private static final int MAX_SEE_OVER_HEIGHT = 48;
    private static final int SPAWN_Z_DELTA_LIMIT = 100;
    private static final Map<String, Boolean> GEODATA_REGIONS = new HashMap<String, Boolean>();
    private final GeoDriver _driver = new GeoDriver();

    protected GeoData() {
        GeoData.loadGeodataRegions();
        int loadedRegions = 0;
        try {
            for (int regionX = 11; regionX <= 26; ++regionX) {
                for (int regionY = 10; regionY <= 26; ++regionY) {
                    Path geoFilePath = Configuration.geodata().getGeoDataPath().toPath().resolve(String.format(FILE_NAME_FORMAT, regionX, regionY));
                    Boolean loadFile = GEODATA_REGIONS.get(regionX + "_" + regionY);
                    if (loadFile != null) {
                        if (!loadFile.booleanValue()) continue;
                        LOG.info("Loading {}...", (Object)geoFilePath.getFileName());
                        this._driver.loadRegion(geoFilePath, regionX, regionY);
                        ++loadedRegions;
                        continue;
                    }
                    if (!Configuration.geodata().tryLoadUnspecifiedRegions() || !Files.exists(geoFilePath, new LinkOption[0])) continue;
                    try {
                        LOG.info("Loading {}...", (Object)geoFilePath.getFileName());
                        this._driver.loadRegion(geoFilePath, regionX, regionY);
                        ++loadedRegions;
                        continue;
                    }
                    catch (Exception ex) {
                        LOG.warn("Failed to load {}!", (Object)geoFilePath.getFileName(), (Object)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to load geodata!", ex);
            System.exit(1);
        }
        LOG.info("Loaded {} regions.", (Object)loadedRegions);
    }

    private static void loadGeodataRegions() {
        for (int regionX = 11; regionX <= 26; ++regionX) {
            for (int regionY = 10; regionY <= 26; ++regionY) {
                String key = regionX + "_" + regionY;
                if (Configuration.geodata().getIncludedRegions().contains(regionX + "_" + regionY)) {
                    GEODATA_REGIONS.put(key, true);
                    continue;
                }
                if (!Configuration.geodata().getExcludedRegions().contains(regionX + "_" + regionY)) continue;
                GEODATA_REGIONS.put(key, false);
            }
        }
    }

    public boolean hasGeoPos(int geoX, int geoY) {
        return this._driver.hasGeoPos(geoX, geoY);
    }

    public boolean checkNearestNswe(int geoX, int geoY, int worldZ, int nswe) {
        return this._driver.checkNearestNswe(geoX, geoY, worldZ, nswe);
    }

    public boolean checkNearestNsweAntiCornerCut(int geoX, int geoY, int worldZ, int nswe) {
        boolean can = true;
        if ((nswe & 9) == 9) {
            boolean bl = can = this.checkNearestNswe(geoX, geoY - 1, worldZ, 1) && this.checkNearestNswe(geoX + 1, geoY, worldZ, 8);
        }
        if (can && (nswe & 0xA) == 10) {
            boolean bl = can = this.checkNearestNswe(geoX, geoY - 1, worldZ, 2) && this.checkNearestNswe(geoX, geoY - 1, worldZ, 8);
        }
        if (can && (nswe & 5) == 5) {
            boolean bl = can = this.checkNearestNswe(geoX, geoY + 1, worldZ, 1) && this.checkNearestNswe(geoX + 1, geoY, worldZ, 4);
        }
        if (can && (nswe & 6) == 6) {
            can = this.checkNearestNswe(geoX, geoY + 1, worldZ, 2) && this.checkNearestNswe(geoX - 1, geoY, worldZ, 4);
        }
        return can && this.checkNearestNswe(geoX, geoY, worldZ, nswe);
    }

    public int getNearestZ(int geoX, int geoY, int worldZ) {
        return this._driver.getNearestZ(geoX, geoY, worldZ);
    }

    public int getNextLowerZ(int geoX, int geoY, int worldZ) {
        return this._driver.getNextLowerZ(geoX, geoY, worldZ);
    }

    public int getNextHigherZ(int geoX, int geoY, int worldZ) {
        return this._driver.getNextHigherZ(geoX, geoY, worldZ);
    }

    public int getGeoX(int worldX) {
        return this._driver.getGeoX(worldX);
    }

    public int getGeoY(int worldY) {
        return this._driver.getGeoY(worldY);
    }

    public int getWorldX(int geoX) {
        return this._driver.getWorldX(geoX);
    }

    public int getWorldY(int geoY) {
        return this._driver.getWorldY(geoY);
    }

    public int getHeight(int x, int y, int z) {
        return this.getNearestZ(this.getGeoX(x), this.getGeoY(y), z);
    }

    public int getSpawnHeight(int x, int y, int z) {
        int geoY;
        int geoX = this.getGeoX(x);
        if (!this.hasGeoPos(geoX, geoY = this.getGeoY(y))) {
            return z;
        }
        int nextLowerZ = this.getNextLowerZ(geoX, geoY, z + 20);
        return Math.abs(nextLowerZ - z) <= 100 ? nextLowerZ : z;
    }

    public int getSpawnHeight(Location location) {
        return this.getSpawnHeight(location.getX(), location.getY(), location.getZ());
    }

    public boolean canSeeTarget(L2Object cha, L2Object target) {
        if (target == null) {
            return false;
        }
        if (target.isDoor()) {
            return true;
        }
        return this.canSeeTarget(cha.getX(), cha.getY(), cha.getZ(), cha.getInstanceId(), target.getX(), target.getY(), target.getZ(), target.getInstanceId());
    }

    public boolean canSeeTarget(L2Object cha, ILocational worldPosition) {
        return this.canSeeTarget(cha.getX(), cha.getY(), cha.getZ(), cha.getInstanceId(), worldPosition.getX(), worldPosition.getY(), worldPosition.getZ());
    }

    public boolean canSeeTarget(int x, int y, int z, int instanceId, int tx, int ty, int tz, int tInstanceId) {
        if (instanceId != tInstanceId) {
            return false;
        }
        return this.canSeeTarget(x, y, z, instanceId, tx, ty, tz);
    }

    public boolean canSeeTarget(int x, int y, int z, int instanceId, int tx, int ty, int tz) {
        if (DoorData.getInstance().checkIfDoorsBetween(x, y, z, tx, ty, tz, instanceId, true)) {
            return false;
        }
        return this.canSeeTarget(x, y, z, tx, ty, tz);
    }

    private int getLosGeoZ(int prevX, int prevY, int prevGeoZ, int curX, int curY, int nswe) {
        if ((nswe & 8) != 0 && (nswe & 4) != 0 || (nswe & 2) != 0 && (nswe & 1) != 0) {
            throw new RuntimeException("Multiple directions!");
        }
        if (this.checkNearestNsweAntiCornerCut(prevX, prevY, prevGeoZ, nswe)) {
            return this.getNearestZ(curX, curY, prevGeoZ);
        }
        return this.getNextHigherZ(curX, curY, prevGeoZ);
    }

    public boolean canSeeTarget(int x, int y, int z, int tx, int ty, int tz) {
        int prevZ;
        int geoX = this.getGeoX(x);
        int geoY = this.getGeoY(y);
        int tGeoX = this.getGeoX(tx);
        int tGeoY = this.getGeoY(ty);
        z = this.getNearestZ(geoX, geoY, z);
        tz = this.getNearestZ(tGeoX, tGeoY, tz);
        if (geoX == tGeoX && geoY == tGeoY) {
            if (this.hasGeoPos(tGeoX, tGeoY)) {
                return z == tz;
            }
            return true;
        }
        if (tz > z) {
            int tmp = tx;
            tx = x;
            x = tmp;
            tmp = ty;
            ty = y;
            y = tmp;
            tmp = tz;
            tz = z;
            z = tmp;
            tmp = tGeoX;
            tGeoX = geoX;
            geoX = tmp;
            tmp = tGeoY;
            tGeoY = geoY;
            geoY = tmp;
        }
        LinePointIterator3D pointIter = new LinePointIterator3D(geoX, geoY, z, tGeoX, tGeoY, tz);
        pointIter.next();
        int prevX = pointIter.x();
        int prevY = pointIter.y();
        int prevGeoZ = prevZ = pointIter.z();
        int ptIndex = 0;
        while (pointIter.next()) {
            int curX = pointIter.x();
            int curY = pointIter.y();
            if (curX == prevX && curY == prevY) continue;
            int beeCurZ = pointIter.z();
            int curGeoZ = prevGeoZ;
            if (this.hasGeoPos(curX, curY)) {
                int nswe = GeoUtils.computeNswe(prevX, prevY, curX, curY);
                curGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, curX, curY, nswe);
                int maxHeight = ptIndex < 2 ? z + 48 : beeCurZ + 48;
                boolean canSeeThrough = false;
                if (curGeoZ <= maxHeight) {
                    if ((nswe & 9) == 9) {
                        northGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, prevX, prevY - 1, 1);
                        eastGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, prevX + 1, prevY, 8);
                        canSeeThrough = northGeoZ <= maxHeight && eastGeoZ <= maxHeight && northGeoZ <= this.getNearestZ(prevX, prevY - 1, beeCurZ) && eastGeoZ <= this.getNearestZ(prevX + 1, prevY, beeCurZ);
                    } else if ((nswe & 0xA) == 10) {
                        northGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, prevX, prevY - 1, 2);
                        westGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, prevX - 1, prevY, 8);
                        canSeeThrough = northGeoZ <= maxHeight && westGeoZ <= maxHeight && northGeoZ <= this.getNearestZ(prevX, prevY - 1, beeCurZ) && westGeoZ <= this.getNearestZ(prevX - 1, prevY, beeCurZ);
                    } else if ((nswe & 5) == 5) {
                        southGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, prevX, prevY + 1, 1);
                        eastGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, prevX + 1, prevY, 4);
                        canSeeThrough = southGeoZ <= maxHeight && eastGeoZ <= maxHeight && southGeoZ <= this.getNearestZ(prevX, prevY + 1, beeCurZ) && eastGeoZ <= this.getNearestZ(prevX + 1, prevY, beeCurZ);
                    } else if ((nswe & 6) == 6) {
                        southGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, prevX, prevY + 1, 2);
                        westGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, prevX - 1, prevY, 4);
                        canSeeThrough = southGeoZ <= maxHeight && westGeoZ <= maxHeight && southGeoZ <= this.getNearestZ(prevX, prevY + 1, beeCurZ) && westGeoZ <= this.getNearestZ(prevX - 1, prevY, beeCurZ);
                    } else {
                        canSeeThrough = true;
                    }
                }
                if (!canSeeThrough) {
                    return false;
                }
            }
            prevX = curX;
            prevY = curY;
            prevGeoZ = curGeoZ;
            ++ptIndex;
        }
        return true;
    }

    public Location moveCheck(ILocational origin, ILocational destination) {
        return this.moveCheck(origin.getX(), origin.getY(), origin.getZ(), destination.getX(), destination.getY(), destination.getZ(), origin.getInstanceId());
    }

    public Location moveCheck(int x, int y, int z, int tx, int ty, int tz, int instanceId) {
        int geoX = this.getGeoX(x);
        int geoY = this.getGeoY(y);
        z = this.getNearestZ(geoX, geoY, z);
        int tGeoX = this.getGeoX(tx);
        int tGeoY = this.getGeoY(ty);
        tz = this.getNearestZ(tGeoX, tGeoY, tz);
        if (DoorData.getInstance().checkIfDoorsBetween(x, y, z, tx, ty, tz, instanceId, false)) {
            return new Location(x, y, this.getHeight(x, y, z));
        }
        LinePointIterator pointIter = new LinePointIterator(geoX, geoY, tGeoX, tGeoY);
        pointIter.next();
        int prevX = pointIter.x();
        int prevY = pointIter.y();
        int prevZ = z;
        while (pointIter.next()) {
            int nswe;
            int curX = pointIter.x();
            int curY = pointIter.y();
            int curZ = this.getNearestZ(curX, curY, prevZ);
            if (this.hasGeoPos(prevX, prevY) && !this.checkNearestNsweAntiCornerCut(prevX, prevY, prevZ, nswe = GeoUtils.computeNswe(prevX, prevY, curX, curY))) {
                return new Location(this.getWorldX(prevX), this.getWorldY(prevY), prevZ);
            }
            prevX = curX;
            prevY = curY;
            prevZ = curZ;
        }
        if (this.hasGeoPos(prevX, prevY) && prevZ != tz) {
            return new Location(x, y, z);
        }
        return new Location(tx, ty, tz);
    }

    public boolean canMove(int fromX, int fromY, int fromZ, int toX, int toY, int toZ, int instanceId) {
        int geoX = this.getGeoX(fromX);
        int geoY = this.getGeoY(fromY);
        fromZ = this.getNearestZ(geoX, geoY, fromZ);
        int tGeoX = this.getGeoX(toX);
        int tGeoY = this.getGeoY(toY);
        toZ = this.getNearestZ(tGeoX, tGeoY, toZ);
        if (DoorData.getInstance().checkIfDoorsBetween(fromX, fromY, fromZ, toX, toY, toZ, instanceId, false)) {
            return false;
        }
        LinePointIterator pointIter = new LinePointIterator(geoX, geoY, tGeoX, tGeoY);
        pointIter.next();
        int prevX = pointIter.x();
        int prevY = pointIter.y();
        int prevZ = fromZ;
        while (pointIter.next()) {
            int nswe;
            int curX = pointIter.x();
            int curY = pointIter.y();
            int curZ = this.getNearestZ(curX, curY, prevZ);
            if (this.hasGeoPos(prevX, prevY) && !this.checkNearestNsweAntiCornerCut(prevX, prevY, prevZ, nswe = GeoUtils.computeNswe(prevX, prevY, curX, curY))) {
                return false;
            }
            prevX = curX;
            prevY = curY;
            prevZ = curZ;
        }
        return !this.hasGeoPos(prevX, prevY) || prevZ == toZ;
    }

    public int traceTerrainZ(int x, int y, int z, int tx, int ty) {
        int geoX = this.getGeoX(x);
        int geoY = this.getGeoY(y);
        z = this.getNearestZ(geoX, geoY, z);
        int tGeoX = this.getGeoX(tx);
        int tGeoY = this.getGeoY(ty);
        LinePointIterator pointIter = new LinePointIterator(geoX, geoY, tGeoX, tGeoY);
        pointIter.next();
        int prevZ = z;
        while (pointIter.next()) {
            int curZ;
            int curX = pointIter.x();
            int curY = pointIter.y();
            prevZ = curZ = this.getNearestZ(curX, curY, prevZ);
        }
        return prevZ;
    }

    public boolean canMove(ILocational from, int toX, int toY, int toZ) {
        return this.canMove(from.getX(), from.getY(), from.getZ(), toX, toY, toZ, from.getInstanceId());
    }

    public boolean canMove(ILocational from, ILocational to) {
        return this.canMove(from, to.getX(), to.getY(), to.getZ());
    }

    public boolean hasGeo(int x, int y) {
        return this.hasGeoPos(this.getGeoX(x), this.getGeoY(y));
    }

    public static GeoData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final GeoData INSTANCE = new GeoData();

        private SingletonHolder() {
        }
    }
}

