/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.AutoSpawnHandler;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SSQInfo;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Broadcast;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SevenSigns {
    private static final Logger LOG = LoggerFactory.getLogger(SevenSigns.class);
    public static final String SEVEN_SIGNS_HTML_PATH = "data/html/seven_signs/";
    public static final int CABAL_NULL = 0;
    public static final int CABAL_DUSK = 1;
    public static final int CABAL_DAWN = 2;
    public static final int SEAL_NULL = 0;
    public static final int SEAL_AVARICE = 1;
    public static final int SEAL_GNOSIS = 2;
    public static final int SEAL_STRIFE = 3;
    public static final int PERIOD_COMP_RECRUITING = 0;
    public static final int PERIOD_COMPETITION = 1;
    public static final int PERIOD_COMP_RESULTS = 2;
    public static final int PERIOD_SEAL_VALIDATION = 3;
    public static final int PERIOD_START_HOUR = 18;
    public static final int PERIOD_START_MINS = 0;
    public static final int PERIOD_START_DAY = 2;
    public static final int PERIOD_MINOR_LENGTH = 900000;
    public static final int PERIOD_MAJOR_LENGTH = 603900000;
    public static final int RECORD_SEVEN_SIGNS_ID = 5707;
    public static final int RECORD_SEVEN_SIGNS_COST = 500;
    public static final int ORATOR_NPC_ID = 31094;
    public static final int PREACHER_NPC_ID = 31093;
    public static final int MAMMON_MERCHANT_ID = 31113;
    public static final int MAMMON_BLACKSMITH_ID = 31126;
    public static final int MAMMON_MARKETEER_ID = 31092;
    public static final int LILITH_NPC_ID = 25283;
    public static final int ANAKIM_NPC_ID = 25286;
    public static final int CREST_OF_DAWN_ID = 31170;
    public static final int CREST_OF_DUSK_ID = 31171;
    public static final int SEAL_STONE_BLUE_ID = 6360;
    public static final int SEAL_STONE_GREEN_ID = 6361;
    public static final int SEAL_STONE_RED_ID = 6362;
    public static final int[] SEAL_STONE_IDS = new int[]{6360, 6361, 6362};
    public static final int SEAL_STONE_BLUE_VALUE = 3;
    public static final int SEAL_STONE_GREEN_VALUE = 5;
    public static final int SEAL_STONE_RED_VALUE = 10;
    public static final int BLUE_CONTRIB_POINTS = 3;
    public static final int GREEN_CONTRIB_POINTS = 5;
    public static final int RED_CONTRIB_POINTS = 10;
    private final Calendar _nextPeriodChange = Calendar.getInstance();
    protected int _activePeriod;
    protected int _currentCycle;
    protected double _dawnStoneScore;
    protected double _duskStoneScore;
    protected int _dawnFestivalScore;
    protected int _duskFestivalScore;
    protected int _compWinner;
    protected int _previousWinner;
    protected Calendar _lastSave = Calendar.getInstance();
    protected Map<Integer, StatsSet> _signsPlayerData = new LinkedHashMap<Integer, StatsSet>();
    private final Map<Integer, Integer> _signsSealOwners = new LinkedHashMap<Integer, Integer>();
    private final Map<Integer, Integer> _signsDuskSealTotals = new LinkedHashMap<Integer, Integer>();
    private final Map<Integer, Integer> _signsDawnSealTotals = new LinkedHashMap<Integer, Integer>();
    private static final String LOAD_DATA = "SELECT charId, cabal, seal, position, paid_type, red_stones, green_stones, blue_stones, ancient_adena_amount, contribution_score FROM seven_signs";
    private static final String LOAD_STATUS = "SELECT * FROM seven_signs_status WHERE id=0";
    private static final String INSERT_PLAYER = "INSERT INTO seven_signs (charId, cabal, seal, position, paid_type) VALUES (?,?,?,?,?)";
    private static final String UPDATE_PLAYER = "UPDATE seven_signs SET cabal=?, seal=?, position=?, paid_type=?, red_stones=?, green_stones=?, blue_stones=?, ancient_adena_amount=?, contribution_score=? WHERE charId=?";
    private static final String UPDATE_STATUS = "UPDATE seven_signs_status SET current_cycle=?, active_period=?, previous_winner=?, dawn_stone_score=?, dawn_festival_score=?, dusk_stone_score=?, dusk_festival_score=?, avarice_owner=?, gnosis_owner=?, strife_owner=?, avarice_dawn_score=?, gnosis_dawn_score=?, strife_dawn_score=?, avarice_dusk_score=?, gnosis_dusk_score=?, strife_dusk_score=?, festival_cycle=?, accumulated_bonus0=?, accumulated_bonus1=?, accumulated_bonus2=?,accumulated_bonus3=?, accumulated_bonus4=?, date=? WHERE id=0";

    protected SevenSigns() {
        try {
            this.restoreSevenSignsData();
        }
        catch (Exception ex) {
            LOG.error("Failed to load configuration!", ex);
        }
        LOG.info("Currently in the {} period.", (Object)this.getCurrentPeriodName());
        this.initializeSeals();
        if (this.isSealValidationPeriod()) {
            if (this.getCabalHighestScore() == 0) {
                LOG.info("The competition ended with a tie last week.");
            } else {
                LOG.info("The {} were victorious last week.", (Object)SevenSigns.getCabalName(this.getCabalHighestScore()));
            }
        } else if (this.getCabalHighestScore() == 0) {
            LOG.info("The competition, if the current trend continues, will end in a tie this week.");
        } else {
            LOG.info("The {} are in the lead this week.", (Object)SevenSigns.getCabalName(this.getCabalHighestScore()));
        }
        long milliToChange = 0L;
        if (this.isNextPeriodChangeInPast()) {
            LOG.info("Next period change was in the past (server was offline), changing periods now!");
        } else {
            this.setCalendarForNextPeriodChange();
            milliToChange = this.getMilliToPeriodChange();
        }
        SevenSignsPeriodChange sspc = new SevenSignsPeriodChange();
        ThreadPoolManager.getInstance().scheduleGeneral(sspc, milliToChange);
        double numSecs = milliToChange / 1000L % 60L;
        double countDown = ((double)milliToChange / 1000.0 - numSecs) / 60.0;
        int numMins = (int)Math.floor(countDown % 60.0);
        countDown = (countDown - (double)numMins) / 60.0;
        int numHours = (int)Math.floor(countDown % 24.0);
        int numDays = (int)Math.floor((countDown - (double)numHours) / 24.0);
        LOG.info("Next period begins in {} days, {} hours and {} mins.", numDays, numHours, numMins);
    }

    private boolean isNextPeriodChangeInPast() {
        Calendar lastPeriodChange = Calendar.getInstance();
        switch (this.getCurrentPeriod()) {
            case 1: 
            case 3: {
                lastPeriodChange.set(7, 2);
                lastPeriodChange.set(11, 18);
                lastPeriodChange.set(12, 0);
                lastPeriodChange.set(13, 0);
                if (!Calendar.getInstance().before(lastPeriodChange)) break;
                lastPeriodChange.add(10, -168);
                break;
            }
            case 0: 
            case 2: {
                lastPeriodChange.setTimeInMillis(this._lastSave.getTimeInMillis() + 900000L);
            }
        }
        return this._lastSave.getTimeInMillis() > 7L && this._lastSave.before(lastPeriodChange);
    }

    public void spawnSevenSignsNPC() {
        block30: {
            List<AutoSpawnHandler.AutoSpawnInstance> marketeerSpawns;
            List<AutoSpawnHandler.AutoSpawnInstance> preacherSpawns;
            List<AutoSpawnHandler.AutoSpawnInstance> oratorSpawns;
            List<AutoSpawnHandler.AutoSpawnInstance> crestOfDuskSpawns;
            List<AutoSpawnHandler.AutoSpawnInstance> crestOfDawnSpawns;
            AutoSpawnHandler.AutoSpawnInstance anakimSpawn;
            AutoSpawnHandler.AutoSpawnInstance lilithSpawn;
            AutoSpawnHandler.AutoSpawnInstance blacksmithSpawn;
            AutoSpawnHandler.AutoSpawnInstance merchantSpawn;
            block28: {
                block29: {
                    merchantSpawn = AutoSpawnHandler.getInstance().getAutoSpawnInstance(31113, false);
                    blacksmithSpawn = AutoSpawnHandler.getInstance().getAutoSpawnInstance(31126, false);
                    lilithSpawn = AutoSpawnHandler.getInstance().getAutoSpawnInstance(25283, false);
                    anakimSpawn = AutoSpawnHandler.getInstance().getAutoSpawnInstance(25286, false);
                    crestOfDawnSpawns = AutoSpawnHandler.getInstance().getAutoSpawnInstances(31170);
                    crestOfDuskSpawns = AutoSpawnHandler.getInstance().getAutoSpawnInstances(31171);
                    oratorSpawns = AutoSpawnHandler.getInstance().getAutoSpawnInstances(31094);
                    preacherSpawns = AutoSpawnHandler.getInstance().getAutoSpawnInstances(31093);
                    marketeerSpawns = AutoSpawnHandler.getInstance().getAutoSpawnInstances(31092);
                    if (!this.isSealValidationPeriod() && !this.isCompResultsPeriod()) break block28;
                    for (AutoSpawnHandler.AutoSpawnInstance spawnInst : marketeerSpawns) {
                        AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, true);
                    }
                    if (this.getSealOwner(2) == this.getCabalHighestScore() && this.getSealOwner(2) != 0) {
                        if (!Configuration.npc().announceMammonSpawn()) {
                            blacksmithSpawn.setBroadcast(false);
                        }
                        if (!AutoSpawnHandler.getInstance().getAutoSpawnInstance(blacksmithSpawn.getObjectId(), true).isSpawnActive()) {
                            AutoSpawnHandler.getInstance().setSpawnActive(blacksmithSpawn, true);
                        }
                        for (AutoSpawnHandler.AutoSpawnInstance spawnInst : oratorSpawns) {
                            if (AutoSpawnHandler.getInstance().getAutoSpawnInstance(spawnInst.getObjectId(), true).isSpawnActive()) continue;
                            AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, true);
                        }
                        for (AutoSpawnHandler.AutoSpawnInstance spawnInst : preacherSpawns) {
                            if (AutoSpawnHandler.getInstance().getAutoSpawnInstance(spawnInst.getObjectId(), true).isSpawnActive()) continue;
                            AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, true);
                        }
                    } else {
                        AutoSpawnHandler.getInstance().setSpawnActive(blacksmithSpawn, false);
                        for (AutoSpawnHandler.AutoSpawnInstance spawnInst : oratorSpawns) {
                            AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, false);
                        }
                        for (AutoSpawnHandler.AutoSpawnInstance spawnInst : preacherSpawns) {
                            AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, false);
                        }
                    }
                    if (this.getSealOwner(1) != this.getCabalHighestScore() || this.getSealOwner(1) == 0) break block29;
                    if (!Configuration.npc().announceMammonSpawn()) {
                        merchantSpawn.setBroadcast(false);
                    }
                    if (!AutoSpawnHandler.getInstance().getAutoSpawnInstance(merchantSpawn.getObjectId(), true).isSpawnActive()) {
                        AutoSpawnHandler.getInstance().setSpawnActive(merchantSpawn, true);
                    }
                    switch (this.getCabalHighestScore()) {
                        case 2: {
                            if (!AutoSpawnHandler.getInstance().getAutoSpawnInstance(lilithSpawn.getObjectId(), true).isSpawnActive()) {
                                AutoSpawnHandler.getInstance().setSpawnActive(lilithSpawn, true);
                            }
                            AutoSpawnHandler.getInstance().setSpawnActive(anakimSpawn, false);
                            for (AutoSpawnHandler.AutoSpawnInstance dawnCrest : crestOfDawnSpawns) {
                                if (AutoSpawnHandler.getInstance().getAutoSpawnInstance(dawnCrest.getObjectId(), true).isSpawnActive()) continue;
                                AutoSpawnHandler.getInstance().setSpawnActive(dawnCrest, true);
                            }
                            for (AutoSpawnHandler.AutoSpawnInstance duskCrest : crestOfDuskSpawns) {
                                AutoSpawnHandler.getInstance().setSpawnActive(duskCrest, false);
                            }
                            break block30;
                        }
                        case 1: {
                            if (!AutoSpawnHandler.getInstance().getAutoSpawnInstance(anakimSpawn.getObjectId(), true).isSpawnActive()) {
                                AutoSpawnHandler.getInstance().setSpawnActive(anakimSpawn, true);
                            }
                            AutoSpawnHandler.getInstance().setSpawnActive(lilithSpawn, false);
                            for (AutoSpawnHandler.AutoSpawnInstance duskCrest : crestOfDuskSpawns) {
                                if (AutoSpawnHandler.getInstance().getAutoSpawnInstance(duskCrest.getObjectId(), true).isSpawnActive()) continue;
                                AutoSpawnHandler.getInstance().setSpawnActive(duskCrest, true);
                            }
                            for (AutoSpawnHandler.AutoSpawnInstance dawnCrest : crestOfDawnSpawns) {
                                AutoSpawnHandler.getInstance().setSpawnActive(dawnCrest, false);
                            }
                            break;
                        }
                    }
                    break block30;
                }
                AutoSpawnHandler.getInstance().setSpawnActive(merchantSpawn, false);
                AutoSpawnHandler.getInstance().setSpawnActive(lilithSpawn, false);
                AutoSpawnHandler.getInstance().setSpawnActive(anakimSpawn, false);
                for (AutoSpawnHandler.AutoSpawnInstance dawnCrest : crestOfDawnSpawns) {
                    AutoSpawnHandler.getInstance().setSpawnActive(dawnCrest, false);
                }
                for (AutoSpawnHandler.AutoSpawnInstance duskCrest : crestOfDuskSpawns) {
                    AutoSpawnHandler.getInstance().setSpawnActive(duskCrest, false);
                }
                break block30;
            }
            AutoSpawnHandler.getInstance().setSpawnActive(merchantSpawn, false);
            AutoSpawnHandler.getInstance().setSpawnActive(blacksmithSpawn, false);
            AutoSpawnHandler.getInstance().setSpawnActive(lilithSpawn, false);
            AutoSpawnHandler.getInstance().setSpawnActive(anakimSpawn, false);
            for (AutoSpawnHandler.AutoSpawnInstance dawnCrest : crestOfDawnSpawns) {
                AutoSpawnHandler.getInstance().setSpawnActive(dawnCrest, false);
            }
            for (AutoSpawnHandler.AutoSpawnInstance duskCrest : crestOfDuskSpawns) {
                AutoSpawnHandler.getInstance().setSpawnActive(duskCrest, false);
            }
            for (AutoSpawnHandler.AutoSpawnInstance spawnInst : oratorSpawns) {
                AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, false);
            }
            for (AutoSpawnHandler.AutoSpawnInstance spawnInst : preacherSpawns) {
                AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, false);
            }
            for (AutoSpawnHandler.AutoSpawnInstance spawnInst : marketeerSpawns) {
                AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, false);
            }
        }
    }

    public static String getCabalShortName(int cabal) {
        return switch (cabal) {
            case 2 -> "dawn";
            case 1 -> "dusk";
            default -> "No Cabal";
        };
    }

    public static String getCabalName(int cabal) {
        return switch (cabal) {
            case 2 -> "Lords of Dawn";
            case 1 -> "Revolutionaries of Dusk";
            default -> "No Cabal";
        };
    }

    public static String getSealName(int seal, boolean shortName) {
        Object sealName = !shortName ? "Seal of " : "";
        switch (seal) {
            case 1: {
                sealName = (String)sealName + "Avarice";
                break;
            }
            case 2: {
                sealName = (String)sealName + "Gnosis";
                break;
            }
            case 3: {
                sealName = (String)sealName + "Strife";
            }
        }
        return sealName;
    }

    public final int getCurrentCycle() {
        return this._currentCycle;
    }

    public final int getCurrentPeriod() {
        return this._activePeriod;
    }

    private int getDaysToPeriodChange() {
        int numDays = this._nextPeriodChange.get(7) - 2;
        if (numDays < 0) {
            return -numDays;
        }
        return 7 - numDays;
    }

    public final long getMilliToPeriodChange() {
        return this._nextPeriodChange.getTimeInMillis() - System.currentTimeMillis();
    }

    protected void setCalendarForNextPeriodChange() {
        switch (this.getCurrentPeriod()) {
            case 1: 
            case 3: {
                int daysToChange = this.getDaysToPeriodChange();
                if (daysToChange == 7) {
                    if (this._nextPeriodChange.get(11) < 18) {
                        daysToChange = 0;
                    } else if (this._nextPeriodChange.get(11) == 18 && this._nextPeriodChange.get(12) < 0) {
                        daysToChange = 0;
                    }
                }
                if (daysToChange > 0) {
                    this._nextPeriodChange.add(5, daysToChange);
                }
                this._nextPeriodChange.set(11, 18);
                this._nextPeriodChange.set(12, 0);
                break;
            }
            case 0: 
            case 2: {
                this._nextPeriodChange.add(14, 900000);
            }
        }
        LOG.info("Next period change set to {}.", (Object)this._nextPeriodChange.getTime());
    }

    public final String getCurrentPeriodName() {
        return switch (this._activePeriod) {
            case 0 -> "Quest Event Initialization";
            case 1 -> "Competition (Quest Event)";
            case 2 -> "Quest Event Results";
            case 3 -> "Seal Validation";
            default -> null;
        };
    }

    public final boolean isCompetitionPeriod() {
        return this._activePeriod == 1;
    }

    public final boolean isSealValidationPeriod() {
        return this._activePeriod == 3;
    }

    public final boolean isCompResultsPeriod() {
        return this._activePeriod == 2;
    }

    public final boolean isInitializationPeriod() {
        return this._activePeriod == 0;
    }

    public boolean isJoinableToDawn(L2PcInstance player) {
        return player.getClan() != null && player.getClan().getCastleId() > 0;
    }

    public boolean isDateInSealValidPeriod(Calendar date) {
        long tillDate;
        long nextPeriodChange = this.getMilliToPeriodChange();
        long nextQuestStart = 0L;
        long nextValidStart = 0L;
        for (tillDate = date.getTimeInMillis() - Calendar.getInstance().getTimeInMillis(); 1209600000L < tillDate; tillDate -= 1209600000L) {
        }
        while (tillDate < 0L) {
            tillDate += 1209600000L;
        }
        switch (this.getCurrentPeriod()) {
            case 0: {
                nextValidStart = nextPeriodChange + 603900000L;
                nextQuestStart = nextValidStart + 603900000L + 900000L;
                break;
            }
            case 1: {
                nextValidStart = nextPeriodChange;
                nextQuestStart = nextPeriodChange + 603900000L + 900000L;
                break;
            }
            case 2: {
                nextQuestStart = nextPeriodChange + 603900000L;
                nextValidStart = nextQuestStart + 603900000L + 900000L;
                break;
            }
            case 3: {
                nextQuestStart = nextPeriodChange;
                nextValidStart = nextPeriodChange + 603900000L + 900000L;
            }
        }
        return (nextQuestStart >= tillDate || tillDate >= nextValidStart) && (nextValidStart >= nextQuestStart || tillDate >= nextValidStart && nextQuestStart >= tillDate);
    }

    public final int getCurrentScore(int cabal) {
        double totalStoneScore = this._dawnStoneScore + this._duskStoneScore;
        return switch (cabal) {
            case 0 -> 0;
            case 2 -> Math.round((float)(this._dawnStoneScore / ((float)totalStoneScore == 0.0f ? 1.0 : totalStoneScore)) * 500.0f) + this._dawnFestivalScore;
            case 1 -> Math.round((float)(this._duskStoneScore / ((float)totalStoneScore == 0.0f ? 1.0 : totalStoneScore)) * 500.0f) + this._duskFestivalScore;
            default -> 0;
        };
    }

    public final double getCurrentStoneScore(int cabal) {
        return switch (cabal) {
            case 0 -> 0.0;
            case 2 -> this._dawnStoneScore;
            case 1 -> this._duskStoneScore;
            default -> 0.0;
        };
    }

    public final int getCurrentFestivalScore(int cabal) {
        return switch (cabal) {
            case 0 -> 0;
            case 2 -> this._dawnFestivalScore;
            case 1 -> this._duskFestivalScore;
            default -> 0;
        };
    }

    public final int getCabalHighestScore() {
        if (this.getCurrentScore(1) == this.getCurrentScore(2)) {
            return 0;
        }
        if (this.getCurrentScore(1) > this.getCurrentScore(2)) {
            return 1;
        }
        return 2;
    }

    public final int getSealOwner(int seal) {
        return this._signsSealOwners.get(seal);
    }

    public final int getSealProportion(int seal, int cabal) {
        if (cabal == 0) {
            return 0;
        }
        if (cabal == 1) {
            return this._signsDuskSealTotals.get(seal);
        }
        return this._signsDawnSealTotals.get(seal);
    }

    public final int getTotalMembers(int cabal) {
        int cabalMembers = 0;
        String cabalName = SevenSigns.getCabalShortName(cabal);
        for (StatsSet sevenDat : this._signsPlayerData.values()) {
            if (!sevenDat.getString("cabal").equals(cabalName)) continue;
            ++cabalMembers;
        }
        return cabalMembers;
    }

    public int getPlayerStoneContrib(int objectId) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        if (currPlayer == null) {
            return 0;
        }
        int stoneCount = 0;
        stoneCount += currPlayer.getInt("red_stones");
        stoneCount += currPlayer.getInt("green_stones");
        return stoneCount += currPlayer.getInt("blue_stones");
    }

    public int getDepositedSSQItemCount(L2PcInstance player, int stoneId) {
        StatsSet currPlayer = this._signsPlayerData.get(player.getObjectId());
        if (currPlayer == null) {
            return 0;
        }
        return switch (stoneId) {
            case 6360 -> currPlayer.getInt("blue_stones");
            case 6361 -> currPlayer.getInt("green_stones");
            case 6362 -> currPlayer.getInt("red_stones");
            default -> 0;
        };
    }

    public int deleteDepositedSSQItemAndGiveRewards(L2PcInstance player, int stoneId, int amount) {
        StatsSet currPlayer = this._signsPlayerData.get(player.getObjectId());
        int rewardAmount = amount * (switch (stoneId) {
            case 6360 -> 3;
            case 6361 -> 5;
            case 6362 -> 10;
            default -> 0;
        });
        player.addAncientAdena("SevenSigns", rewardAmount, player, true);
        currPlayer.set("red_stones", 0);
        currPlayer.set("green_stones", 0);
        currPlayer.set("blue_stones", 0);
        this._signsPlayerData.put(player.getObjectId(), currPlayer);
        if (!Configuration.sevenSigns().sevenSignsLazyUpdate()) {
            this.saveSevenSignsData(player.getObjectId());
            this.saveSevenSignsStatus();
        }
        return rewardAmount;
    }

    public int getPlayerContribScore(int objectId) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        if (currPlayer == null) {
            return 0;
        }
        return currPlayer.getInt("contribution_score");
    }

    public int getPlayerAdenaCollect(int objectId) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        if (currPlayer == null) {
            return 0;
        }
        return currPlayer.getInt("ancient_adena_amount");
    }

    public int getPlayerSeal(int objectId) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        if (currPlayer == null) {
            return 0;
        }
        return currPlayer.getInt("seal");
    }

    public int getPlayerCabal(int objectId) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        if (currPlayer == null) {
            return 0;
        }
        String playerCabal = currPlayer.getString("cabal");
        if (playerCabal.equalsIgnoreCase("dawn")) {
            return 2;
        }
        if (playerCabal.equalsIgnoreCase("dusk")) {
            return 1;
        }
        return 0;
    }

    public int getSSQPrevWinner() {
        return this._previousWinner;
    }

    protected void restoreSevenSignsData() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            ResultSet rs;
            try (Statement s = con.createStatement();){
                rs = s.executeQuery(LOAD_DATA);
                try {
                    while (rs.next()) {
                        int charObjId = rs.getInt("charId");
                        StatsSet sevenDat = new StatsSet();
                        sevenDat.set("charId", charObjId);
                        sevenDat.set("cabal", rs.getString("cabal"));
                        sevenDat.set("seal", rs.getInt("seal"));
                        sevenDat.set("position", rs.getInt("position"));
                        sevenDat.set("paid_type", rs.getInt("paid_type"));
                        sevenDat.set("red_stones", rs.getInt("red_stones"));
                        sevenDat.set("green_stones", rs.getInt("green_stones"));
                        sevenDat.set("blue_stones", rs.getInt("blue_stones"));
                        sevenDat.set("ancient_adena_amount", rs.getDouble("ancient_adena_amount"));
                        sevenDat.set("contribution_score", rs.getDouble("contribution_score"));
                        this._signsPlayerData.put(charObjId, sevenDat);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            s = con.createStatement();
            try {
                rs = s.executeQuery(LOAD_STATUS);
                try {
                    while (rs.next()) {
                        this._currentCycle = rs.getInt("current_cycle");
                        this._activePeriod = rs.getInt("active_period");
                        this._previousWinner = rs.getInt("previous_winner");
                        this._dawnStoneScore = rs.getDouble("dawn_stone_score");
                        this._dawnFestivalScore = rs.getInt("dawn_festival_score");
                        this._duskStoneScore = rs.getDouble("dusk_stone_score");
                        this._duskFestivalScore = rs.getInt("dusk_festival_score");
                        this._signsSealOwners.put(1, rs.getInt("avarice_owner"));
                        this._signsSealOwners.put(2, rs.getInt("gnosis_owner"));
                        this._signsSealOwners.put(3, rs.getInt("strife_owner"));
                        this._signsDawnSealTotals.put(1, rs.getInt("avarice_dawn_score"));
                        this._signsDawnSealTotals.put(2, rs.getInt("gnosis_dawn_score"));
                        this._signsDawnSealTotals.put(3, rs.getInt("strife_dawn_score"));
                        this._signsDuskSealTotals.put(1, rs.getInt("avarice_dusk_score"));
                        this._signsDuskSealTotals.put(2, rs.getInt("gnosis_dusk_score"));
                        this._signsDuskSealTotals.put(3, rs.getInt("strife_dusk_score"));
                        this._lastSave.setTimeInMillis(rs.getLong("date"));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (SQLException ex) {
            LOG.warn("Unable to load Seven Signs data from database!", ex);
        }
    }

    public void saveSevenSignsData() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(UPDATE_PLAYER);){
            for (StatsSet sevenDat : this._signsPlayerData.values()) {
                ps.setString(1, sevenDat.getString("cabal"));
                ps.setInt(2, sevenDat.getInt("seal"));
                ps.setInt(3, sevenDat.getInt("position"));
                ps.setInt(4, sevenDat.getInt("paid_type"));
                ps.setInt(5, sevenDat.getInt("red_stones"));
                ps.setInt(6, sevenDat.getInt("green_stones"));
                ps.setInt(7, sevenDat.getInt("blue_stones"));
                ps.setDouble(8, sevenDat.getDouble("ancient_adena_amount"));
                ps.setDouble(9, sevenDat.getDouble("contribution_score"));
                ps.setInt(10, sevenDat.getInt("charId"));
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException ex) {
            LOG.warn("Unable to save data to database!", ex);
        }
    }

    public final void saveSevenSignsData(int objectId) {
        StatsSet sevenDat = this._signsPlayerData.get(objectId);
        if (sevenDat == null) {
            return;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(UPDATE_PLAYER);){
            ps.setString(1, sevenDat.getString("cabal"));
            ps.setInt(2, sevenDat.getInt("seal"));
            ps.setInt(3, sevenDat.getInt("position"));
            ps.setInt(4, sevenDat.getInt("paid_type"));
            ps.setInt(5, sevenDat.getInt("red_stones"));
            ps.setInt(6, sevenDat.getInt("green_stones"));
            ps.setInt(7, sevenDat.getInt("blue_stones"));
            ps.setDouble(8, sevenDat.getDouble("ancient_adena_amount"));
            ps.setDouble(9, sevenDat.getDouble("contribution_score"));
            ps.setInt(10, sevenDat.getInt("charId"));
            ps.execute();
        }
        catch (SQLException ex) {
            LOG.error("Unable to save data to database!", ex);
        }
    }

    public final void saveSevenSignsStatus() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(UPDATE_STATUS);){
            ps.setInt(1, this._currentCycle);
            ps.setInt(2, this._activePeriod);
            ps.setInt(3, this._previousWinner);
            ps.setDouble(4, this._dawnStoneScore);
            ps.setInt(5, this._dawnFestivalScore);
            ps.setDouble(6, this._duskStoneScore);
            ps.setInt(7, this._duskFestivalScore);
            ps.setInt(8, this._signsSealOwners.get(1));
            ps.setInt(9, this._signsSealOwners.get(2));
            ps.setInt(10, this._signsSealOwners.get(3));
            ps.setInt(11, this._signsDawnSealTotals.get(1));
            ps.setInt(12, this._signsDawnSealTotals.get(2));
            ps.setInt(13, this._signsDawnSealTotals.get(3));
            ps.setInt(14, this._signsDuskSealTotals.get(1));
            ps.setInt(15, this._signsDuskSealTotals.get(2));
            ps.setInt(16, this._signsDuskSealTotals.get(3));
            ps.setInt(17, SevenSignsFestival.getInstance().getCurrentFestivalCycle());
            for (int i = 0; i < 5; ++i) {
                ps.setInt(18 + i, SevenSignsFestival.getInstance().getAccumulatedBonus(i));
            }
            this._lastSave = Calendar.getInstance();
            ps.setLong(23, this._lastSave.getTimeInMillis());
            ps.execute();
        }
        catch (SQLException ex) {
            LOG.warn("Unable to save data to database!", ex);
        }
    }

    protected void resetPlayerData() {
        for (StatsSet sevenDat : this._signsPlayerData.values()) {
            sevenDat.set("cabal", "");
            sevenDat.set("seal", 0);
            sevenDat.set("position", 0);
            sevenDat.set("paid_type", 0);
            sevenDat.set("contribution_score", 0);
        }
    }

    public int addSSQMember(L2PcInstance player, int chosenCabal, int chosenSeal, int position, int score, int paidType) {
        StatsSet currPlayerData = this._signsPlayerData.get(player.getObjectId());
        if (currPlayerData != null) {
            currPlayerData.set("cabal", SevenSigns.getCabalShortName(chosenCabal));
            currPlayerData.set("seal", chosenSeal);
            currPlayerData.set("position", position);
            currPlayerData.set("paid_type", paidType);
            currPlayerData.set("contribution_score", score);
            this._signsPlayerData.put(player.getObjectId(), currPlayerData);
        } else {
            currPlayerData = new StatsSet();
            currPlayerData.set("charId", player.getObjectId());
            currPlayerData.set("cabal", SevenSigns.getCabalShortName(chosenCabal));
            currPlayerData.set("seal", chosenSeal);
            currPlayerData.set("position", position);
            currPlayerData.set("paid_type", paidType);
            currPlayerData.set("red_stones", 0);
            currPlayerData.set("green_stones", 0);
            currPlayerData.set("blue_stones", 0);
            currPlayerData.set("ancient_adena_amount", 0);
            currPlayerData.set("contribution_score", 0);
            this._signsPlayerData.put(player.getObjectId(), currPlayerData);
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement ps = con.prepareStatement(INSERT_PLAYER);){
                ps.setInt(1, player.getObjectId());
                ps.setString(2, SevenSigns.getCabalShortName(chosenCabal));
                ps.setInt(3, chosenSeal);
                ps.setInt(4, position);
                ps.setInt(5, paidType);
                ps.execute();
            }
            catch (SQLException ex) {
                LOG.warn("Failed to save data!", ex);
            }
        }
        if ("dawn".equals(currPlayerData.getString("cabal"))) {
            this._signsDawnSealTotals.put(chosenSeal, this._signsDawnSealTotals.get(chosenSeal) + 1);
        } else {
            this._signsDuskSealTotals.put(chosenSeal, this._signsDuskSealTotals.get(chosenSeal) + 1);
        }
        if (!Configuration.sevenSigns().sevenSignsLazyUpdate()) {
            this.saveSevenSignsStatus();
        }
        return chosenCabal;
    }

    public int getAncientAdenaReward(int objectId, boolean removeReward) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        int rewardAmount = currPlayer.getInt("ancient_adena_amount");
        currPlayer.set("red_stones", 0);
        currPlayer.set("green_stones", 0);
        currPlayer.set("blue_stones", 0);
        currPlayer.set("ancient_adena_amount", 0);
        if (removeReward) {
            this._signsPlayerData.put(objectId, currPlayer);
            if (!Configuration.sevenSigns().sevenSignsLazyUpdate()) {
                this.saveSevenSignsData(objectId);
                this.saveSevenSignsStatus();
            }
        }
        return rewardAmount;
    }

    public long depositSSQItem(L2PcInstance player, long blueCount, long greenCount, long redCount) {
        StatsSet currPlayer = this._signsPlayerData.get(player.getObjectId());
        long contribScore = SevenSigns.calcContributionScore(blueCount, greenCount, redCount);
        long totalAncientAdena = currPlayer.getLong("ancient_adena_amount") + SevenSigns.calcAncientAdenaReward(blueCount, greenCount, redCount);
        long totalContribScore = currPlayer.getLong("contribution_score") + contribScore;
        if (totalContribScore > (long)Configuration.sevenSigns().getMaxPlayerContrib()) {
            return -1L;
        }
        currPlayer.set("red_stones", (long)currPlayer.getInt("red_stones") + redCount);
        currPlayer.set("green_stones", (long)currPlayer.getInt("green_stones") + greenCount);
        currPlayer.set("blue_stones", (long)currPlayer.getInt("blue_stones") + blueCount);
        currPlayer.set("ancient_adena_amount", totalAncientAdena);
        currPlayer.set("contribution_score", totalContribScore);
        this._signsPlayerData.put(player.getObjectId(), currPlayer);
        switch (this.getPlayerCabal(player.getObjectId())) {
            case 2: {
                this._dawnStoneScore += (double)contribScore;
                break;
            }
            case 1: {
                this._duskStoneScore += (double)contribScore;
            }
        }
        if (!Configuration.sevenSigns().sevenSignsLazyUpdate()) {
            this.saveSevenSignsData(player.getObjectId());
            this.saveSevenSignsStatus();
        }
        return contribScore;
    }

    public static long calcContributionScore(long blueCount, long greenCount, long redCount) {
        long contrib = blueCount * 3L;
        contrib += greenCount * 5L;
        return contrib += redCount * 10L;
    }

    public static long calcAncientAdenaReward(long blueCount, long greenCount, long redCount) {
        long reward = blueCount * 3L;
        reward += greenCount * 5L;
        return reward += redCount * 10L;
    }

    public void addFestivalScore(int cabal, int amount) {
        if (cabal == 1) {
            this._duskFestivalScore += amount;
            if (this._dawnFestivalScore >= amount) {
                this._dawnFestivalScore -= amount;
            }
        } else {
            this._dawnFestivalScore += amount;
            if (this._duskFestivalScore >= amount) {
                this._duskFestivalScore -= amount;
            }
        }
    }

    public void sendCurrentPeriodMsg(L2PcInstance player) {
        SystemMessage sm = switch (this.getCurrentPeriod()) {
            case 0 -> SystemMessage.getSystemMessage(SystemMessageId.PREPARATIONS_PERIOD_BEGUN);
            case 1 -> SystemMessage.getSystemMessage(SystemMessageId.COMPETITION_PERIOD_BEGUN);
            case 2 -> SystemMessage.getSystemMessage(SystemMessageId.RESULTS_PERIOD_BEGUN);
            case 3 -> SystemMessage.getSystemMessage(SystemMessageId.VALIDATION_PERIOD_BEGUN);
            default -> null;
        };
        player.sendPacket(sm);
    }

    public void sendMessageToAll(SystemMessageId sysMsgId) {
        Broadcast.toAllOnlinePlayers(SystemMessage.getSystemMessage(sysMsgId));
    }

    protected void initializeSeals() {
        for (Map.Entry<Integer, Integer> e : this._signsSealOwners.entrySet()) {
            if (e.getValue() != 0) {
                if (this.isSealValidationPeriod()) {
                    LOG.info("The {} have won the {}.", (Object)SevenSigns.getCabalName(e.getValue()), (Object)SevenSigns.getSealName(e.getKey(), false));
                    continue;
                }
                LOG.info("The {} is currently owned by {}.", (Object)SevenSigns.getSealName(e.getKey(), false), (Object)SevenSigns.getCabalName(e.getValue()));
                continue;
            }
            LOG.info("The {} remains unclaimed.", (Object)SevenSigns.getSealName(e.getKey(), false));
        }
    }

    protected void resetSeals() {
        this._signsDawnSealTotals.put(1, 0);
        this._signsDawnSealTotals.put(2, 0);
        this._signsDawnSealTotals.put(3, 0);
        this._signsDuskSealTotals.put(1, 0);
        this._signsDuskSealTotals.put(2, 0);
        this._signsDuskSealTotals.put(3, 0);
    }

    protected void calcNewSealOwners() {
        for (Integer currSeal : this._signsDawnSealTotals.keySet()) {
            int prevSealOwner = this._signsSealOwners.get(currSeal);
            int newSealOwner = 0;
            int dawnProportion = this.getSealProportion(currSeal, 2);
            int totalDawnMembers = this.getTotalMembers(2) == 0 ? 1 : this.getTotalMembers(2);
            int dawnPercent = Math.round((float)dawnProportion / (float)totalDawnMembers * 100.0f);
            int duskProportion = this.getSealProportion(currSeal, 1);
            int totalDuskMembers = this.getTotalMembers(1) == 0 ? 1 : this.getTotalMembers(1);
            int duskPercent = Math.round((float)duskProportion / (float)totalDuskMembers * 100.0f);
            block0 : switch (prevSealOwner) {
                case 0: {
                    switch (this.getCabalHighestScore()) {
                        case 0: {
                            newSealOwner = 0;
                            break;
                        }
                        case 2: {
                            if (dawnPercent >= 35) {
                                newSealOwner = 2;
                                break;
                            }
                            newSealOwner = 0;
                            break;
                        }
                        case 1: {
                            newSealOwner = duskPercent >= 35 ? 1 : 0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.getCabalHighestScore()) {
                        case 0: {
                            if (dawnPercent >= 10) {
                                newSealOwner = 2;
                                break;
                            }
                            newSealOwner = 0;
                            break;
                        }
                        case 2: {
                            if (dawnPercent >= 10) {
                                newSealOwner = 2;
                                break;
                            }
                            newSealOwner = 0;
                            break;
                        }
                        case 1: {
                            newSealOwner = duskPercent >= 35 ? 1 : (dawnPercent >= 10 ? 2 : 0);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.getCabalHighestScore()) {
                        case 0: {
                            if (duskPercent >= 10) {
                                newSealOwner = 1;
                                break block0;
                            }
                            newSealOwner = 0;
                            break block0;
                        }
                        case 2: {
                            if (dawnPercent >= 35) {
                                newSealOwner = 2;
                                break block0;
                            }
                            if (duskPercent >= 10) {
                                newSealOwner = 1;
                                break block0;
                            }
                            newSealOwner = 0;
                            break block0;
                        }
                        case 1: {
                            newSealOwner = duskPercent >= 10 ? 1 : 0;
                        }
                    }
                }
            }
            this._signsSealOwners.put(currSeal, newSealOwner);
            switch (currSeal) {
                case 1: {
                    if (newSealOwner == 2) {
                        this.sendMessageToAll(SystemMessageId.DAWN_OBTAINED_AVARICE);
                        break;
                    }
                    if (newSealOwner != 1) break;
                    this.sendMessageToAll(SystemMessageId.DUSK_OBTAINED_AVARICE);
                    break;
                }
                case 2: {
                    if (newSealOwner == 2) {
                        this.sendMessageToAll(SystemMessageId.DAWN_OBTAINED_GNOSIS);
                        break;
                    }
                    if (newSealOwner != 1) break;
                    this.sendMessageToAll(SystemMessageId.DUSK_OBTAINED_GNOSIS);
                    break;
                }
                case 3: {
                    if (newSealOwner == 2) {
                        this.sendMessageToAll(SystemMessageId.DAWN_OBTAINED_STRIFE);
                    } else if (newSealOwner == 1) {
                        this.sendMessageToAll(SystemMessageId.DUSK_OBTAINED_STRIFE);
                    }
                    CastleManager.getInstance().validateTaxes(newSealOwner);
                }
            }
        }
    }

    protected void teleLosingCabalFromDungeons(String compWinner) {
        for (L2PcInstance player : L2World.getInstance().getPlayers()) {
            StatsSet currPlayer = this._signsPlayerData.get(player.getObjectId());
            if (this.isSealValidationPeriod() || this.isCompResultsPeriod()) {
                if (player.isGM() || !player.isIn7sDungeon() || currPlayer != null && currPlayer.getString("cabal").equals(compWinner)) continue;
                player.teleToLocation(TeleportWhereType.TOWN);
                player.setIsIn7sDungeon(false);
                continue;
            }
            if (player.isGM() || !player.isIn7sDungeon() || currPlayer != null && currPlayer.getString("cabal").isEmpty()) continue;
            player.teleToLocation(TeleportWhereType.TOWN);
            player.setIsIn7sDungeon(false);
        }
    }

    public boolean checkIsDawnPostingTicket(int itemId) {
        if (itemId > 6114 && itemId < 6175) {
            return true;
        }
        if (itemId > 6801 && itemId < 6812) {
            return true;
        }
        if (itemId > 7997 && itemId < 8008) {
            return true;
        }
        if (itemId > 7940 && itemId < 7951) {
            return true;
        }
        if (itemId > 6294 && itemId < 6307) {
            return true;
        }
        if (itemId > 6831 && itemId < 6834) {
            return true;
        }
        if (itemId > 8027 && itemId < 8030) {
            return true;
        }
        return itemId > 7970 && itemId < 7973;
    }

    public boolean checkIsRookiePostingTicket(int itemId) {
        if (itemId > 6174 && itemId < 6295) {
            return true;
        }
        if (itemId > 6811 && itemId < 6832) {
            return true;
        }
        if (itemId > 7950 && itemId < 7971) {
            return true;
        }
        return itemId > 8007 && itemId < 8028;
    }

    public void giveCPMult(int strifeOwner) {
        for (L2PcInstance player : L2World.getInstance().getPlayers()) {
            int cabal = this.getPlayerCabal(player.getObjectId());
            if (cabal == 0) continue;
            if (cabal == strifeOwner) {
                player.addSkill(CommonSkill.THE_VICTOR_OF_WAR.getSkill());
                continue;
            }
            player.addSkill(CommonSkill.THE_VANQUISHED_OF_WAR.getSkill());
        }
    }

    public void removeCPMult() {
        for (L2PcInstance player : L2World.getInstance().getPlayers()) {
            player.removeSkill(CommonSkill.THE_VICTOR_OF_WAR.getSkill());
            player.removeSkill(CommonSkill.THE_VANQUISHED_OF_WAR.getSkill());
        }
    }

    public boolean checkSummonConditions(L2PcInstance activeChar) {
        if (activeChar == null) {
            return true;
        }
        if (this.isSealValidationPeriod() && this.getSealOwner(3) == 2 && this.getPlayerCabal(activeChar.getObjectId()) == 1) {
            activeChar.sendPacket(SystemMessageId.SEAL_OF_STRIFE_FORBIDS_SUMMONING);
            return true;
        }
        return false;
    }

    public static SevenSigns getInstance() {
        return SingletonHolder.INSTANCE;
    }

    protected class SevenSignsPeriodChange
    implements Runnable {
        protected SevenSignsPeriodChange() {
        }

        @Override
        public void run() {
            int periodEnded = SevenSigns.this.getCurrentPeriod();
            ++SevenSigns.this._activePeriod;
            switch (periodEnded) {
                case 0: {
                    SevenSignsFestival.getInstance().startFestivalManager();
                    SevenSigns.this.sendMessageToAll(SystemMessageId.QUEST_EVENT_PERIOD_BEGUN);
                    break;
                }
                case 1: {
                    SevenSigns.this.sendMessageToAll(SystemMessageId.QUEST_EVENT_PERIOD_ENDED);
                    int compWinner = SevenSigns.this.getCabalHighestScore();
                    SevenSignsFestival.getInstance().getFestivalManagerSchedule().cancel(false);
                    SevenSignsFestival.getInstance().rewardHighestRanked();
                    SevenSigns.this.calcNewSealOwners();
                    switch (compWinner) {
                        case 2: {
                            SevenSigns.this.sendMessageToAll(SystemMessageId.DAWN_WON);
                            break;
                        }
                        case 1: {
                            SevenSigns.this.sendMessageToAll(SystemMessageId.DUSK_WON);
                        }
                    }
                    SevenSigns.this._previousWinner = compWinner;
                    List<Castle> castles = CastleManager.getInstance().getCastles();
                    for (Castle castle : castles) {
                        castle.setTicketBuyCount(0);
                    }
                    break;
                }
                case 2: {
                    SevenSigns.this.initializeSeals();
                    SevenSigns.this.giveCPMult(SevenSigns.this.getSealOwner(3));
                    SevenSigns.this.sendMessageToAll(SystemMessageId.SEAL_VALIDATION_PERIOD_BEGUN);
                    LOG.info("The {} have won the competition with {} points!", (Object)SevenSigns.getCabalName(SevenSigns.this._previousWinner), (Object)SevenSigns.this.getCurrentScore(SevenSigns.this._previousWinner));
                    break;
                }
                case 3: {
                    SevenSigns.this._activePeriod = 0;
                    SevenSigns.this.sendMessageToAll(SystemMessageId.SEAL_VALIDATION_PERIOD_ENDED);
                    SevenSigns.this.removeCPMult();
                    SevenSigns.this.resetPlayerData();
                    SevenSigns.this.resetSeals();
                    ++SevenSigns.this._currentCycle;
                    SevenSignsFestival.getInstance().resetFestivalData(false);
                    SevenSigns.this._dawnStoneScore = 0.0;
                    SevenSigns.this._duskStoneScore = 0.0;
                    SevenSigns.this._dawnFestivalScore = 0;
                    SevenSigns.this._duskFestivalScore = 0;
                }
            }
            SevenSigns.this.saveSevenSignsData();
            SevenSigns.this.saveSevenSignsStatus();
            SevenSigns.this.teleLosingCabalFromDungeons(SevenSigns.getCabalShortName(SevenSigns.this.getCabalHighestScore()));
            SSQInfo ss = new SSQInfo();
            Broadcast.toAllOnlinePlayers(ss);
            SevenSigns.this.spawnSevenSignsNPC();
            LOG.info("The {} period has begun!", (Object)SevenSigns.this.getCurrentPeriodName());
            SevenSigns.this.setCalendarForNextPeriodChange();
            SevenSignsPeriodChange sspc = new SevenSignsPeriodChange();
            ThreadPoolManager.getInstance().scheduleGeneral(sspc, SevenSigns.this.getMilliToPeriodChange());
        }
    }

    private static class SingletonHolder {
        protected static final SevenSigns INSTANCE = new SevenSigns();

        private SingletonHolder() {
        }
    }
}

